/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.security.permission;

import java.io.Serializable;
import java.util.List;
import java.util.Set;
import org.drools.guvnor.server.ServiceImplementation;
import org.drools.guvnor.server.security.AdminType;
import org.drools.guvnor.server.security.CategoryPathType;
import org.drools.guvnor.server.security.PackageNameType;
import org.drools.guvnor.server.security.PackageUUIDType;
import org.drools.guvnor.server.security.RoleBasedPermission;
import org.drools.guvnor.server.security.RoleBasedPermissionManager;
import org.drools.guvnor.server.security.WebDavPackageNameType;
import org.drools.guvnor.server.util.LoggingHelper;
import org.drools.repository.RulesRepositoryException;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.Startup;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.security.permission.PermissionResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Name(value="org.jboss.seam.security.roleBasedPermissionResolver")
@Scope(value=ScopeType.APPLICATION)
@BypassInterceptors
@Install(precedence=20)
@Startup
public class RoleBasedPermissionResolver
implements PermissionResolver,
Serializable {
    private static final LoggingHelper log = LoggingHelper.getLogger(RoleBasedPermissionResolver.class);
    private boolean enableRoleBasedAuthorization = false;

    @Create
    public void create() {
    }

    public boolean hasPermission(Object requestedObject, String requestedPermission) {
        if (!(requestedObject instanceof CategoryPathType || requestedObject instanceof PackageNameType || requestedObject instanceof WebDavPackageNameType || requestedObject instanceof AdminType || requestedObject instanceof PackageUUIDType)) {
            log.debug("Requested permission is not an instance of CategoryPathType|PackageNameType|WebDavPackageNameType|AdminType|PackageUUIDType");
            return false;
        }
        if (!this.enableRoleBasedAuthorization) {
            return true;
        }
        RoleBasedPermissionManager permManager = (RoleBasedPermissionManager)Component.getInstance((String)"roleBasedPermissionManager");
        List permissions = permManager.getRoleBasedPermission();
        if (this.hasAdminPermission(permissions)) {
            return true;
        }
        if ("admin".equals(requestedPermission)) {
            return this.hasAdminPermission(permissions);
        }
        if (requestedObject instanceof CategoryPathType) {
            String requestedPermType;
            String requestedPath = ((CategoryPathType)requestedObject).getCategoryPath();
            String string = requestedPermType = requestedPermission == null ? "analyst" : requestedPermission;
            if (requestedPermType.equals("navigate")) {
                for (RoleBasedPermission p : permissions) {
                    if (p.getCategoryPath() == null) continue;
                    if (p.getCategoryPath().equals(requestedPath)) {
                        return true;
                    }
                    if (this.isSubPath(requestedPath, p.getCategoryPath())) {
                        log.debug("Requested permission: " + requestedPermType + ", Requested object: " + requestedPath + " , Permission granted: Yes");
                        return true;
                    }
                    if (!this.isSubPath(p.getCategoryPath(), requestedPath)) continue;
                    log.debug("Requested permission: " + requestedPermType + ", Requested object: " + requestedPath + " , Permission granted: Yes");
                    return true;
                }
                log.debug("Requested permission: " + requestedPermType + ", Requested object: " + requestedPath + " , Permission granted: No");
                return false;
            }
            for (RoleBasedPermission pbp : permissions) {
                if (!pbp.getRole().equals("analyst") && !pbp.getRole().equals("analyst.readonly") || !requestedPermType.equals(pbp.getRole()) && (!requestedPermType.equals("analyst.readonly") || !pbp.getRole().equals("analyst")) || !this.isPermittedCategoryPath(requestedPath, pbp.getCategoryPath())) continue;
                log.debug("Requested permission: " + requestedPermType + ", Requested object: " + requestedPath + " , Permission granted: Yes");
                return true;
            }
            log.debug("Requested permission: " + requestedPermType + ", Requested object: " + requestedPath + " , Permission granted: No");
            return false;
        }
        String targetName = "";
        if (requestedObject instanceof PackageUUIDType) {
            String targetUUID = ((PackageUUIDType)requestedObject).getUUID();
            try {
                ServiceImplementation si = (ServiceImplementation)Component.getInstance((String)"org.drools.guvnor.client.rpc.RepositoryService");
                targetName = si.repository.loadPackageByUUID(targetUUID).getName();
            }
            catch (RulesRepositoryException e) {
                return false;
            }
        } else if (requestedObject instanceof PackageNameType) {
            targetName = ((PackageNameType)requestedObject).getPackageName();
        }
        for (RoleBasedPermission pbp : permissions) {
            if (!targetName.equalsIgnoreCase(pbp.getPackageName()) || !this.isPermittedPackage(requestedPermission, pbp.getRole())) continue;
            log.debug("Requested permission: " + requestedPermission + ", Requested object: " + targetName + " , Permission granted: Yes");
            return true;
        }
        log.debug("Requested permission: " + requestedPermission + ", Requested object: " + targetName + " , Permission granted: No");
        return false;
    }

    private boolean hasAdminPermission(List<RoleBasedPermission> permissions) {
        for (RoleBasedPermission p : permissions) {
            if (!"admin".equalsIgnoreCase(p.getRole())) continue;
            log.debug("Requested permission: unknown, Permission granted: Yes");
            return true;
        }
        log.debug("Requested permission: admin, Permission granted: No");
        return false;
    }

    private boolean isPermittedCategoryPath(String requestedPath, String allowedPath) {
        if (requestedPath == null && allowedPath == null) {
            return true;
        }
        if (requestedPath == null || allowedPath == null) {
            return false;
        }
        return requestedPath.equals(allowedPath) || this.isSubPath(allowedPath, requestedPath);
    }

    private boolean isPermittedPackage(String requestedAction, String role) {
        if ("package.admin".equalsIgnoreCase(role)) {
            return true;
        }
        if ("package.developer".equalsIgnoreCase(role)) {
            if ("package.admin".equalsIgnoreCase(requestedAction)) {
                return false;
            }
            if ("package.developer".equalsIgnoreCase(requestedAction)) {
                return true;
            }
            if ("package.readonly".equalsIgnoreCase(requestedAction)) {
                return true;
            }
        } else if ("package.readonly".equalsIgnoreCase(role)) {
            if ("package.admin".equalsIgnoreCase(requestedAction)) {
                return false;
            }
            if ("package.developer".equalsIgnoreCase(requestedAction)) {
                return false;
            }
            if ("package.readonly".equalsIgnoreCase(requestedAction)) {
                return true;
            }
        }
        return false;
    }

    boolean isSubPath(String parentPath, String subPath) {
        String[] subTags;
        parentPath = parentPath.startsWith("/") ? parentPath.substring(1) : parentPath;
        subPath = subPath.startsWith("/") ? subPath.substring(1) : subPath;
        String[] parentTags = parentPath.split("/");
        if (parentTags.length > (subTags = subPath.split("/")).length) {
            return false;
        }
        for (int i = 0; i < parentTags.length; ++i) {
            if (parentTags[i].equals(subTags[i])) continue;
            return false;
        }
        return true;
    }

    public void filterSetByAction(Set<Object> targets, String action) {
    }

    public boolean isEnableRoleBasedAuthorization() {
        return this.enableRoleBasedAuthorization;
    }

    public void setEnableRoleBasedAuthorization(boolean enableRoleBasedAuthorization) {
        this.enableRoleBasedAuthorization = enableRoleBasedAuthorization;
    }
}

