/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.contenthandler;

import com.google.gwt.user.client.rpc.SerializationException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import org.drools.compiler.DroolsParserException;
import org.drools.guvnor.client.rpc.RuleAsset;
import org.drools.guvnor.client.rpc.RuleContentText;
import org.drools.guvnor.server.builder.BRMSPackageBuilder;
import org.drools.guvnor.server.builder.ContentAssemblyError;
import org.drools.guvnor.server.builder.ContentPackageAssembler;
import org.drools.guvnor.server.contenthandler.ContentHandler;
import org.drools.guvnor.server.contenthandler.DRLFileContentHandler;
import org.drools.guvnor.server.contenthandler.IRuleAsset;
import org.drools.lang.ExpanderException;
import org.drools.lang.dsl.DefaultExpander;
import org.drools.repository.AssetItem;
import org.drools.repository.PackageItem;
import org.drools.repository.VersionableItem;

public class DSLRuleContentHandler
extends ContentHandler
implements IRuleAsset {
    public void retrieveAssetContent(RuleAsset asset, PackageItem pkg, AssetItem item) throws SerializationException {
        RuleContentText text = new RuleContentText();
        text.content = item.getContent();
        asset.content = text;
    }

    public void storeAssetContent(RuleAsset asset, AssetItem repoAsset) throws SerializationException {
        RuleContentText text = (RuleContentText)asset.content;
        repoAsset.updateContent(text.content);
    }

    public void compile(BRMSPackageBuilder builder, AssetItem asset, ContentPackageAssembler.ErrorLogger logger) throws DroolsParserException, IOException {
        DefaultExpander expander = this.getExpander(builder, asset, logger);
        String source = asset.getContent();
        if (DRLFileContentHandler.isStandAloneRule((String)source)) {
            String parentName = this.parentNameFromCategory(asset, "");
            source = this.wrapRule(asset, parentName, source);
        }
        String drl = expander.expand(source);
        if (expander.hasErrors()) {
            List exErrs = expander.getErrors();
            for (ExpanderException ex : exErrs) {
                logger.logError(new ContentAssemblyError((VersionableItem)asset, ex.getMessage()));
            }
            return;
        }
        builder.addPackageFromDrl((Reader)new StringReader(drl));
    }

    private DefaultExpander getExpander(BRMSPackageBuilder builder, AssetItem asset, ContentPackageAssembler.ErrorLogger logger) {
        if (!builder.hasDSL()) {
            logger.logError(new ContentAssemblyError((VersionableItem)asset, "This rule asset requires a DSL, yet none were configured in the package."));
        }
        return builder.getDSLExpander();
    }

    public void assembleDRL(BRMSPackageBuilder builder, AssetItem asset, StringBuffer buf) {
        String source = this.getRawDRL(asset);
        DefaultExpander expander = builder.getDSLExpander();
        buf.append(expander.expand(source));
    }

    private String wrapRule(AssetItem asset, String parentName, String source) {
        if (parentName == null || "".equals(parentName)) {
            return "rule '" + asset.getName() + "' \n" + source + "\nend";
        }
        return "rule '" + asset.getName() + "' extends " + parentName + " \n" + source + "\nend";
    }

    public String getRawDRL(AssetItem asset) {
        String source = asset.getContent();
        if (DRLFileContentHandler.isStandAloneRule((String)source)) {
            String parentName = this.parentNameFromCategory(asset, "");
            source = this.wrapRule(asset, parentName, source);
        }
        return source;
    }
}

