/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.ruleeditor;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.ChangeListener;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.MissingResourceException;
import org.drools.factconstraints.client.ConstraintConfiguration;
import org.drools.guvnor.client.messages.Constants;

public class ConstraintEditor
extends Composite {
    private Constants constants = (Constants)GWT.create(Constants.class);
    private ConstraintConfiguration config;

    public ConstraintEditor(ConstraintConfiguration config) {
        this.config = config;
        Grid confGrid = new Grid(config.getArgumentKeys().size(), 2);
        ArrayList<String> list = new ArrayList<String>();
        HashMap<String, String> argI18N = new HashMap<String, String>();
        for (String arg : config.getArgumentKeys()) {
            String i18n = this.getI18NText(arg);
            list.add(i18n);
            argI18N.put(i18n, arg);
        }
        Collections.sort(list);
        int row = 0;
        for (String arg : list) {
            TextBox argTB = new TextBox();
            argTB.setText(this.getConstraintConfiguration().getArgumentValue(arg).toString());
            argTB.setName((String)argI18N.get(arg));
            argTB.setTitle(arg);
            argTB.addChangeListener((ChangeListener)new /* Unavailable Anonymous Inner Class!! */);
            confGrid.setWidget(row, 0, (Widget)new Label(arg + ":"));
            confGrid.setWidget(row, 1, (Widget)argTB);
            ++row;
        }
        this.initWidget((Widget)confGrid);
    }

    private String getI18NText(String s) {
        try {
            return this.constants.getString("constraint." + this.getConstraintName() + "." + s);
        }
        catch (MissingResourceException e) {
            return s;
        }
    }

    public ConstraintConfiguration getConstraintConfiguration() {
        return this.config;
    }

    public void setConstraintConfiguration(ConstraintConfiguration config) {
        this.config = config;
    }

    public String getConstraintName() {
        return this.getConstraintConfiguration().getConstraintName();
    }
}

