/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.qa;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Tree;
import com.google.gwt.user.client.ui.TreeItem;
import com.google.gwt.user.client.ui.TreeListener;
import com.google.gwt.user.client.ui.Widget;
import com.gwtext.client.util.Format;
import org.drools.guvnor.client.common.FormStyleLayout;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.qa.FactUsagesItem;
import org.drools.guvnor.client.qa.VerifierMessageLinesItem;
import org.drools.guvnor.client.rpc.AnalysisReport;
import org.drools.guvnor.client.rpc.AnalysisReportLine;
import org.drools.guvnor.client.rulelist.EditItemEvent;

public class VerifierResultWidget
extends Composite {
    private Constants constants = (Constants)GWT.create(Constants.class);
    private EditItemEvent edit = null;

    public VerifierResultWidget(AnalysisReport report, boolean showFactUsage, EditItemEvent edit) {
        this(report, showFactUsage);
        this.edit = edit;
    }

    public VerifierResultWidget(AnalysisReport report, boolean showFactUsage) {
        FormStyleLayout layout = new FormStyleLayout();
        Tree tree = new Tree();
        TreeItem errors = this.doMessageLines(this.constants.Errors(), "images/error.gif", report.errors);
        tree.addItem(errors);
        TreeItem warnings = this.doMessageLines(this.constants.Warnings(), "images/warning.gif", report.warnings);
        tree.addItem(warnings);
        TreeItem notes = this.doMessageLines(this.constants.Notes(), "images/note.gif", report.notes);
        tree.addItem(notes);
        if (showFactUsage) {
            tree.addItem((TreeItem)new FactUsagesItem(report.factUsages));
        }
        tree.addTreeListener(this.swapTitleWithUserObject());
        layout.addRow((Widget)tree);
        this.initWidget((Widget)layout);
    }

    private TreeItem doMessageLines(String messageType, String icon, AnalysisReportLine[] lines) {
        String summary = Format.format((String)this.constants.analysisResultSummary(), (String)messageType, (String)("" + lines.length));
        String topicHtml = Format.format((String)"<img src='{0}' /> &nbsp; {1}", (String)icon, (String)summary);
        VerifierMessageLinesItem linesItem = new VerifierMessageLinesItem(topicHtml, lines, this.edit);
        return linesItem;
    }

    private TreeListener swapTitleWithUserObject() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }
}

