/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.util;

import java.io.Reader;
import java.io.StringReader;
import java.util.Collection;
import org.drools.builder.ResourceType;
import org.drools.guvnor.client.common.AssetFormats;
import org.drools.guvnor.client.rpc.AnalysisReport;
import org.drools.guvnor.server.ServiceImplementation;
import org.drools.guvnor.server.contenthandler.ContentHandler;
import org.drools.guvnor.server.contenthandler.ContentManager;
import org.drools.guvnor.server.contenthandler.IRuleAsset;
import org.drools.guvnor.server.util.VerifierReportCreator;
import org.drools.io.ResourceFactory;
import org.drools.repository.AssetItem;
import org.drools.repository.AssetItemIterator;
import org.drools.repository.PackageItem;
import org.drools.verifier.DefaultVerifierConfiguration;
import org.drools.verifier.Verifier;
import org.drools.verifier.VerifierConfiguration;
import org.drools.verifier.VerifierConfigurationImpl;
import org.drools.verifier.VerifierError;
import org.drools.verifier.builder.VerifierBuilderFactory;
import org.drools.verifier.data.VerifierReport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VerifierRunner {
    private Verifier verifier;
    private PackageItem packageItem;
    private boolean useDefaultConfig = true;

    public AnalysisReport verify(String drl, String scope) {
        return this.verify(drl, scope, null);
    }

    public AnalysisReport verify(String drl, String scope, Collection<String> additionalVerifierRules) {
        this.initVerifier(scope, additionalVerifierRules);
        this.verifier.addResourcesToVerify(ResourceFactory.newReaderResource((Reader)new StringReader(drl)), ResourceType.DRL);
        VerifierReport res = this.fireAnalysis();
        return VerifierReportCreator.doReport((VerifierReport)res);
    }

    public AnalysisReport verify(PackageItem packageItem, String scope, Collection<String> additionalVerifierRules) {
        this.packageItem = packageItem;
        this.initVerifier(scope, additionalVerifierRules);
        this.addHeaderToVerifier();
        this.addToVerifier(packageItem.listAssetsByFormat(new String[]{"dsl"}), ResourceType.DSL);
        this.addToVerifier(packageItem.listAssetsByFormat(new String[]{"model.drl"}), ResourceType.DRL);
        this.addToVerifier(packageItem.listAssetsByFormat(new String[]{"function"}), ResourceType.DRL);
        this.addToVerifier(packageItem.listAssetsByFormat(new String[]{"drl"}), ResourceType.DRL);
        this.addToRulesVerifier();
        this.fireAnalysis();
        VerifierReport report = this.verifier.getResult();
        return VerifierReportCreator.doReport((VerifierReport)report);
    }

    private VerifierReport fireAnalysis() throws RuntimeException {
        this.verifier.fireAnalysis();
        if (this.verifier.hasErrors()) {
            StringBuilder message = new StringBuilder("Verifier Errors:\n");
            for (VerifierError verifierError : this.verifier.getErrors()) {
                message.append("\t");
                message.append(verifierError.getMessage());
                message.append("\n");
            }
            throw new RuntimeException(message.toString());
        }
        return this.verifier.getResult();
    }

    private void initVerifier(String scope, Collection<String> additionalVerifierRules) {
        Object conf = new DefaultVerifierConfiguration();
        conf = this.useDefaultConfig ? new DefaultVerifierConfiguration() : new VerifierConfigurationImpl();
        conf.getVerifyingScopes().clear();
        conf.getVerifyingScopes().add(scope);
        conf.setAcceptRulesWithoutVerifiyingScope(true);
        if (additionalVerifierRules != null) {
            for (String rule : additionalVerifierRules) {
                conf.getVerifyingResources().put(ResourceFactory.newByteArrayResource((byte[])rule.getBytes()), ResourceType.DRL);
            }
        }
        this.verifier = VerifierBuilderFactory.newVerifierBuilder().newVerifier((VerifierConfiguration)conf);
    }

    private void addHeaderToVerifier() {
        StringBuffer header = new StringBuffer();
        header.append("package " + this.packageItem.getName() + "\n");
        header.append(ServiceImplementation.getDroolsHeader((PackageItem)this.packageItem) + "\n");
        this.verifier.addResourcesToVerify(ResourceFactory.newReaderResource((Reader)new StringReader(header.toString())), ResourceType.DRL);
    }

    private void addToVerifier(AssetItemIterator assets, ResourceType resourceType) {
        while (assets.hasNext()) {
            AssetItem asset = assets.next();
            if (asset.isArchived() || asset.getDisabled()) continue;
            this.verifier.addResourcesToVerify(ResourceFactory.newReaderResource((Reader)new StringReader(asset.getContent())), resourceType);
        }
    }

    private void addToRulesVerifier() {
        AssetItemIterator rules = this.packageItem.listAssetsByFormat(AssetFormats.BUSINESS_RULE_FORMATS);
        while (rules.hasNext()) {
            AssetItem rule = rules.next();
            ContentHandler contentHandler = ContentManager.getHandler((String)rule.getFormat());
            if (!contentHandler.isRuleAsset()) continue;
            IRuleAsset ruleAsset = (IRuleAsset)contentHandler;
            String drl = ruleAsset.getRawDRL(rule);
            this.verifier.addResourcesToVerify(ResourceFactory.newReaderResource((Reader)new StringReader(drl)), ResourceType.DRL);
        }
    }

    public boolean isUseDefaultConfig() {
        return this.useDefaultConfig;
    }

    public void setUseDefaultConfig(boolean useDefaultConfig) {
        this.useDefaultConfig = useDefaultConfig;
    }
}

