/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.repository;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.log4j.Logger;
import org.drools.guvnor.server.repository.UserInbox;
import org.drools.guvnor.server.util.LoggingHelper;
import org.drools.repository.AssetItem;
import org.drools.repository.RulesRepository;
import org.drools.repository.UserInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MailboxService {
    private static final Logger log = LoggingHelper.getLogger(MailboxService.class);
    public static final String MAILMAN = "mailman";
    private static ExecutorService executor = Executors.newSingleThreadExecutor();
    private static MailboxService INSTANCE = new MailboxService();
    private RulesRepository repository;

    public static MailboxService getInstance() {
        return INSTANCE;
    }

    private MailboxService() {
    }

    MailboxService(RulesRepository systemRepo) {
        this.init(systemRepo);
    }

    public void init(RulesRepository systemRepo) {
        log.info((Object)"Starting mailbox service");
        this.repository = systemRepo;
    }

    public void wakeUp() {
        log.info((Object)"Waking up");
        executor.execute((Runnable)new /* Unavailable Anonymous Inner Class!! */);
    }

    void processOutgoing() {
        log.info((Object)"Processing outgoing messages");
        if (this.repository != null) {
            UserInbox mailman = new UserInbox(this.repository, MAILMAN);
            List es = mailman.loadIncoming();
            log.debug((Object)("Outgoing messages size " + es.size()));
            UserInfo.eachUser((RulesRepository)this.repository, (UserInfo.Command)new /* Unavailable Anonymous Inner Class!! */);
            mailman.clearIncoming();
            this.repository.save();
        }
    }

    private Set<String> makeSetOf(List<UserInfo.InboxEntry> inboxEntries) {
        HashSet<String> entries = new HashSet<String>();
        for (UserInfo.InboxEntry e : inboxEntries) {
            entries.add(e.assetUUID);
        }
        return entries;
    }

    public void recordItemUpdated(AssetItem item) {
        String id = item.getUUID();
        String name = item.getName();
        String from = item.getRulesRepository().getSession().getUserID();
        executor.execute((Runnable)new /* Unavailable Anonymous Inner Class!! */);
    }

    static /* synthetic */ Logger access$000() {
        return log;
    }

    static /* synthetic */ RulesRepository access$100(MailboxService x0) {
        return x0.repository;
    }

    static /* synthetic */ Set access$200(MailboxService x0, List x1) {
        return x0.makeSetOf(x1);
    }
}

