/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.files;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.drools.guvnor.server.files.RepositoryServlet;
import org.drools.guvnor.server.util.LoggingHelper;

public class RepositoryBackupServlet
extends RepositoryServlet {
    private static final Logger log = LoggingHelper.getLogger(RepositoryBackupServlet.class);
    private static final long serialVersionUID = 400L;

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doAuthorizedAction(request, response, (RepositoryServlet.A)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.doAuthorizedAction(req, res, (RepositoryServlet.A)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void processExportRepositoryDownload(HttpServletResponse res) throws PathNotFoundException, IOException, RepositoryException {
        log.debug((Object)"Exporting...");
        res.setContentType("application/zip");
        res.setHeader("Content-Disposition", "attachment; filename=repository_export.zip;");
        log.debug((Object)"Starting to process export");
        ZipOutputStream zout = new ZipOutputStream((OutputStream)res.getOutputStream());
        zout.putNextEntry(new ZipEntry("repository_export.xml"));
        this.getFileManager().exportRulesRepository((OutputStream)zout);
        zout.closeEntry();
        zout.finish();
        res.getOutputStream().flush();
        log.debug((Object)"Done exporting!");
    }

    private void processExportPackageFromRepositoryDownload(HttpServletResponse res, String packageName) throws PathNotFoundException, IOException, RepositoryException {
        res.setContentType("application/zip");
        res.setHeader("Content-Disposition", "inline; filename=" + packageName + ".zip;");
        res.getOutputStream().write(this.getFileManager().exportPackageFromRepository(packageName));
        res.getOutputStream().flush();
    }

    private String processImportRepository(InputStream file) throws IOException {
        this.getFileManager().importRulesRepository(file);
        return "OK";
    }

    private String processImportPackage(InputStream file, boolean importAsNew) throws IOException {
        byte[] byteArray = new byte[file.available()];
        file.read(byteArray);
        this.getFileManager().importPackageToRepository(byteArray, importAsNew);
        return "OK";
    }

    static /* synthetic */ String access$000(RepositoryBackupServlet x0, InputStream x1, boolean x2) throws IOException {
        return x0.processImportPackage(x1, x2);
    }

    static /* synthetic */ String access$100(RepositoryBackupServlet x0, InputStream x1) throws IOException {
        return x0.processImportRepository(x1);
    }

    static /* synthetic */ void access$200(RepositoryBackupServlet x0, HttpServletResponse x1) throws PathNotFoundException, IOException, RepositoryException {
        x0.processExportRepositoryDownload(x1);
    }

    static /* synthetic */ void access$300(RepositoryBackupServlet x0, HttpServletResponse x1, String x2) throws PathNotFoundException, IOException, RepositoryException {
        x0.processExportPackageFromRepositoryDownload(x1, x2);
    }
}

