/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.files;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PackageDeploymentURIHelper {
    private String version;
    private String packageName;
    private String assetName = null;
    private boolean source;
    private boolean documentation;

    public PackageDeploymentURIHelper(String uri) throws UnsupportedEncodingException {
        Pattern pattern;
        Matcher m;
        String url = URLDecoder.decode(uri, "UTF-8");
        if (url.endsWith(".drl") || url.endsWith(".pdf")) {
            if (url.endsWith(".drl")) {
                this.source = true;
            } else if (url.endsWith(".pdf")) {
                this.documentation = true;
            }
            url = url.substring(0, url.length() - 4);
        }
        if ((m = (pattern = Pattern.compile(".*/(package|asset)/(.*)")).matcher(url)).matches()) {
            String result = m.group(2);
            String[] mtoks = result.split("/");
            this.version = mtoks[1];
            this.packageName = mtoks[0];
            if (mtoks.length == 3) {
                this.assetName = mtoks[2];
            }
        }
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean isLatest() {
        return "LATEST".equals(this.version);
    }

    public boolean isSource() {
        return this.source;
    }

    public boolean isDocumentation() {
        return this.documentation;
    }

    public String getAssetName() {
        return this.assetName;
    }

    public boolean isAsset() {
        return this.assetName != null;
    }
}

