/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.contenthandler;

import com.google.gwt.user.client.rpc.SerializableException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.drools.bpmn2.xml.BPMNSemanticModule;
import org.drools.bpmn2.xml.XmlBPMNProcessDumper;
import org.drools.compiler.DroolsParserException;
import org.drools.compiler.PackageBuilderConfiguration;
import org.drools.compiler.xml.XmlProcessReader;
import org.drools.definition.process.WorkflowProcess;
import org.drools.guvnor.client.rpc.RuleAsset;
import org.drools.guvnor.client.rpc.RuleFlowContentModel;
import org.drools.guvnor.server.builder.BRMSPackageBuilder;
import org.drools.guvnor.server.builder.ContentPackageAssembler;
import org.drools.guvnor.server.builder.RuleFlowContentModelBuilder;
import org.drools.guvnor.server.contenthandler.ContentHandler;
import org.drools.guvnor.server.contenthandler.ICompilable;
import org.drools.repository.AssetItem;
import org.drools.repository.PackageItem;
import org.drools.ruleflow.core.RuleFlowProcess;
import org.drools.xml.SemanticModule;

public class BPMN2ProcessHandler
extends ContentHandler
implements ICompilable {
    public void retrieveAssetContent(RuleAsset asset, PackageItem pkg, AssetItem item) throws SerializableException {
        RuleFlowProcess process = this.readProcess((InputStream)new ByteArrayInputStream(item.getContent().getBytes()));
        if (process != null) {
            RuleFlowContentModel content = RuleFlowContentModelBuilder.createModel((RuleFlowProcess)process);
            content.setXml(item.getContent());
            asset.content = content;
        }
    }

    protected RuleFlowProcess readProcess(InputStream is) {
        RuleFlowProcess process = null;
        try {
            InputStreamReader reader = new InputStreamReader(is);
            PackageBuilderConfiguration configuration = new PackageBuilderConfiguration();
            configuration.initSemanticModules();
            configuration.addSemanticModule((SemanticModule)new BPMNSemanticModule());
            XmlProcessReader xmlReader = new XmlProcessReader(configuration.getSemanticModules());
            try {
                process = (RuleFlowProcess)xmlReader.read((Reader)reader);
            }
            catch (Exception e) {
                reader.close();
                throw new Exception("Unable to read BPMN2 XML.", e);
            }
            reader.close();
        }
        catch (Exception e) {
            return null;
        }
        return process;
    }

    public void storeAssetContent(RuleAsset asset, AssetItem repoAsset) throws SerializableException {
    }

    public void ruleFlowAttached(AssetItem item) {
        String originalPackageName;
        String packageName;
        RuleFlowProcess process;
        String content = item.getContent();
        if (content != null && !content.equals("") && (process = this.readProcess((InputStream)new ByteArrayInputStream(content.getBytes()))) != null && !(packageName = item.getPackageName()).equals(originalPackageName = process.getPackageName())) {
            process.setPackageName(packageName);
            XmlBPMNProcessDumper dumper = XmlBPMNProcessDumper.INSTANCE;
            String out = dumper.dump((WorkflowProcess)process);
            item.updateContent(out);
            item.checkin("Changed BPMN2 process package from " + originalPackageName + " to " + packageName);
        }
    }

    public void compile(BRMSPackageBuilder builder, AssetItem asset, ContentPackageAssembler.ErrorLogger logger) throws DroolsParserException, IOException {
        InputStream ins = asset.getBinaryContentAttachment();
        if (ins != null) {
            builder.addProcessFromXml((Reader)new InputStreamReader(asset.getBinaryContentAttachment()));
        }
    }
}

