/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.ruleeditor;

import com.google.gwt.user.client.ui.Widget;
import java.util.HashMap;
import java.util.Map;
import org.drools.guvnor.client.common.DefaultContentUploadEditor;
import org.drools.guvnor.client.common.RulePackageSelector;
import org.drools.guvnor.client.decisiontable.DecisionTableXLSWidget;
import org.drools.guvnor.client.decisiontable.GuidedDecisionTableWidget;
import org.drools.guvnor.client.explorer.Preferences;
import org.drools.guvnor.client.factmodel.FactModelWidget;
import org.drools.guvnor.client.modeldriven.ui.ModellerWidgetFactory;
import org.drools.guvnor.client.modeldriven.ui.RuleModeller;
import org.drools.guvnor.client.modeldriven.ui.RuleModellerWidgetFactory;
import org.drools.guvnor.client.modeldriven.ui.RuleTemplateEditor;
import org.drools.guvnor.client.packages.ModelAttachmentFileWidget;
import org.drools.guvnor.client.qa.ScenarioWidget;
import org.drools.guvnor.client.rpc.RuleAsset;
import org.drools.guvnor.client.ruleeditor.BPELWrapper;
import org.drools.guvnor.client.ruleeditor.DSLRuleEditor;
import org.drools.guvnor.client.ruleeditor.DefaultRuleContentWidget;
import org.drools.guvnor.client.ruleeditor.DrlEditor;
import org.drools.guvnor.client.ruleeditor.FunctionEditor;
import org.drools.guvnor.client.ruleeditor.PropertiesWidget;
import org.drools.guvnor.client.ruleeditor.RuleFlowWrapper;
import org.drools.guvnor.client.ruleeditor.RuleValidatorWrapper;
import org.drools.guvnor.client.ruleeditor.RuleViewer;
import org.drools.guvnor.client.ruleeditor.WorkingSetEditor;
import org.drools.guvnor.client.ruleeditor.XmlFileWidget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class EditorLauncher {
    public static final Map<String, String> TYPE_IMAGES = EditorLauncher.getTypeImages();

    public static Widget getEditorViewer(RuleAsset asset, RuleViewer viewer) {
        RulePackageSelector.currentlySelectedPackage = asset.metaData.packageName;
        if (asset.metaData.format.equals("brl")) {
            return new RuleModeller(asset, (ModellerWidgetFactory)new RuleModellerWidgetFactory());
        }
        if (asset.metaData.format.equals("dslr")) {
            return new RuleValidatorWrapper((Widget)new DSLRuleEditor(asset), asset);
        }
        if (asset.metaData.format.equals("bpel.jar") && Preferences.getBooleanPref((String)"flex-bpel-editor")) {
            return new BPELWrapper(asset, viewer);
        }
        if (asset.metaData.format.equals("jar")) {
            return new ModelAttachmentFileWidget(asset, viewer);
        }
        if (asset.metaData.format.equals("xls")) {
            return new DecisionTableXLSWidget(asset, viewer);
        }
        if (asset.metaData.format.equals("rf")) {
            return new RuleFlowWrapper(asset, viewer);
        }
        if (asset.metaData.format.equals("bpmn")) {
            return new RuleFlowWrapper(asset, viewer);
        }
        if (asset.metaData.format.equals("drl")) {
            return new DrlEditor(asset);
        }
        if (asset.metaData.format.equals("enumeration")) {
            return new DefaultRuleContentWidget(asset);
        }
        if (asset.metaData.format.equals("scenario")) {
            return new ScenarioWidget(asset);
        }
        if (asset.metaData.format.equals("gdst")) {
            return new GuidedDecisionTableWidget(asset);
        }
        if (asset.metaData.format.equals("model.drl")) {
            return new FactModelWidget(asset);
        }
        if (asset.metaData.format.equals("dsl")) {
            return new DefaultRuleContentWidget(asset);
        }
        if (asset.metaData.format.equals("properties")) {
            return new PropertiesWidget(asset, viewer);
        }
        if (asset.metaData.format.equals("xml")) {
            return new XmlFileWidget(asset, viewer);
        }
        if (asset.metaData.format.equals("function")) {
            return new FunctionEditor(asset);
        }
        if (asset.metaData.format.equals("workingset")) {
            return new WorkingSetEditor(asset);
        }
        if (asset.metaData.format.equals("template")) {
            return new RuleTemplateEditor(asset);
        }
        return new DefaultContentUploadEditor(asset, viewer);
    }

    private static Map<String, String> getTypeImages() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("drl", "technical_rule_assets.gif");
        result.put("dsl", "dsl.gif");
        result.put("function", "function_assets.gif");
        result.put("jar", "model_asset.gif");
        result.put("xls", "spreadsheet_small.gif");
        result.put("brl", "business_rule.gif");
        result.put("dslr", "business_rule.gif");
        result.put("rf", "ruleflow_small.gif");
        result.put("bpmn", "ruleflow_small.gif");
        result.put("scenario", "test_manager.gif");
        result.put("enumeration", "enumeration.gif");
        result.put("gdst", "gdst.gif");
        return result;
    }

    public static String getAssetFormatBGStyle(String format) {
        String style = (String)EditorLauncher.getTypeStyles().get(format);
        if (style == null) {
            return "bg_rule_asset";
        }
        return style;
    }

    private static Map<String, String> getTypeStyles() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("drl", "bg_technical_rule_assets");
        result.put("dsl", "bg_dsl");
        result.put("function", "bg_function_assets");
        result.put("jar", "bg_model_asset");
        result.put("xls", "bg_spreadsheet_small");
        result.put("brl", "bg_business_rule");
        result.put("dslr", "bg_business_rule");
        result.put("rf", "bg_ruleflow_small");
        result.put("bpmn", "bg_ruleflow_small");
        result.put("scenario", "bg_test_manager");
        result.put("enumeration", "bg_enumeration");
        result.put("gdst", "bg_gdst");
        return result;
    }

    public static String getAssetFormatIcon(String format) {
        String result = (String)TYPE_IMAGES.get(format);
        if (result == null) {
            return "rule_asset.gif";
        }
        return result;
    }
}

