/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.qa;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.gwtext.client.util.Format;
import java.util.Iterator;
import java.util.List;
import org.drools.guvnor.client.common.SmallLabel;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.qa.ScenarioWidget;
import org.drools.guvnor.client.rpc.BuilderResultLine;
import org.drools.guvnor.client.rpc.SingleScenarioResult;
import org.drools.ide.common.client.modeldriven.testing.ExecutionTrace;
import org.drools.ide.common.client.modeldriven.testing.Fixture;
import org.drools.ide.common.client.modeldriven.testing.VerifyFact;
import org.drools.ide.common.client.modeldriven.testing.VerifyField;
import org.drools.ide.common.client.modeldriven.testing.VerifyRuleFired;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestRunnerWidget
extends Composite {
    FlexTable results = new FlexTable();
    VerticalPanel layout = new VerticalPanel();
    private SimplePanel actions = new SimplePanel();
    private Constants constants = (Constants)GWT.create(Constants.class);

    public TestRunnerWidget(ScenarioWidget parent, String packageName) {
        Button run = new Button(this.constants.RunScenario());
        run.setTitle(this.constants.RunScenarioTip());
        run.addClickListener((ClickListener)new /* Unavailable Anonymous Inner Class!! */);
        this.actions.add((Widget)run);
        this.layout.add((Widget)this.actions);
        this.initWidget((Widget)this.layout);
    }

    private void showErrors(BuilderResultLine[] rs) {
        this.results.clear();
        this.results.setVisible(true);
        FlexTable errTable = new FlexTable();
        errTable.setStyleName("build-Results");
        for (int i = 0; i < rs.length; ++i) {
            int row = i;
            BuilderResultLine res = rs[i];
            errTable.setWidget(row, 0, (Widget)new Image("images/error.gif"));
            if (res.assetFormat.equals("package")) {
                errTable.setText(row, 1, this.constants.packageConfigurationProblem1() + res.message);
                continue;
            }
            errTable.setText(row, 1, "[" + res.assetName + "] " + res.message);
        }
        ScrollPanel scroll = new ScrollPanel((Widget)errTable);
        scroll.setWidth("100%");
        this.results.setWidget(0, 0, (Widget)scroll);
    }

    private void showResults(ScenarioWidget parent, SingleScenarioResult data) {
        this.results.clear();
        this.results.setVisible(true);
        parent.asset.content = data.result.scenario;
        parent.showResults = true;
        parent.renderEditor();
        int failures = 0;
        int total = 0;
        VerticalPanel resultsDetail = new VerticalPanel();
        for (Fixture f : data.result.scenario.fixtures) {
            if (f instanceof VerifyRuleFired) {
                VerifyRuleFired vr = (VerifyRuleFired)f;
                HorizontalPanel h = new HorizontalPanel();
                if (!vr.successResult.booleanValue()) {
                    h.add((Widget)new Image("images/warning.gif"));
                    ++failures;
                } else {
                    h.add((Widget)new Image("images/test_passed.png"));
                }
                h.add((Widget)new SmallLabel(vr.explanation));
                resultsDetail.add((Widget)h);
                ++total;
                continue;
            }
            if (f instanceof VerifyFact) {
                VerifyFact vf = (VerifyFact)f;
                Iterator it = vf.fieldValues.iterator();
                while (it.hasNext()) {
                    ++total;
                    VerifyField vfl = (VerifyField)it.next();
                    HorizontalPanel h = new HorizontalPanel();
                    if (!vfl.successResult.booleanValue()) {
                        h.add((Widget)new Image("images/warning.gif"));
                        ++failures;
                    } else {
                        h.add((Widget)new Image("images/test_passed.png"));
                    }
                    h.add((Widget)new SmallLabel(vfl.explanation));
                    resultsDetail.add((Widget)h);
                }
                continue;
            }
            if (!(f instanceof ExecutionTrace)) continue;
            ExecutionTrace ex = (ExecutionTrace)f;
            if (ex.numberOfRulesFired != (long)data.result.scenario.maxRuleFirings) continue;
            Window.alert((String)Format.format((String)this.constants.MaxRuleFiringsReachedWarning(), (int)data.result.scenario.maxRuleFirings));
        }
        this.results.setWidget(0, 0, (Widget)new SmallLabel(this.constants.Results()));
        this.results.getFlexCellFormatter().setHorizontalAlignment(0, 0, HasHorizontalAlignment.ALIGN_RIGHT);
        if (failures > 0) {
            this.results.setWidget(0, 1, ScenarioWidget.getBar((String)"#CC0000", (int)150, (int)failures, (int)total));
        } else {
            this.results.setWidget(0, 1, ScenarioWidget.getBar((String)"GREEN", (int)150, (int)failures, (int)total));
        }
        this.results.setWidget(1, 0, (Widget)new SmallLabel(this.constants.SummaryColon()));
        this.results.getFlexCellFormatter().setHorizontalAlignment(1, 0, HasHorizontalAlignment.ALIGN_RIGHT);
        this.results.setWidget(1, 1, (Widget)resultsDetail);
        this.results.setWidget(2, 0, (Widget)new SmallLabel(this.constants.AuditLogColon()));
        Button showExp = new Button(this.constants.ShowEventsButton());
        this.results.setWidget(2, 1, (Widget)showExp);
        showExp.addClickListener((ClickListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    private Widget doAuditView(List<String[]> auditLog) {
        VerticalPanel vp = new VerticalPanel();
        vp.add((Widget)new HTML("<hr/>"));
        FlexTable g = new FlexTable();
        String indent = "";
        int row = 0;
        boolean firing = false;
        for (int i = 0; i < auditLog.size(); ++i) {
            String[] lg = auditLog.get(i);
            int id = Integer.parseInt(lg[0]);
            if (id <= 7) {
                if (id <= 3) {
                    if (!firing) {
                        g.setWidget(row, 0, (Widget)new Image("images/audit_events/" + lg[0] + ".gif"));
                        g.setWidget(row, 1, (Widget)new SmallLabel(lg[1]));
                    } else {
                        g.setWidget(row, 1, this.hz(new Image("images/audit_events/" + lg[0] + ".gif"), new SmallLabel(lg[1])));
                    }
                    ++row;
                    continue;
                }
                if (id == 6) {
                    firing = true;
                    g.setWidget(row, 0, (Widget)new Image("images/audit_events/" + lg[0] + ".gif"));
                    g.setWidget(row, 1, (Widget)new SmallLabel("<b>" + lg[1] + "</b>"));
                    ++row;
                    continue;
                }
                if (id == 7) {
                    firing = false;
                    continue;
                }
                g.setWidget(row, 0, (Widget)new Image("images/audit_events/" + lg[0] + ".gif"));
                g.setWidget(row, 1, (Widget)new SmallLabel("<font color='grey'>" + lg[1] + "</font>"));
                ++row;
                continue;
            }
            g.setWidget(row, 0, (Widget)new Image("images/audit_events/misc_event.gif"));
            g.setWidget(row, 1, (Widget)new SmallLabel("<font color='grey'>" + lg[1] + "</font>"));
            ++row;
        }
        vp.add((Widget)g);
        vp.add((Widget)new HTML("<hr/>"));
        return vp;
    }

    private Widget hz(Image image, SmallLabel smallLabel) {
        HorizontalPanel h = new HorizontalPanel();
        h.add((Widget)image);
        h.add((Widget)smallLabel);
        return h;
    }

    static /* synthetic */ Constants access$000(TestRunnerWidget x0) {
        return x0.constants;
    }

    static /* synthetic */ SimplePanel access$100(TestRunnerWidget x0) {
        return x0.actions;
    }

    static /* synthetic */ void access$200(TestRunnerWidget x0, BuilderResultLine[] x1) {
        x0.showErrors(x1);
    }

    static /* synthetic */ void access$300(TestRunnerWidget x0, ScenarioWidget x1, SingleScenarioResult x2) {
        x0.showResults(x1, x2);
    }

    static /* synthetic */ Widget access$400(TestRunnerWidget x0, List x1) {
        return x0.doAuditView(x1);
    }
}

