/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.util;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.drools.ide.common.client.modeldriven.brl.RuleModel;
import org.drools.ide.common.client.modeldriven.dt.TemplateModel;
import org.drools.ide.common.server.util.BRDRLPersistence;
import org.drools.ide.common.server.util.BRLPersistence;
import org.drools.template.DataProvider;
import org.drools.template.DataProviderCompiler;
import org.drools.template.objects.ArrayDataProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BRDRTPersistence
extends BRDRLPersistence {
    private static final Logger log = LoggerFactory.getLogger(BRDRTPersistence.class);
    private static final BRLPersistence INSTANCE = new BRDRTPersistence();
    private static final String PACKAGE_DECLARATION = "\npackage __template_dummy_package__\n";

    private BRDRTPersistence() {
    }

    public static BRLPersistence getInstance() {
        return INSTANCE;
    }

    public String marshal(RuleModel model) {
        TemplateModel tplModel = (TemplateModel)model;
        String ruleTemplate = super.marshalRule(model);
        log.debug("ruleTemplate:\n{}", (Object)ruleTemplate);
        DataProviderCompiler tplCompiler = new DataProviderCompiler();
        ArrayDataProvider dataProvider = tplModel.getRowsCount() > 0 ? new ArrayDataProvider(tplModel.getTableAsArray()) : new ArrayDataProvider(this.generateEmptyIterator(tplModel));
        String generatedDRl = tplCompiler.compile((DataProvider)dataProvider, (InputStream)new ByteArrayInputStream(ruleTemplate.getBytes())).substring(PACKAGE_DECLARATION.length()).trim();
        log.debug("generated drl:\n{}", (Object)generatedDRl);
        return generatedDRl;
    }

    private String[][] generateEmptyIterator(TemplateModel tplModel) {
        String[][] rows = new String[1][];
        String[] interpolationVariables = tplModel.getInterpolationVariablesList();
        if (interpolationVariables == null || interpolationVariables.length == 0) {
            rows[0] = new String[]{""};
        } else {
            int i = 0;
            while (i < interpolationVariables.length) {
                int n = i++;
                interpolationVariables[n] = interpolationVariables[n] + "_na";
            }
            rows[0] = interpolationVariables;
        }
        return rows;
    }

    protected void marshalHeader(RuleModel model, StringBuilder buf) {
        TemplateModel tplModel = (TemplateModel)model;
        buf.append("template header\n");
        String[] interpolationVariables = tplModel.getInterpolationVariablesList();
        if (interpolationVariables.length == 0) {
            buf.append("test_var").append('\n');
        } else {
            for (String var : interpolationVariables) {
                buf.append(var).append('\n');
            }
        }
        buf.append(PACKAGE_DECLARATION).append("\ntemplate \"" + super.marshalRuleName((RuleModel)tplModel) + "\"\n\n");
        super.marshalHeader(model, buf);
    }

    protected String marshalRuleName(RuleModel model) {
        return super.marshalRuleName(model) + "_@{row.rowNumber}";
    }

    protected void marshalFooter(StringBuilder buf) {
        super.marshalFooter(buf);
        buf.append("\nend template");
    }
}

