/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.ruleeditor;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.HashMap;
import java.util.Map;
import org.drools.factconstraints.client.ConstraintConfiguration;
import org.drools.guvnor.client.common.SmallLabel;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.packages.SuggestionCompletionCache;
import org.drools.guvnor.client.rpc.RuleAsset;
import org.drools.guvnor.client.ruleeditor.WorkingSetEditor;
import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngine;

public class CustomFormsEditorPanel
extends Composite {
    private Constants constants = (Constants)GWT.create(Constants.class);
    private ListBox factsCombo = new ListBox(false);
    private ListBox fieldsCombo = new ListBox(false);
    private TextBox customFormURL = new TextBox();
    private boolean validFactsChanged = true;
    private Map<String, ConstraintConfiguration> contraintsMap = new HashMap();
    private final RuleAsset workingSet;
    private final WorkingSetEditor workingSetEditor;

    public CustomFormsEditorPanel(WorkingSetEditor workingSetEditor) {
        this.workingSetEditor = workingSetEditor;
        this.workingSet = workingSetEditor.getWorkingSet();
        this.factsCombo.setVisibleItemCount(1);
        this.fieldsCombo.setVisibleItemCount(1);
        this.customFormURL.setWidth("400px");
        this.customFormURL.setTitle("Leave it blank if you want to remove the Custom Form URL");
        this.factsCombo.addChangeHandler((ChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.fieldsCombo.addChangeHandler((ChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        FlexTable table = new FlexTable();
        VerticalPanel vp = new VerticalPanel();
        vp.add((Widget)new SmallLabel(this.constants.FactTypes()));
        vp.add((Widget)this.factsCombo);
        table.setWidget(0, 0, (Widget)vp);
        vp = new VerticalPanel();
        vp.add((Widget)new SmallLabel(this.constants.Field()));
        vp.add((Widget)this.fieldsCombo);
        table.setWidget(1, 0, (Widget)vp);
        vp = new VerticalPanel();
        vp.add((Widget)new SmallLabel("Custom Form URL:"));
        Button btnUpdateURL = new Button(this.constants.OK(), (ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        HorizontalPanel hp = new HorizontalPanel();
        hp.add((Widget)this.customFormURL);
        hp.add((Widget)btnUpdateURL);
        vp.add((Widget)hp);
        table.setWidget(2, 0, (Widget)vp);
        this.fillSelectedFacts();
        this.fillSelectedFactFields();
        this.fillFieldConstrains();
        this.initWidget((Widget)table);
    }

    protected final void fillSelectedFacts() {
        if (this.validFactsChanged) {
            String s = this.factsCombo.getSelectedIndex() != -1 ? this.factsCombo.getItemText(this.factsCombo.getSelectedIndex()) : "";
            this.factsCombo.clear();
            this.validFactsChanged = false;
            for (int i = 0; i < this.workingSetEditor.getValidFactsListBox().getItemCount(); ++i) {
                String itemText = this.workingSetEditor.getValidFactsListBox().getItemText(i);
                this.factsCombo.addItem(itemText);
                if (!s.equals(itemText)) continue;
                this.factsCombo.setSelectedIndex(i);
            }
            if (this.factsCombo.getSelectedIndex() == -1 && this.factsCombo.getItemCount() > 0) {
                this.factsCombo.setSelectedIndex(0);
            }
            this.fillSelectedFactFields();
        }
    }

    private void fillSelectedFactFields() {
        if (this.factsCombo.getSelectedIndex() != -1) {
            String fact = this.factsCombo.getItemText(this.factsCombo.getSelectedIndex());
            this.fieldsCombo.clear();
            for (String field : this.getCompletionEngine().getFieldCompletions(fact)) {
                this.fieldsCombo.addItem(field);
            }
        }
        if (this.fieldsCombo.getSelectedIndex() == -1 && this.fieldsCombo.getItemCount() > 0) {
            this.fieldsCombo.setSelectedIndex(0);
        }
        this.fillFieldConstrains();
    }

    private void fillFieldConstrains() {
        if (this.fieldsCombo.getSelectedIndex() != -1) {
            String fieldName = this.fieldsCombo.getItemText(this.fieldsCombo.getSelectedIndex());
            String factField = this.factsCombo.getItemText(this.factsCombo.getSelectedIndex());
            this.contraintsMap.clear();
            if (this.workingSetEditor.getCustomFormsContainer().containsCustomFormFor(factField, fieldName)) {
                this.customFormURL.setText(this.workingSetEditor.getCustomFormsContainer().getCustomForm(factField, fieldName).getCustomFormURL());
            } else {
                this.customFormURL.setText("");
            }
        }
    }

    private SuggestionCompletionEngine getCompletionEngine() {
        return SuggestionCompletionCache.getInstance().getEngineFromCache(this.workingSet.metaData.packageName);
    }

    public void notifyValidFactsChanged() {
        this.validFactsChanged = true;
    }

    static /* synthetic */ void access$000(CustomFormsEditorPanel x0) {
        x0.fillSelectedFactFields();
    }

    static /* synthetic */ void access$100(CustomFormsEditorPanel x0) {
        x0.fillFieldConstrains();
    }

    static /* synthetic */ RuleAsset access$200(CustomFormsEditorPanel x0) {
        return x0.workingSet;
    }

    static /* synthetic */ ListBox access$300(CustomFormsEditorPanel x0) {
        return x0.factsCombo;
    }

    static /* synthetic */ ListBox access$400(CustomFormsEditorPanel x0) {
        return x0.fieldsCombo;
    }

    static /* synthetic */ TextBox access$500(CustomFormsEditorPanel x0) {
        return x0.customFormURL;
    }
}

