/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.factmodel;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.ChangeListener;
import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.KeyboardListener;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.gwtext.client.util.Format;
import com.gwtext.client.widgets.form.FormPanel;
import java.util.List;
import java.util.Map;
import org.drools.guvnor.client.common.FormStylePopup;
import org.drools.guvnor.client.common.ImageButton;
import org.drools.guvnor.client.common.LoadingPopup;
import org.drools.guvnor.client.common.SmallLabel;
import org.drools.guvnor.client.factmodel.FactMetaModel;
import org.drools.guvnor.client.factmodel.FactModels;
import org.drools.guvnor.client.factmodel.FieldMetaModel;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.packages.SuggestionCompletionCache;
import org.drools.guvnor.client.rpc.RuleAsset;
import org.drools.guvnor.client.rpc.RuleContentText;
import org.drools.guvnor.client.ruleeditor.DefaultRuleContentWidget;
import org.drools.guvnor.client.ruleeditor.RuleViewer;
import org.drools.guvnor.client.ruleeditor.SaveEventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FactModelWidget
extends Composite
implements SaveEventListener {
    private RuleAsset asset;
    private VerticalPanel layout;
    private int editingFact = -1;
    private static Constants constants = (Constants)GWT.create(Constants.class);
    private static Map<String, String> TYPE_DESCRIPTIONS = new /* Unavailable Anonymous Inner Class!! */;

    public FactModelWidget(RuleAsset asset, RuleViewer viewer) {
        this(asset);
    }

    public FactModelWidget(RuleAsset asset) {
        this.asset = asset;
        this.layout = new VerticalPanel();
        if (asset.content instanceof RuleContentText) {
            this.layout.add((Widget)new DefaultRuleContentWidget(asset));
        } else {
            if (asset.content == null) {
                asset.content = new FactModels();
            }
            this.renderEditor();
        }
        this.layout.setWidth("100%");
        this.initWidget((Widget)this.layout);
        this.setStyleName("model-builder-Background");
    }

    private void renderEditor() {
        this.layout.clear();
        FactModels m = (FactModels)this.asset.content;
        String factHeaderStyle = "modeller-fact-TypeHeader";
        for (int i = 0; i < m.models.size(); ++i) {
            FactMetaModel mm = (FactMetaModel)m.models.get(i);
            FormPanel config = new FormPanel();
            config.setTitle(mm.name);
            config.setCollapsible(true);
            config.setCollapsed(this.editingFact != i);
            FlexTable tb = new FlexTable();
            config.add((Widget)tb);
            tb.setStyleName("modeller-fact-pattern-Widget");
            tb.setWidth("100%");
            this.layout.add((Widget)config);
            HorizontalPanel headerPanel = new HorizontalPanel();
            headerPanel.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
            headerPanel.add((Widget)this.getMovePanel(m.models, (Object)mm, m.models.indexOf(mm)));
            Button addField = new Button(constants.AddField());
            addField.addClickListener((ClickListener)new /* Unavailable Anonymous Inner Class!! */);
            headerPanel.add((Widget)addField);
            Button changeName = new Button(constants.ChangeFactName());
            changeName.addClickListener((ClickListener)new /* Unavailable Anonymous Inner Class!! */);
            headerPanel.add((Widget)changeName);
            Button deleteFact = new Button(constants.Delete());
            deleteFact.addClickListener((ClickListener)new /* Unavailable Anonymous Inner Class!! */);
            headerPanel.add((Widget)deleteFact);
            tb.setWidget(0, 0, (Widget)new /* Unavailable Anonymous Inner Class!! */);
            FlexTable.FlexCellFormatter formatter = tb.getFlexCellFormatter();
            formatter.setColSpan(0, 0, 2);
            formatter.setStyleName(0, 0, factHeaderStyle);
            formatter.setHorizontalAlignment(0, 0, HasHorizontalAlignment.ALIGN_LEFT);
            for (int j = 0; j < mm.fields.size(); ++j) {
                FieldMetaModel fm = (FieldMetaModel)mm.fields.get(j);
                String ms = Format.format((String)constants.FieldName(), (String)fm.name);
                tb.setWidget(j + 1, 0, (Widget)new HTML(ms));
                formatter.setHorizontalAlignment(j + 1, 0, HasHorizontalAlignment.ALIGN_RIGHT);
                HorizontalPanel type = new HorizontalPanel();
                type.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
                type.add((Widget)new SmallLabel(this.getDesc(fm)));
                ImageButton del = new ImageButton("images/delete_item_small.gif");
                del.addClickListener((ClickListener)new /* Unavailable Anonymous Inner Class!! */);
                ImageButton edit = new ImageButton("images/edit.gif");
                edit.addClickListener((ClickListener)new /* Unavailable Anonymous Inner Class!! */);
                type.add((Widget)edit);
                type.add((Widget)del);
                tb.setWidget(j + 1, 1, (Widget)type);
                formatter.setHorizontalAlignment(j + 1, 1, HasHorizontalAlignment.ALIGN_LEFT);
            }
        }
        Button addNewFact = new Button(constants.AddNewFactType());
        addNewFact.addClickListener((ClickListener)new /* Unavailable Anonymous Inner Class!! */);
        this.layout.add((Widget)addNewFact);
    }

    private VerticalPanel getMovePanel(List<? extends Object> list, Object object, int editingFactIndex) {
        int index = list.indexOf(object);
        VerticalPanel arrows = new VerticalPanel();
        ImageButton up = new ImageButton("images/arrow-up.gif", constants.MoveUp());
        up.setVisible(index != 0);
        up.addClickListener((ClickListener)new /* Unavailable Anonymous Inner Class!! */);
        arrows.add((Widget)up);
        ImageButton down = new ImageButton("images/arrow-down.gif", constants.MoveDown());
        down.setVisible(index != list.size() - 1);
        down.addClickListener((ClickListener)new /* Unavailable Anonymous Inner Class!! */);
        arrows.add((Widget)down);
        return arrows;
    }

    private boolean uniqueName(String type, List<FactMetaModel> models) {
        for (FactMetaModel m : models) {
            if (!m.name.equals(type)) continue;
            return false;
        }
        return true;
    }

    private String getDesc(FieldMetaModel fm) {
        if (TYPE_DESCRIPTIONS.containsKey(fm.type)) {
            return (String)TYPE_DESCRIPTIONS.get(fm.type);
        }
        return fm.type;
    }

    private void showFieldEditor(FactModels models, FactMetaModel mm, FieldMetaModel field) {
        FormStylePopup pop = new FormStylePopup();
        TextBox fieldName = new TextBox();
        TextBox fieldType = new TextBox();
        fieldName.addKeyboardListener(this.noSpaceListener());
        fieldType.addKeyboardListener(this.noSpaceListener());
        if (field != null) {
            fieldName.setText(field.name);
            fieldType.setText(field.type);
        }
        HorizontalPanel typeP = new HorizontalPanel();
        typeP.add((Widget)fieldType);
        ListBox typeChoice = new ListBox();
        typeChoice.addItem(constants.chooseType());
        for (String k : TYPE_DESCRIPTIONS.keySet()) {
            typeChoice.addItem((String)TYPE_DESCRIPTIONS.get(k), k);
        }
        int idx = models.models.indexOf(mm);
        for (int i = 0; i < idx; ++i) {
            FactMetaModel mm_ = (FactMetaModel)models.models.get(i);
            typeChoice.addItem(mm_.name);
        }
        typeChoice.setSelectedIndex(0);
        typeChoice.addChangeListener((ChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        typeP.add((Widget)typeChoice);
        pop.addAttribute(constants.FieldNameAttribute(), (Widget)fieldName);
        pop.addAttribute(constants.Type(), (Widget)typeP);
        Button ok = new Button(constants.OK());
        ok.addClickListener((ClickListener)new /* Unavailable Anonymous Inner Class!! */);
        pop.addAttribute("", (Widget)ok);
        pop.show();
    }

    private KeyboardListener noSpaceListener() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public void onAfterSave() {
        LoadingPopup.showMessage((String)constants.RefreshingModel());
        SuggestionCompletionCache.getInstance().loadPackage(this.asset.metaData.packageName, (Command)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void onSave() {
    }

    static /* synthetic */ Constants access$000() {
        return constants;
    }

    static /* synthetic */ void access$100(FactModelWidget x0, FactModels x1, FactMetaModel x2, FieldMetaModel x3) {
        x0.showFieldEditor(x1, x2, x3);
    }

    static /* synthetic */ KeyboardListener access$200(FactModelWidget x0) {
        return x0.noSpaceListener();
    }

    static /* synthetic */ boolean access$300(FactModelWidget x0, String x1, List x2) {
        return x0.uniqueName(x1, x2);
    }

    static /* synthetic */ void access$400(FactModelWidget x0) {
        x0.renderEditor();
    }

    static /* synthetic */ int access$502(FactModelWidget x0, int x1) {
        x0.editingFact = x1;
        return x0.editingFact;
    }
}

