/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.util;

import java.util.ArrayList;
import org.drools.guvnor.client.ruleeditor.PropertiesHolder;
import org.drools.guvnor.client.ruleeditor.PropertyHolder;

public class PropertiesPersistence {
    private static PropertiesPersistence INSTANCE = new PropertiesPersistence();

    private PropertiesPersistence() {
    }

    public static PropertiesPersistence getInstance() {
        return INSTANCE;
    }

    public String marshal(PropertiesHolder holder) {
        StringBuilder sb = new StringBuilder();
        for (PropertyHolder propertyHolder : holder.list) {
            sb.append(propertyHolder.name).append("=").append(propertyHolder.value).append("\n");
        }
        return sb.toString();
    }

    public PropertiesHolder unmarshal(String properties) {
        ArrayList<PropertyHolder> list = new ArrayList<PropertyHolder>();
        String[] props = properties.split("\n");
        if (props != null && props.length == 2) {
            for (String s : props) {
                String[] pair = s.split("=");
                list.add(new PropertyHolder(pair[0], pair[1]));
            }
        }
        PropertiesHolder result = new PropertiesHolder();
        result.list = list;
        return result;
    }
}

