/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.files;

import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import javax.security.auth.login.LoginException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.util.Base64;
import org.drools.guvnor.server.files.RestAPIServlet;
import org.drools.guvnor.server.util.TestEnvironmentSessionHelper;
import org.drools.repository.RulesRepository;
import org.drools.repository.remoteapi.RestAPI;
import org.jboss.seam.Component;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.security.Identity;

/*
 * Exception performing whole class analysis ignored.
 */
public class RestAPIServlet
extends HttpServlet {
    private static final long serialVersionUID = 500L;
    public static final Logger log = Logger.getLogger(RestAPIServlet.class);

    protected void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.doAuthorizedAction(req, res, (A)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.doAuthorizedAction(req, res, (A)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.doAuthorizedAction(req, res, (A)new /* Unavailable Anonymous Inner Class!! */);
    }

    Calendar getModified(String f) throws ParseException {
        if (f == null) {
            return null;
        }
        Calendar c = Calendar.getInstance();
        SimpleDateFormat sdf = RestAPI.getISODateFormat();
        try {
            c.setTime(sdf.parse(f));
        }
        catch (ParseException e) {
            DateFormat df = DateFormat.getInstance();
            c.setTime(df.parse(f));
        }
        return c;
    }

    protected void doDelete(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.doAuthorizedAction(req, res, (A)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void doAuthorizedAction(HttpServletRequest req, HttpServletResponse res, A action) throws IOException {
        String auth = req.getHeader("Authorization");
        if (!RestAPIServlet.allowUser((String)auth)) {
            res.setHeader("WWW-Authenticate", "BASIC realm=\"users\"");
            res.sendError(401);
        } else {
            try {
                action.a();
            }
            catch (Exception e) {
                log.error((Object)e);
                throw new RuntimeException(e);
            }
        }
    }

    static RulesRepository getRepository() {
        if (Contexts.isApplicationContextActive()) {
            RulesRepository repo = (RulesRepository)Component.getInstance((String)"repository");
            return repo;
        }
        try {
            RulesRepository repo = new RulesRepository(TestEnvironmentSessionHelper.getSession((boolean)false));
            return repo;
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to get repo to run tests", e);
        }
    }

    RestAPI getAPI() {
        return new RestAPI(RestAPIServlet.getRepository());
    }

    public static boolean allowUser(String auth) {
        if (auth == null) {
            return false;
        }
        if (!auth.toUpperCase().startsWith("BASIC ")) {
            return false;
        }
        String[] a = RestAPIServlet.unpack((String)auth);
        String usr = a[0];
        String pwd = a[1];
        if (Contexts.isApplicationContextActive()) {
            Identity ids = Identity.instance();
            ids.setUsername(usr);
            ids.setPassword(pwd);
            try {
                ids.authenticate();
                return true;
            }
            catch (LoginException e) {
                log.warn((Object)("Unable to authenticate for rest api: " + usr));
                return false;
            }
        }
        return usr.equals("test") && pwd.equals("password");
    }

    static String[] unpack(String auth) {
        String userpassEncoded = auth.substring(6);
        String userpassDecoded = new String(Base64.decode((byte[])userpassEncoded.getBytes()));
        String[] a = userpassDecoded.split(":");
        a[0] = a[0].trim();
        a[1] = a[1].trim();
        return a;
    }
}

