/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.ruleeditor;

import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.ChangeListener;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.gwtext.client.widgets.form.FormPanel;
import java.util.Date;
import org.drools.guvnor.client.common.FormStyleLayout;
import org.drools.guvnor.client.common.FormStylePopup;
import org.drools.guvnor.client.common.ImageButton;
import org.drools.guvnor.client.common.RulePackageSelector;
import org.drools.guvnor.client.common.SmallLabel;
import org.drools.guvnor.client.explorer.ExplorerLayoutManager;
import org.drools.guvnor.client.rpc.MetaData;
import org.drools.guvnor.client.ruleeditor.AssetCategoryEditor;
import org.drools.guvnor.client.ruleeditor.MetaDataWidget;
import org.drools.guvnor.client.ruleeditor.VersionBrowser;
import org.drools.guvnor.client.security.Capabilities;

public class MetaDataWidget
extends Composite {
    private MetaData data;
    private boolean readOnly;
    private String uuid;
    private Command refreshView;
    private VerticalPanel layout = new VerticalPanel();
    AssetCategoryEditor ed;
    private FormStyleLayout currentSection;
    private String currentSectionName;

    public MetaDataWidget(MetaData d, boolean readOnly, String uuid, Command refreshView) {
        Button show = new Button("[show more info...]");
        show.addClickListener((ClickListener)new /* Unavailable Anonymous Inner Class!! */);
        this.layout.add((Widget)new SmallLabel("Title: [<b>" + d.name + "</b>]"));
        this.layout.add((Widget)show);
        this.initWidget((Widget)this.layout);
    }

    private void render(MetaData d, boolean readOnly, String uuid, Command refreshView) {
        if (!readOnly) {
            ImageButton edit = new ImageButton("images/edit.gif", "Rename this asset");
            edit.addClickListener((ClickListener)new /* Unavailable Anonymous Inner Class!! */);
            this.addHeader("images/meta_data.png", d.name, (Image)edit);
        } else {
            this.addHeader("images/asset_version.png", d.name, null);
        }
        this.uuid = uuid;
        this.data = d;
        this.readOnly = readOnly;
        this.refreshView = refreshView;
        this.loadData(d);
    }

    private void addHeader(String img, String name, Image edit) {
        this.startSection(name);
        HorizontalPanel hp = new HorizontalPanel();
        hp.add((Widget)new SmallLabel("<b>" + name + "</b>"));
        if (edit != null) {
            hp.add((Widget)edit);
        }
        this.currentSection.addAttribute("Title:", (Widget)hp);
    }

    private void loadData(MetaData d) {
        this.data = d;
        this.addAttribute("Categories:", this.categories());
        this.addAttribute("Modified on:", this.readOnlyDate(this.data.lastModifiedDate));
        this.addAttribute("by:", (Widget)this.readOnlyText(this.data.lastContributor));
        this.addAttribute("Note:", (Widget)this.readOnlyText(this.data.checkinComment));
        if (!this.readOnly) {
            this.addAttribute("Created on:", this.readOnlyDate(this.data.createdDate));
        }
        this.addAttribute("Created by:", (Widget)this.readOnlyText(this.data.creator));
        this.addAttribute("Format:", (Widget)new SmallLabel("<b>" + this.data.format + "</b>"));
        this.addAttribute("Package:", this.packageEditor(this.data.packageName));
        this.addAttribute("Is Disabled:", this.editableBoolean((FieldBooleanBinding)new /* Unavailable Anonymous Inner Class!! */, "Disables this asset. It will not be included in any processing."));
        this.endSection();
        this.startSection("Other meta data ...");
        this.addAttribute("Subject:", this.editableText((FieldBinding)new /* Unavailable Anonymous Inner Class!! */, "A short description of the subject matter."));
        this.addAttribute("Type:", this.editableText((FieldBinding)new /* Unavailable Anonymous Inner Class!! */, "This is for classification purposes."));
        this.addAttribute("External link:", this.editableText((FieldBinding)new /* Unavailable Anonymous Inner Class!! */, "This is for relating the asset to an external system."));
        this.addAttribute("Source:", this.editableText((FieldBinding)new /* Unavailable Anonymous Inner Class!! */, "A short description or code indicating the source of the rule."));
        this.endSection(true);
        this.startSection("Version history ...");
        this.addAttribute("Current version number:", this.getVersionNumberLabel());
        if (!this.readOnly) {
            this.addRow(new VersionBrowser(this.uuid, this.data, this.refreshView));
        }
        this.endSection(true);
    }

    private void addRow(VersionBrowser versionBrowser) {
        this.currentSection.addRow((Widget)versionBrowser);
    }

    private void addAttribute(String string, Widget editable) {
        this.currentSection.addAttribute(string, editable);
    }

    private void endSection() {
        this.endSection(false);
    }

    private void endSection(boolean collapsed) {
        FormPanel config = new FormPanel();
        config.setTitle(this.currentSectionName);
        config.setCollapsible(true);
        config.setCollapsed(collapsed);
        config.add((Widget)this.currentSection);
        this.layout.add((Widget)config);
    }

    private void startSection(String name) {
        this.currentSection = new FormStyleLayout();
        this.currentSectionName = name;
    }

    private Widget packageEditor(String packageName) {
        if (this.readOnly || !ExplorerLayoutManager.shouldShow((Integer[])new Integer[]{Capabilities.SHOW_PACKAGE_VIEW})) {
            return this.readOnlyText(packageName);
        }
        HorizontalPanel horiz = new HorizontalPanel();
        horiz.setStyleName("metadata-Widget");
        horiz.add((Widget)this.readOnlyText(packageName));
        ImageButton editPackage = new ImageButton("images/edit.gif");
        editPackage.addClickListener((ClickListener)new /* Unavailable Anonymous Inner Class!! */);
        horiz.add((Widget)editPackage);
        return horiz;
    }

    private void showRenameAsset(Widget source) {
        FormStylePopup pop = new FormStylePopup("images/package_large.png", "Rename this item");
        TextBox box = new TextBox();
        pop.addAttribute("New name", (Widget)box);
        Button ok = new Button("Rename item");
        pop.addAttribute("", (Widget)ok);
        ok.addClickListener((ClickListener)new /* Unavailable Anonymous Inner Class!! */);
        pop.show();
    }

    private void showEditPackage(String pkg, Widget source) {
        FormStylePopup pop = new FormStylePopup("images/package_large.png", "Move this item to another package");
        pop.addAttribute("Current package:", (Widget)new Label(pkg));
        RulePackageSelector sel = new RulePackageSelector();
        pop.addAttribute("New package:", (Widget)sel);
        Button ok = new Button("Change package");
        pop.addAttribute("", (Widget)ok);
        ok.addClickListener((ClickListener)new /* Unavailable Anonymous Inner Class!! */);
        pop.show();
    }

    private Widget getVersionNumberLabel() {
        if (this.data.versionNumber == 0L) {
            return new SmallLabel("<i>Not checked in yet</i>");
        }
        return this.readOnlyText(Long.toString(this.data.versionNumber));
    }

    private Widget readOnlyDate(Date lastModifiedDate) {
        if (lastModifiedDate == null) {
            return null;
        }
        return new SmallLabel(lastModifiedDate.toLocaleString());
    }

    private Label readOnlyText(String text) {
        SmallLabel lbl = new SmallLabel(text);
        lbl.setWidth("100%");
        return lbl;
    }

    private Widget categories() {
        this.ed = new AssetCategoryEditor(this.data, this.readOnly);
        return this.ed;
    }

    private Widget editableText(FieldBinding bind, String toolTip) {
        if (!this.readOnly) {
            TextBox box = new TextBox();
            box.setTitle(toolTip);
            box.setText(bind.getValue());
            box.setVisibleLength(10);
            11 listener = new /* Unavailable Anonymous Inner Class!! */;
            box.addChangeListener((ChangeListener)listener);
            return box;
        }
        return new Label(bind.getValue());
    }

    private Widget editableBoolean(FieldBooleanBinding bind, String toolTip) {
        if (!this.readOnly) {
            CheckBox box = new CheckBox();
            box.setTitle(toolTip);
            box.setChecked(bind.getValue());
            12 listener = new /* Unavailable Anonymous Inner Class!! */;
            box.addClickListener((ClickListener)listener);
            return box;
        }
        CheckBox box = new CheckBox();
        box.setChecked(bind.getValue());
        box.setEnabled(false);
        return box;
    }

    public MetaData getData() {
        return this.data;
    }

    static /* synthetic */ VerticalPanel access$000(MetaDataWidget x0) {
        return x0.layout;
    }

    static /* synthetic */ void access$100(MetaDataWidget x0, MetaData x1, boolean x2, String x3, Command x4) {
        x0.render(x1, x2, x3, x4);
    }

    static /* synthetic */ void access$200(MetaDataWidget x0, Widget x1) {
        x0.showRenameAsset(x1);
    }

    static /* synthetic */ MetaData access$300(MetaDataWidget x0) {
        return x0.data;
    }

    static /* synthetic */ void access$400(MetaDataWidget x0, String x1, Widget x2) {
        x0.showEditPackage(x1, x2);
    }

    static /* synthetic */ String access$500(MetaDataWidget x0) {
        return x0.uuid;
    }

    static /* synthetic */ Command access$600(MetaDataWidget x0) {
        return x0.refreshView;
    }
}

