/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.packages;

import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.gwtext.client.data.Node;
import com.gwtext.client.widgets.tree.TreeNode;
import com.gwtext.client.widgets.tree.TreePanel;
import com.gwtext.client.widgets.tree.event.TreePanelListener;
import org.drools.guvnor.client.common.FormStylePopup;
import org.drools.guvnor.client.common.LoadingPopup;
import org.drools.guvnor.client.common.PrettyFormLayout;
import org.drools.guvnor.client.common.RulePackageSelector;
import org.drools.guvnor.client.explorer.ExplorerNodeConfig;
import org.drools.guvnor.client.explorer.ExplorerViewCenterPanel;
import org.drools.guvnor.client.explorer.GenericPanel;
import org.drools.guvnor.client.packages.PackageBuilderWidget;
import org.drools.guvnor.client.rpc.PackageConfigData;
import org.drools.guvnor.client.rpc.RepositoryServiceAsync;
import org.drools.guvnor.client.rpc.RepositoryServiceFactory;
import org.drools.guvnor.client.rpc.SnapshotInfo;
import org.drools.guvnor.client.rulelist.AssetItemGrid;
import org.drools.guvnor.client.rulelist.AssetItemGridDataLoader;
import org.drools.guvnor.client.rulelist.EditItemEvent;

public class SnapshotView
extends Composite {
    public static final String LATEST_SNAPSHOT = "LATEST";
    private PackageConfigData parentConf;
    private SnapshotInfo snapInfo;
    private Command close;
    private ExplorerViewCenterPanel centerPanel;

    public SnapshotView(SnapshotInfo snapInfo, PackageConfigData parentPackage, Command closeSnap, ExplorerViewCenterPanel center) {
        VerticalPanel vert = new VerticalPanel();
        this.snapInfo = snapInfo;
        this.parentConf = parentPackage;
        this.close = closeSnap;
        PrettyFormLayout head = new PrettyFormLayout();
        head.addHeader("images/snapshot.png", this.header());
        this.centerPanel = center;
        vert.add((Widget)head);
        vert.add(this.infoPanel());
        vert.setWidth("100%");
        this.initWidget((Widget)vert);
    }

    private Widget header() {
        FlexTable ft = new FlexTable();
        ft.setWidget(0, 0, (Widget)new Label("Viewing snapshot:"));
        ft.setWidget(0, 1, (Widget)new HTML("<b>" + this.snapInfo.name + "</b>"));
        ft.getFlexCellFormatter().setHorizontalAlignment(0, 0, HasHorizontalAlignment.ALIGN_RIGHT);
        ft.setWidget(1, 0, (Widget)new Label("For package:"));
        ft.setWidget(1, 1, (Widget)new Label(this.parentConf.name));
        ft.getFlexCellFormatter().setHorizontalAlignment(1, 0, HasHorizontalAlignment.ALIGN_RIGHT);
        HTML dLink = new HTML("<a href='" + PackageBuilderWidget.getDownloadLink((PackageConfigData)this.parentConf) + "' target='_blank'>click here to download binary (or copy URL for Rule Agent)</a>");
        ft.setWidget(2, 0, (Widget)new Label("Deployment URL:"));
        ft.setWidget(2, 1, (Widget)dLink);
        ft.getFlexCellFormatter().setHorizontalAlignment(2, 0, HasHorizontalAlignment.ALIGN_RIGHT);
        ft.setWidget(3, 0, (Widget)new Label("Snapshot created on:"));
        ft.setWidget(3, 1, (Widget)new Label(this.parentConf.lastModified.toLocaleString()));
        ft.getFlexCellFormatter().setHorizontalAlignment(4, 0, HasHorizontalAlignment.ALIGN_RIGHT);
        ft.setWidget(4, 0, (Widget)new Label("Comment:"));
        ft.setWidget(4, 1, (Widget)new Label(this.parentConf.checkinComment));
        ft.getFlexCellFormatter().setHorizontalAlignment(4, 0, HasHorizontalAlignment.ALIGN_RIGHT);
        HorizontalPanel actions = new HorizontalPanel();
        actions.add((Widget)this.getDeleteButton(this.snapInfo.name, this.parentConf.name));
        actions.add((Widget)this.getCopyButton(this.snapInfo.name, this.parentConf.name));
        ft.setWidget(5, 0, (Widget)actions);
        ft.getFlexCellFormatter().setColSpan(5, 0, 2);
        return ft;
    }

    private Button getDeleteButton(String snapshotName, String pkgName) {
        Button btn = new Button("Delete");
        btn.addClickListener((ClickListener)new /* Unavailable Anonymous Inner Class!! */);
        return btn;
    }

    private Button getCopyButton(String snapshotName, String packageName) {
        RepositoryServiceAsync serv = RepositoryServiceFactory.getService();
        Button btn = new Button("Copy");
        btn.addClickListener((ClickListener)new /* Unavailable Anonymous Inner Class!! */);
        return btn;
    }

    private Widget infoPanel() {
        return this.packageTree();
    }

    protected Widget packageTree() {
        TreeNode pkg = ExplorerNodeConfig.getPackageItemStructure((String)this.parentConf.name, (String)this.snapInfo.uuid);
        pkg.setUserObject((Object)this.snapInfo);
        TreeNode root = new TreeNode(this.snapInfo.name);
        root.appendChild((Node)pkg);
        TreePanel tp = GenericPanel.genericExplorerWidget((TreeNode)root);
        tp.setRootVisible(false);
        tp.addListener((TreePanelListener)new /* Unavailable Anonymous Inner Class!! */);
        return tp;
    }

    protected void showAssetList(String[] assetTypes) {
        String key = this.snapInfo.uuid;
        for (int i = 0; i < assetTypes.length; ++i) {
            key = key + assetTypes[i];
        }
        if (!this.centerPanel.showIfOpen(key)) {
            AssetItemGrid grid = new AssetItemGrid((EditItemEvent)new /* Unavailable Anonymous Inner Class!! */, "rulelist", (AssetItemGridDataLoader)new /* Unavailable Anonymous Inner Class!! */);
            VerticalPanel vp = new VerticalPanel();
            vp.add((Widget)new HTML("<i><small>Snapshot listing for: " + this.snapInfo.name + "</small></i>"));
            vp.add((Widget)grid);
            this.centerPanel.addTab("Snapshot items", true, (Widget)vp, key);
        }
    }

    public static void showNewSnapshot() {
        FormStylePopup pop = new FormStylePopup("images/snapshot.png", "New snapshot");
        RulePackageSelector sel = new RulePackageSelector();
        pop.addAttribute("For package:", (Widget)sel);
        Button ok = new Button("OK");
        pop.addAttribute("", (Widget)ok);
        pop.show();
        ok.addClickListener((ClickListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    public static void rebuildBinaries() {
        if (Window.confirm((String)"Rebuilding the snapshot binaries will take some time, and only needs to be done if the BRMS itself has been updated recently. This will also cause the rule agents to load the rules anew. Are you sure you want to do this?")) {
            LoadingPopup.showMessage((String)"Rebuilding snapshots. Please wait, this may take some time...");
            RepositoryServiceFactory.getService().rebuildSnapshots((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    static /* synthetic */ Command access$000(SnapshotView x0) {
        return x0.close;
    }

    static /* synthetic */ ExplorerViewCenterPanel access$100(SnapshotView x0) {
        return x0.centerPanel;
    }

    static /* synthetic */ SnapshotInfo access$200(SnapshotView x0) {
        return x0.snapInfo;
    }
}

