/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.explorer;

import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import com.gwtext.client.core.Ext;
import com.gwtext.client.core.Margins;
import com.gwtext.client.core.RegionPosition;
import com.gwtext.client.widgets.Button;
import com.gwtext.client.widgets.Component;
import com.gwtext.client.widgets.Panel;
import com.gwtext.client.widgets.TabPanel;
import com.gwtext.client.widgets.event.ButtonListener;
import com.gwtext.client.widgets.event.PanelListener;
import com.gwtext.client.widgets.event.TabPanelListener;
import com.gwtext.client.widgets.layout.BorderLayoutData;
import com.gwtext.client.widgets.layout.LayoutData;
import java.util.HashMap;
import java.util.Map;
import org.drools.guvnor.client.common.LoadingPopup;
import org.drools.guvnor.client.rpc.RepositoryServiceFactory;
import org.drools.guvnor.client.rpc.SnapshotInfo;
import org.drools.guvnor.client.ruleeditor.RuleViewer;
import org.drools.guvnor.client.rulelist.EditItemEvent;
import org.drools.guvnor.client.rulelist.QueryWidget;

public class ExplorerViewCenterPanel {
    final TabPanel tp;
    private HashMap<String, Panel> openedTabs = new HashMap();
    private String id = Ext.generateId();
    private BorderLayoutData centerLayoutData;
    private Map<String, RuleViewer> openedAssetEditors = new HashMap();
    private Button closeAllButton;

    public ExplorerViewCenterPanel() {
        this.tp = new TabPanel();
        this.tp.setBodyBorder(false);
        this.tp.setEnableTabScroll(true);
        this.tp.setAutoDestroy(true);
        this.tp.setResizeTabs(true);
        this.tp.setLayoutOnTabChange(true);
        this.tp.setActiveTab(0);
        this.tp.setEnableTabScroll(true);
        this.tp.setMinTabWidth(90);
        this.centerLayoutData = new BorderLayoutData(RegionPosition.CENTER);
        this.centerLayoutData.setMargins(new Margins(5, 0, 5, 5));
        String tok = History.getToken();
        this.tp.addListener((TabPanelListener)new /* Unavailable Anonymous Inner Class!! */);
        this.addCloseAllButton();
        this.openAssetByToken(tok);
    }

    private void addCloseAllButton() {
        this.closeAllButton = new Button("Close all items");
        this.closeAllButton.addListener((ButtonListener)new /* Unavailable Anonymous Inner Class!! */);
        this.tp.addButton(this.closeAllButton);
    }

    private void openAssetByToken(String tok) {
        if (tok != null && tok.startsWith("asset=")) {
            String uuid = tok.substring(6);
            this.openAsset(uuid);
        }
    }

    public TabPanel getPanel() {
        return this.tp;
    }

    public void addTab(String tabname, boolean closeable, Widget widget, String key) {
        String panelId = key + this.id;
        Panel localTP = new Panel();
        localTP.setClosable(closeable);
        localTP.setTitle(tabname);
        localTP.setId(panelId);
        localTP.setAutoScroll(true);
        localTP.add(widget);
        this.tp.add((Component)localTP, (LayoutData)this.centerLayoutData);
        localTP.addListener((PanelListener)new /* Unavailable Anonymous Inner Class!! */);
        if (widget instanceof RuleViewer) {
            this.openedAssetEditors.put(panelId, (RuleViewer)widget);
        }
        this.tp.activate(localTP.getId());
        this.openedTabs.put(key, localTP);
    }

    public boolean showIfOpen(String key) {
        if (this.openedTabs.containsKey(key)) {
            LoadingPopup.close();
            Panel tpi = (Panel)this.openedTabs.get(key);
            this.tp.activate(tpi.getId());
            return true;
        }
        return false;
    }

    public void close(String key) {
        this.tp.remove(key + this.id);
        Panel p = (Panel)this.openedTabs.remove(key);
        if (p != null) {
            p.destroy();
        }
    }

    public void openAsset(String uuid) {
        History.newItem((String)("asset=" + uuid));
        LoadingPopup.showMessage((String)"Loading asset...");
        if (!this.showIfOpen(uuid)) {
            RepositoryServiceFactory.getService().loadRuleAsset(uuid, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    public void openPackageEditor(String uuid, Command refPackageList) {
        if (!this.showIfOpen(uuid)) {
            LoadingPopup.showMessage((String)"Loading package information...");
            RepositoryServiceFactory.getService().loadPackageConfig(uuid, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    public void openFind() {
        if (!this.showIfOpen("FIND")) {
            this.addTab("Find", true, (Widget)new QueryWidget((EditItemEvent)new /* Unavailable Anonymous Inner Class!! */), "FIND");
        }
    }

    public void openSnapshot(SnapshotInfo snap) {
        if (!this.showIfOpen(snap.name + snap.uuid)) {
            LoadingPopup.showMessage((String)"Loading snapshot...");
            RepositoryServiceFactory.getService().loadPackageConfig(snap.uuid, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    static /* synthetic */ Map access$000(ExplorerViewCenterPanel x0) {
        return x0.openedAssetEditors;
    }

    static /* synthetic */ HashMap access$100(ExplorerViewCenterPanel x0) {
        return x0.openedTabs;
    }
}

