/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.files;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import net.sf.webdav.WebdavStore;
import org.apache.commons.io.IOUtils;
import org.drools.guvnor.server.files.RestAPIServlet;
import org.drools.repository.AssetItem;
import org.drools.repository.PackageItem;
import org.drools.repository.PackageIterator;
import org.drools.repository.RulesRepository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebDAVImpl
implements WebdavStore {
    static Map<String, byte[]> osxDoubleData = Collections.synchronizedMap(new WeakHashMap());
    final ThreadLocal<RulesRepository> tlRepo = new ThreadLocal();

    public WebDAVImpl(File f) {
    }

    public WebDAVImpl() {
    }

    public WebDAVImpl(RulesRepository testRepo) {
        this.tlRepo.set(testRepo);
    }

    RulesRepository getRepo() {
        return (RulesRepository)this.tlRepo.get();
    }

    public void begin(Principal pr) {
        this.tlRepo.set(RestAPIServlet.getRepository());
    }

    public void checkAuthentication() throws SecurityException {
    }

    public void commit() {
        this.getRepo().save();
        this.tlRepo.set(null);
    }

    public void createFolder(String uri) {
        String[] path = this.getPath(uri);
        if (path[0].equals("packages")) {
            if (path.length > 2) {
                throw new UnsupportedOperationException("Can't nest packages.");
            }
            RulesRepository repository = this.getRepo();
            if (repository.containsPackage(path[1])) {
                PackageItem pkg = repository.loadPackage(path[1]);
                pkg.archiveItem(false);
                pkg.checkin("<restored by webdav>");
            } else {
                repository.createPackage(path[1], "<from webdav>");
            }
        } else {
            throw new UnsupportedOperationException("Not able to create folders here...");
        }
    }

    public void createResource(String uri) {
        if (uri.endsWith(".DS_Store")) {
            return;
        }
        String[] path = this.getPath(uri);
        if (path[0].equals("packages")) {
            if (path.length > 3) {
                throw new UnsupportedOperationException("Can't do nested packages.");
            }
            String packageName = path[1];
            String[] resource = AssetItem.getAssetNameFromFileName((String)path[2]);
            RulesRepository repository = this.getRepo();
            PackageItem pkg = repository.loadPackage(packageName);
            if (path[2].startsWith("._")) {
                osxDoubleData.put(uri, null);
                return;
            }
            if (pkg.containsAsset(resource[0])) {
                AssetItem lazarus = pkg.loadAsset(resource[0]);
                lazarus.archiveItem(false);
            } else {
                AssetItem asset = pkg.addAsset(resource[0], "");
                asset.updateFormat(resource[1]);
            }
        } else {
            throw new UnsupportedOperationException("Can't add assets here.");
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public String[] getChildrenNames(String uri) {
        RulesRepository repository = this.getRepo();
        String[] path = this.getPath(uri);
        ArrayList<String> result = new ArrayList<String>();
        if (path.length == 0) {
            return new String[]{"packages", "snapshots"};
        }
        if (path[0].equals("packages")) {
            if (path.length > 2) {
                return null;
            }
            if (path.length == 1) {
                this.listPackages(repository, result);
                return result.toArray(new String[result.size()]);
            }
            PackageItem pkg = repository.loadPackage(path[1]);
            Iterator it = pkg.getAssets();
            while (it.hasNext()) {
                AssetItem asset = (AssetItem)it.next();
                if (asset.isArchived()) continue;
                result.add(asset.getName() + "." + asset.getFormat());
            }
            return result.toArray(new String[result.size()]);
        }
        if (!path[0].equals("snapshots")) throw new UnsupportedOperationException("Not a valid path : " + path[0]);
        if (path.length > 3) {
            return null;
        }
        if (path.length == 1) {
            this.listPackages(repository, result);
            return result.toArray(new String[result.size()]);
        }
        if (path.length == 2) {
            return repository.listPackageSnapshots(path[1]);
        }
        if (path.length != 3) throw new IllegalArgumentException();
        Iterator it = repository.loadPackageSnapshot(path[1], path[2]).getAssets();
        while (it.hasNext()) {
            AssetItem asset = (AssetItem)it.next();
            if (asset.isArchived()) continue;
            result.add(asset.getName() + "." + asset.getFormat());
        }
        return result.toArray(new String[result.size()]);
    }

    private void listPackages(RulesRepository repository, List<String> result) {
        PackageIterator it = repository.listPackages();
        while (it.hasNext()) {
            PackageItem pkg = (PackageItem)it.next();
            if (pkg.isArchived()) continue;
            result.add(pkg.getName());
        }
    }

    public Date getCreationDate(String uri) {
        RulesRepository repository = this.getRepo();
        String[] path = this.getPath(uri);
        if (path.length < 2) {
            return new Date();
        }
        if (path[0].equals("packages")) {
            PackageItem pkg = repository.loadPackage(path[1]);
            if (path.length == 2) {
                return pkg.getCreatedDate().getTime();
            }
            String fileName = path[2];
            String assetName = AssetItem.getAssetNameFromFileName((String)fileName)[0];
            AssetItem asset = pkg.loadAsset(assetName);
            return asset.getCreatedDate().getTime();
        }
        if (path[0].equals("snapshots")) {
            if (path.length == 2) {
                return new Date();
            }
            if (path.length == 3) {
                return repository.loadPackageSnapshot(path[1], path[2]).getCreatedDate().getTime();
            }
            if (path.length == 4) {
                PackageItem pkg = repository.loadPackageSnapshot(path[1], path[2]);
                AssetItem asset = pkg.loadAsset(AssetItem.getAssetNameFromFileName((String)path[3])[0]);
                return asset.getCreatedDate().getTime();
            }
            throw new UnsupportedOperationException();
        }
        throw new UnsupportedOperationException();
    }

    public Date getLastModified(String uri) {
        RulesRepository repository = this.getRepo();
        String[] path = this.getPath(uri);
        if (path.length < 2) {
            return new Date();
        }
        if (path[0].equals("packages")) {
            PackageItem pkg = repository.loadPackage(path[1]);
            if (path.length == 2) {
                return pkg.getLastModified().getTime();
            }
            String fileName = path[2];
            String assetName = AssetItem.getAssetNameFromFileName((String)fileName)[0];
            AssetItem asset = pkg.loadAsset(assetName);
            return asset.getLastModified().getTime();
        }
        if (path[0].equals("snapshots")) {
            if (path.length == 2) {
                return new Date();
            }
            if (path.length == 3) {
                return repository.loadPackageSnapshot(path[1], path[2]).getLastModified().getTime();
            }
            if (path.length == 4) {
                PackageItem pkg = repository.loadPackageSnapshot(path[1], path[2]);
                AssetItem asset = pkg.loadAsset(AssetItem.getAssetNameFromFileName((String)path[3])[0]);
                return asset.getLastModified().getTime();
            }
            throw new UnsupportedOperationException();
        }
        throw new UnsupportedOperationException();
    }

    public InputStream getResourceContent(String uri) {
        return this.getContent(uri);
    }

    private InputStream getContent(String uri) {
        RulesRepository repository = this.getRepo();
        String[] path = this.getPath(uri);
        if (path[0].equals("packages")) {
            String pkg = path[1];
            String asset = AssetItem.getAssetNameFromFileName((String)path[2])[0];
            AssetItem assetItem = repository.loadPackage(pkg).loadAsset(asset);
            return this.getAssetData(assetItem);
        }
        if (path[0].equals("snapshots")) {
            String pkg = path[1];
            String snap = path[2];
            String asset = AssetItem.getAssetNameFromFileName((String)path[3])[0];
            AssetItem assetItem = repository.loadPackageSnapshot(pkg, snap).loadAsset(asset);
            return this.getAssetData(assetItem);
        }
        throw new UnsupportedOperationException();
    }

    private InputStream getAssetData(AssetItem assetItem) {
        if (assetItem.isBinary()) {
            return assetItem.getBinaryContentAttachment();
        }
        return new ByteArrayInputStream(assetItem.getContent().getBytes());
    }

    public long getResourceLength(String uri) {
        String[] path = this.getPath(uri);
        try {
            RulesRepository repo = this.getRepo();
            if (path.length == 3 && path[0].equals("packages")) {
                PackageItem pkg = repo.loadPackage(path[1]);
                AssetItem asset = pkg.loadAsset(AssetItem.getAssetNameFromFileName((String)path[2])[0]);
                return asset.getContentLength();
            }
            if (path.length == 4 && path[0].equals("snapshots")) {
                PackageItem pkg = repo.loadPackageSnapshot(path[1], path[2]);
                AssetItem asset = pkg.loadAsset(AssetItem.getAssetNameFromFileName((String)path[3])[0]);
                return asset.getContentLength();
            }
            return 0L;
        }
        catch (Exception e) {
            System.err.println("Not able to get content length");
            return 0L;
        }
    }

    public boolean isFolder(String uri) {
        RulesRepository repository = this.getRepo();
        String[] path = this.getPath(uri);
        if (path.length == 0) {
            return true;
        }
        if (path.length == 1 && (path[0].equals("packages") || path[0].equals("snapshots"))) {
            return true;
        }
        if (path.length == 2) {
            return repository.containsPackage(path[1]);
        }
        if (path.length == 3 && path[0].equals("snapshots")) {
            return repository.containsPackage(path[1]);
        }
        return false;
    }

    public boolean isResource(String uri) {
        RulesRepository repository = this.getRepo();
        String[] path = this.getPath(uri);
        if (path.length < 3) {
            return false;
        }
        if (!path[0].equals("packages") && !path[0].equals("snapshots")) {
            return false;
        }
        if (repository.containsPackage(path[1])) {
            if (path[0].equals("packages")) {
                PackageItem pkg = repository.loadPackage(path[1]);
                if (path[2].startsWith("._")) {
                    return osxDoubleData.containsKey(uri);
                }
                return pkg.containsAsset(AssetItem.getAssetNameFromFileName((String)path[2])[0]);
            }
            if (path.length == 4) {
                PackageItem pkg = repository.loadPackageSnapshot(path[1], path[2]);
                return pkg.containsAsset(AssetItem.getAssetNameFromFileName((String)path[3])[0]);
            }
            return false;
        }
        return false;
    }

    public boolean objectExists(String uri) {
        if (uri.indexOf(" copy ") > 0) {
            throw new IllegalArgumentException("OSX is not capable of copy and pasting without breaking the file extension.");
        }
        return this.internalObjectExists(uri);
    }

    private boolean internalObjectExists(String uri) {
        RulesRepository repository = this.getRepo();
        if (uri.endsWith(".DS_Store")) {
            return false;
        }
        String[] path = this.getPath(uri);
        if (path.length == 0) {
            return true;
        }
        if (path.length == 1 && (path[0].equals("packages") || path[0].equals("snapshots"))) {
            return true;
        }
        if (path.length == 1) {
            return false;
        }
        if (!repository.containsPackage(path[1])) {
            return false;
        }
        if (path[0].equals("packages")) {
            if (path.length == 2) {
                PackageItem pkg = repository.loadPackage(path[1]);
                return !pkg.isArchived();
            }
            PackageItem pkg = repository.loadPackage(path[1]);
            if (path[2].startsWith("._")) {
                return osxDoubleData.containsKey(uri);
            }
            String assetName = AssetItem.getAssetNameFromFileName((String)path[2])[0];
            return pkg.containsAsset(assetName) && !pkg.loadAsset(assetName).isArchived();
        }
        if (path[0].equals("snapshots")) {
            if (path.length == 2) {
                return repository.containsPackage(path[1]);
            }
            if (path.length == 3) {
                return repository.containsSnapshot(path[1], path[2]);
            }
            if (path.length == 4) {
                PackageItem pkg = repository.loadPackageSnapshot(path[1], path[2]);
                return pkg.containsAsset(AssetItem.getAssetNameFromFileName((String)path[3])[0]);
            }
            return false;
        }
        throw new IllegalStateException();
    }

    public void removeObject(String uri) {
        RulesRepository repository = this.getRepo();
        String[] path = this.getPath(uri);
        if (path.length == 0 || path.length == 1) {
            throw new IllegalArgumentException();
        }
        if (path[0].equals("packages")) {
            String packName = path[1];
            PackageItem pkg = repository.loadPackage(packName);
            if (path.length == 3) {
                if (path[2].startsWith("._")) {
                    osxDoubleData.remove(uri);
                    return;
                }
                String asset = AssetItem.getAssetNameFromFileName((String)path[2])[0];
                AssetItem item = pkg.loadAsset(asset);
                item.archiveItem(true);
                item.checkin("");
            } else {
                pkg.archiveItem(true);
                pkg.checkin("");
            }
        } else {
            throw new IllegalArgumentException("Not allowed to remove this file.");
        }
    }

    public void rollback() {
        RulesRepository repository = this.getRepo();
        repository.getSession().logout();
    }

    public void setResourceContent(String uri, InputStream content, String contentType, String characterEncoding) {
        String packageName;
        RulesRepository repository = this.getRepo();
        if (uri.endsWith(".DS_Store")) {
            return;
        }
        String[] path = this.getPath(uri);
        if (path[0].equals("packages")) {
            if (path.length != 3) {
                throw new IllegalArgumentException("Not a valid resource path " + uri);
            }
            packageName = path[1];
            if (path[2].startsWith("._")) {
                try {
                    osxDoubleData.put(uri, IOUtils.toByteArray((InputStream)content));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                return;
            }
        } else {
            throw new UnsupportedOperationException("Unable to save content to this location.");
        }
        String[] assetName = AssetItem.getAssetNameFromFileName((String)path[2]);
        PackageItem pkg = repository.loadPackage(packageName);
        AssetItem asset = pkg.loadAsset(assetName[0]);
        asset.updateBinaryContentAttachment(content);
        asset.checkin("<content from webdav>");
    }

    String[] getPath(String uri) {
        if (uri.equals("/")) {
            return new String[0];
        }
        if (uri.endsWith("webdav") || uri.endsWith("webdav/")) {
            return new String[0];
        }
        if (uri.indexOf("webdav") > -1) {
            return uri.split("webdav/")[1].split("/");
        }
        return uri.substring(1).split("/");
    }
}

