/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.files;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.drools.guvnor.server.files.FeedServlet;
import org.drools.guvnor.server.files.RepositoryServlet;
import org.drools.guvnor.server.security.CategoryPathType;
import org.drools.guvnor.server.security.PackageNameType;
import org.drools.repository.AssetItem;
import org.drools.repository.AssetPageList;
import org.drools.repository.PackageItem;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.security.Identity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FeedServlet
extends RepositoryServlet {
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String url = request.getRequestURI();
        if (url.indexOf("feed/package") > -1) {
            this.doAuthorizedAction(request, response, (RepositoryServlet.A)new /* Unavailable Anonymous Inner Class!! */);
        } else if (url.indexOf("feed/category") > -1) {
            this.doAuthorizedAction(request, response, (RepositoryServlet.A)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    private void doCategoryFeed(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String cat = request.getParameter("name");
        String status = request.getParameter("status");
        this.checkCategoryPermission(cat);
        AssetPageList pg = this.getFileManager().repository.findAssetsByCategory(cat, false, 0, -1);
        Iterator it = pg.assets.iterator();
        ArrayList entries = new ArrayList();
        this.buildEntries(request, entries, it, status);
        AtomFeed feed = new AtomFeed("Category: " + cat, Calendar.getInstance(), request.getServerName() + cat, request.getServletPath(), request.getRequestURI(), entries, "Guvnor category of items: " + cat);
        response.setContentType("application/atom+xml");
        response.getOutputStream().print(feed.getAtom());
    }

    private void checkCategoryPermission(String cat) {
        if (Contexts.isSessionContextActive()) {
            Identity.instance().checkPermission((Object)new CategoryPathType(cat), "analyst.readonly");
        }
    }

    private void doPackageFeed(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String packageName = request.getParameter("name");
        this.checkPackageReadPermission(packageName);
        PackageItem pkg = this.getFileManager().repository.loadPackage(packageName);
        ArrayList entries = new ArrayList();
        Iterator it = pkg.getAssets();
        this.buildEntries(request, entries, it, request.getParameter("status"));
        AtomFeed feed = new AtomFeed("Knowledge package: " + pkg.getName(), pkg.getLastModified(), pkg.getUUID(), request.getServletPath(), request.getRequestURI(), entries, pkg.getDescription());
        response.setContentType("application/atom+xml");
        response.getOutputStream().print(feed.getAtom());
    }

    private void buildEntries(HttpServletRequest request, List<AtomFeed.AtomEntry> entries, Iterator<AssetItem> it, String status) {
        while (it.hasNext()) {
            AssetItem as = it.next();
            if (as.isArchived() || as.getDisabled() || status != null && !status.equals("*") && !as.getStateDescription().equals(status)) continue;
            entries.add(new AtomFeed.AtomEntry(request, as));
        }
    }

    private void checkPackageReadPermission(String packageName) {
        if (Contexts.isSessionContextActive()) {
            Identity.instance().checkPermission((Object)new PackageNameType(packageName), "package.readonly");
        }
    }

    static /* synthetic */ void access$000(FeedServlet x0, HttpServletRequest x1, HttpServletResponse x2) throws IOException {
        x0.doPackageFeed(x1, x2);
    }

    static /* synthetic */ void access$100(FeedServlet x0, HttpServletRequest x1, HttpServletResponse x2) throws IOException {
        x0.doCategoryFeed(x1, x2);
    }
}

