/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.contenthandler;

import com.google.gwt.user.client.rpc.SerializableException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.guvnor.client.rpc.RuleAsset;
import org.drools.guvnor.server.contenthandler.IRuleAsset;
import org.drools.repository.AssetItem;
import org.drools.repository.CategoryItem;
import org.drools.repository.PackageItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ContentHandler {
    public abstract void retrieveAssetContent(RuleAsset var1, PackageItem var2, AssetItem var3) throws SerializableException;

    public abstract void storeAssetContent(RuleAsset var1, AssetItem var2) throws SerializableException;

    public boolean isRuleAsset() {
        return this instanceof IRuleAsset;
    }

    private String findParentCategory(AssetItem asset, String currentCat) {
        CategoryItem item = asset.getRulesRepository().loadCategory("/");
        return this.findCategoryInChild(item, currentCat);
    }

    private String findCategoryInChild(CategoryItem item, String currentCat) {
        List children = item.getChildTags();
        for (int i = 0; i < children.size(); ++i) {
            if (((CategoryItem)children.get(i)).getName().equals(currentCat)) {
                return item.getName();
            }
            String check = this.findCategoryInChild((CategoryItem)children.get(i), currentCat);
            if (check == null || check.length() <= 0) continue;
            return check;
        }
        return "";
    }

    private String findKeyforValue(HashMap<String, String> catRules, String catToFind) {
        for (Map.Entry<String, String> entry : catRules.entrySet()) {
            if (!entry.getValue().equals(catToFind)) continue;
            return entry.getKey();
        }
        return "";
    }

    protected String parentNameFromCategory(AssetItem asset, String currentParent) {
        List cats = asset.getCategories();
        String catName = null;
        String parentCat = null;
        if (cats.size() > 0) {
            catName = ((CategoryItem)cats.get(0)).getName();
        }
        HashMap catRules = asset.getPackage().getCategoryRules();
        String newParent = currentParent;
        if (null != catRules && null != catName) {
            String ruleName = asset.getName();
            if (catRules.containsKey(ruleName)) {
                parentCat = this.findParentCategory(asset, (String)catRules.get(ruleName));
                newParent = parentCat != null && parentCat.length() > 0 && catRules.containsValue(parentCat) ? this.findKeyforValue(catRules, parentCat) : "";
            } else if (currentParent != null && currentParent.length() > 0) {
                newParent = currentParent;
            } else if (catRules.containsValue(catName)) {
                newParent = this.findKeyforValue(catRules, catName);
            }
        }
        return newParent;
    }
}

