/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.builder;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.drools.compiler.DroolsError;
import org.drools.compiler.DroolsParserException;
import org.drools.guvnor.server.ServiceImplementation;
import org.drools.guvnor.server.builder.BRMSPackageBuilder;
import org.drools.guvnor.server.builder.ContentAssemblyError;
import org.drools.guvnor.server.builder.ContentPackageAssembler;
import org.drools.guvnor.server.contenthandler.ContentHandler;
import org.drools.guvnor.server.contenthandler.ContentManager;
import org.drools.guvnor.server.contenthandler.IRuleAsset;
import org.drools.guvnor.server.selector.AssetSelector;
import org.drools.guvnor.server.selector.SelectorManager;
import org.drools.lang.descr.PackageDescr;
import org.drools.repository.AssetItem;
import org.drools.repository.AssetItemIterator;
import org.drools.repository.PackageItem;
import org.drools.repository.RulesRepositoryException;
import org.drools.repository.VersionableItem;
import org.drools.rule.Package;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContentPackageAssembler {
    private PackageItem pkg;
    private List<ContentAssemblyError> errors = new ArrayList();
    BRMSPackageBuilder builder;
    private String selectorConfigName;

    public ContentPackageAssembler(PackageItem pkg) {
        this(pkg, null);
    }

    public ContentPackageAssembler(PackageItem pkg, boolean compile) {
        this(pkg, compile, null);
    }

    public ContentPackageAssembler(PackageItem assetPackage, boolean compile, String selectorConfigName) {
        this.pkg = assetPackage;
        this.selectorConfigName = selectorConfigName;
        this.createBuilder();
        if (compile && this.preparePackage()) {
            this.buildPackage();
        }
    }

    public ContentPackageAssembler(PackageItem assetPackage, String selectorConfigName) {
        this(assetPackage, true, selectorConfigName);
    }

    public ContentPackageAssembler(AssetItem assetToBuild) {
        this.pkg = assetToBuild.getPackage();
        this.createBuilder();
        if (this.preparePackage()) {
            this.buildAsset(assetToBuild);
        }
    }

    public void createBuilder() {
        List jars = BRMSPackageBuilder.getJars((PackageItem)this.pkg);
        Properties ps = new Properties();
        try {
            ps = this.loadConfProperties(this.pkg);
        }
        catch (IOException e) {
            throw new RulesRepositoryException("Unable to load configuration properties for package.", (Throwable)e);
        }
        this.builder = BRMSPackageBuilder.getInstance((List)jars, (Properties)ps);
    }

    Properties loadConfProperties(PackageItem pkg) throws IOException {
        Properties ps = new Properties();
        AssetItemIterator iter = pkg.listAssetsByFormat(new String[]{"properties", "conf"});
        while (iter.hasNext()) {
            AssetItem conf = iter.next();
            conf.getContent();
            Properties p = new Properties();
            p.load(conf.getBinaryContentAttachment());
            ps.putAll((Map<?, ?>)p);
        }
        return ps;
    }

    private void buildPackage() {
        AssetSelector selector = SelectorManager.getInstance().getSelector(this.selectorConfigName);
        if (selector == null) {
            this.errors.add(new ContentAssemblyError((VersionableItem)this.pkg, "The selector named " + this.selectorConfigName + " is not available."));
            return;
        }
        AssetItemIterator drls = this.pkg.listAssetsByFormat(new String[]{"drl"});
        while (drls.hasNext()) {
            AssetItem asset = (AssetItem)drls.next();
            if (asset.isArchived() || !selector.isAssetAllowed(asset)) continue;
            this.buildAsset(asset);
        }
        Iterator it = this.pkg.getAssets();
        while (it.hasNext()) {
            AssetItem asset = (AssetItem)it.next();
            if (asset.getFormat().equals("drl") || asset.isArchived() || !selector.isAssetAllowed(asset)) continue;
            this.buildAsset(asset);
        }
    }

    private void buildAsset(AssetItem asset) {
        ContentHandler h = ContentManager.getHandler((String)asset.getFormat());
        if (h instanceof IRuleAsset && !asset.getDisabled()) {
            try {
                ((IRuleAsset)h).compile(this.builder, asset, new ErrorLogger(this));
                if (this.builder.hasErrors()) {
                    this.recordBuilderErrors((VersionableItem)asset);
                    this.builder.clearErrors();
                }
            }
            catch (DroolsParserException e) {
                throw new RulesRepositoryException((Throwable)e);
            }
            catch (IOException e) {
                throw new RulesRepositoryException((Throwable)e);
            }
        }
    }

    private boolean preparePackage() {
        this.builder.addPackage(new PackageDescr(this.pkg.getName()));
        this.loadDeclaredTypes();
        this.addDrl(ServiceImplementation.getDroolsHeader((PackageItem)this.pkg));
        if (this.builder.hasErrors()) {
            this.recordBuilderErrors((VersionableItem)this.pkg);
            return false;
        }
        this.loadDSLFiles();
        AssetItemIterator it = this.pkg.listAssetsByFormat(new String[]{"function"});
        while (it.hasNext()) {
            AssetItem func = it.next();
            if (func.getDisabled()) continue;
            this.addDrl(func.getContent());
            if (!this.builder.hasErrors()) continue;
            this.recordBuilderErrors((VersionableItem)func);
            this.builder.clearErrors();
        }
        return this.errors.size() == 0;
    }

    private void loadDeclaredTypes() {
        AssetItemIterator it = this.pkg.listAssetsByFormat(new String[]{"model.drl"});
        while (it.hasNext()) {
            AssetItem as = it.next();
            if (as.getDisabled()) continue;
            try {
                String content = as.getContent();
                if (!this.nonEmpty(content)) continue;
                this.builder.addPackageFromDrl((Reader)new StringReader(as.getContent()));
            }
            catch (DroolsParserException e) {
                this.errors.add(new ContentAssemblyError((VersionableItem)as, "Parser exception: " + e.getMessage()));
            }
            catch (IOException e) {
                this.errors.add(new ContentAssemblyError((VersionableItem)as, "IOException: " + e.getMessage()));
            }
        }
    }

    private boolean nonEmpty(String content) {
        return content != null && content.trim().length() > 0;
    }

    private void loadDSLFiles() {
        this.builder.setDSLFiles(BRMSPackageBuilder.getDSLMappingFiles((PackageItem)this.pkg, (BRMSPackageBuilder.DSLErrorEvent)new /* Unavailable Anonymous Inner Class!! */));
    }

    public boolean isPackageConfigurationInError() {
        if (this.errors.size() > 0) {
            return ((ContentAssemblyError)this.errors.get((int)0)).itemInError instanceof PackageItem;
        }
        return false;
    }

    private void addDrl(String drl) {
        if ("".equals(drl)) {
            return;
        }
        try {
            this.builder.addPackageFromDrl((Reader)new StringReader(drl));
        }
        catch (DroolsParserException e) {
            throw new RulesRepositoryException("Unexpected error when parsing package.", (Throwable)e);
        }
        catch (IOException e) {
            throw new RulesRepositoryException("IO Exception occurred when parsing package.", (Throwable)e);
        }
    }

    private void recordBuilderErrors(VersionableItem asset) {
        DroolsError[] errs = this.builder.getErrors().getErrors();
        for (int i = 0; i < errs.length; ++i) {
            this.errors.add(new ContentAssemblyError(asset, errs[i].getMessage()));
        }
    }

    public Package getBinaryPackage() {
        if (this.hasErrors()) {
            throw new IllegalStateException("There is no package available, as there were errors.");
        }
        return this.builder.getPackage();
    }

    public boolean hasErrors() {
        return this.errors.size() > 0;
    }

    public List<ContentAssemblyError> getErrors() {
        return this.errors;
    }

    public BRMSPackageBuilder getBuilder() {
        return this.builder;
    }

    public String getDRL() {
        StringBuffer src = new StringBuffer();
        src.append("package " + this.pkg.getName() + "\n");
        src.append(ServiceImplementation.getDroolsHeader((PackageItem)this.pkg) + "\n\n");
        this.builder.setDSLFiles(BRMSPackageBuilder.getDSLMappingFiles((PackageItem)this.pkg, (BRMSPackageBuilder.DSLErrorEvent)new /* Unavailable Anonymous Inner Class!! */));
        AssetItemIterator it = this.pkg.listAssetsByFormat(new String[]{"function", "model.drl"});
        while (it.hasNext()) {
            AssetItem func = it.next();
            if (func.isArchived() || func.getDisabled()) continue;
            src.append(func.getContent()).append("\n\n");
        }
        Iterator iter = this.pkg.getAssets();
        while (iter.hasNext()) {
            AssetItem asset = (AssetItem)iter.next();
            if (asset.isArchived() || asset.getDisabled()) continue;
            ContentHandler h = ContentManager.getHandler((String)asset.getFormat());
            if (h instanceof IRuleAsset) {
                IRuleAsset ruleAsset = (IRuleAsset)h;
                ruleAsset.assembleDRL(this.builder, asset, src);
            }
            src.append("\n\n");
        }
        return src.toString();
    }

    static /* synthetic */ List access$000(ContentPackageAssembler x0) {
        return x0.errors;
    }
}

