/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.packages;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.ChangeListener;
import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.gwtext.client.util.Format;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.drools.guvnor.client.categorynav.CategoryExplorerWidget;
import org.drools.guvnor.client.categorynav.CategorySelectHandler;
import org.drools.guvnor.client.common.FormStylePopup;
import org.drools.guvnor.client.common.ImageButton;
import org.drools.guvnor.client.common.InfoPopup;
import org.drools.guvnor.client.common.LoadingPopup;
import org.drools.guvnor.client.common.PrettyFormLayout;
import org.drools.guvnor.client.common.SmallLabel;
import org.drools.guvnor.client.common.StatusChangePopup;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.packages.PackageBuilderWidget;
import org.drools.guvnor.client.packages.PackageHeaderWidget;
import org.drools.guvnor.client.rpc.PackageConfigData;
import org.drools.guvnor.client.rpc.RepositoryServiceFactory;
import org.drools.guvnor.client.rpc.ValidatedResponse;
import org.drools.guvnor.client.rulelist.EditItemEvent;

/*
 * Exception performing whole class analysis ignored.
 */
public class PackageEditor2
extends PrettyFormLayout {
    private PackageConfigData conf;
    private HTML status;
    protected ValidatedResponse previousResponse;
    private Command close;
    private Command refreshPackageList;
    private EditItemEvent editEvent;
    private Constants constants = (Constants)GWT.create(Constants.class);

    public PackageEditor2(PackageConfigData data, Command close, Command refreshPackageList, EditItemEvent editEvent) {
        this.conf = data;
        this.close = close;
        this.refreshPackageList = refreshPackageList;
        this.editEvent = editEvent;
        this.setWidth("100%");
        this.refreshWidgets();
    }

    private void refreshWidgets() {
        this.clear();
        FlexTable headerWidgets = new FlexTable();
        headerWidgets.setWidget(0, 0, (Widget)new HTML("<b>" + this.constants.PackageName() + ":</b>"));
        headerWidgets.setWidget(0, 1, (Widget)new Label(this.conf.name));
        if (!this.conf.isSnapshot) {
            headerWidgets.setWidget(1, 0, this.modifyWidgets());
            headerWidgets.getFlexCellFormatter().setColSpan(1, 0, 2);
        }
        this.addHeader("images/package_large.png", (Widget)headerWidgets);
        this.startSection(this.constants.ConfigurationSection());
        this.addRow(this.warnings());
        this.addAttribute(this.constants.Configuration(), this.header());
        this.addAttribute(this.constants.DescriptionColon(), this.description());
        this.addAttribute(this.constants.CategoryRules(), this.getAddCatRules());
        this.addAttribute("", this.getShowCatRules());
        if (!this.conf.isSnapshot) {
            Button save = new Button(this.constants.SaveAndValidateConfiguration());
            save.addClickListener((ClickListener)new /* Unavailable Anonymous Inner Class!! */);
            this.addAttribute("", (Widget)save);
        }
        this.endSection();
        if (!this.conf.isSnapshot) {
            this.startSection(this.constants.BuildAndValidate());
            this.addRow((Widget)new PackageBuilderWidget(this.conf, this.editEvent));
            this.endSection();
        }
        this.startSection(this.constants.InformationAndImportantURLs());
        if (!this.conf.isSnapshot) {
            this.addAttribute(this.constants.LastModified() + ":", (Widget)new Label(this.getDateString(this.conf.lastModified)));
        }
        this.addAttribute(this.constants.LastContributor() + ":", (Widget)new Label(this.conf.lasContributor));
        this.addAttribute(this.constants.DateCreated(), (Widget)new Label(this.getDateString(this.conf.dateCreated)));
        Button buildSource = new Button(this.constants.ShowPackageSource());
        buildSource.addClickListener((ClickListener)new /* Unavailable Anonymous Inner Class!! */);
        this.addAttribute(this.constants.ShowPackageSource() + ":", (Widget)buildSource);
        HTML html = new HTML("<a href='" + PackageEditor2.getSourceDownload((PackageConfigData)this.conf) + "' target='_blank'>" + PackageEditor2.getSourceDownload((PackageConfigData)this.conf) + "</a>");
        this.addAttribute(this.constants.URLForPackageSource(), this.h((Widget)html, this.constants.URLSourceDescription()));
        HTML html2 = new HTML("<a href='" + PackageEditor2.getBinaryDownload((PackageConfigData)this.conf) + "' target='_blank'>" + PackageEditor2.getBinaryDownload((PackageConfigData)this.conf) + "</a>");
        this.addAttribute(this.constants.URLForPackageBinary(), this.h((Widget)html2, this.constants.UseThisUrlInTheRuntimeAgentToFetchAPreCompiledBinary()));
        HTML html3 = new HTML("<a href='" + PackageEditor2.getScenarios((PackageConfigData)this.conf) + "' target='_blank'>" + PackageEditor2.getScenarios((PackageConfigData)this.conf) + "</a>");
        this.addAttribute(this.constants.URLForRunningTests(), this.h((Widget)html3, this.constants.URLRunTestsRemote()));
        this.status = new HTML();
        HorizontalPanel statusBar = new HorizontalPanel();
        ImageButton editState = new ImageButton("images/edit.gif");
        editState.setTitle(this.constants.ChangeStatusDot());
        editState.addClickListener((ClickListener)new /* Unavailable Anonymous Inner Class!! */);
        statusBar.add((Widget)this.status);
        if (!this.conf.isSnapshot) {
            statusBar.add((Widget)editState);
        }
        this.setState(this.conf.state);
        this.addAttribute(this.constants.Status() + ":", (Widget)statusBar);
        this.endSection();
    }

    private Widget h(Widget w, String string) {
        HorizontalPanel hp = new HorizontalPanel();
        hp.add(w);
        hp.add((Widget)new InfoPopup(this.constants.Tip(), string));
        return hp;
    }

    private Widget getShowCatRules() {
        if (this.conf.catRules != null && this.conf.catRules.size() > 0) {
            VerticalPanel vp = new VerticalPanel();
            for (Map.Entry entry : this.conf.catRules.entrySet()) {
                HorizontalPanel hp = new HorizontalPanel();
                String m = Format.format((String)this.constants.AllRulesForCategory0WillNowExtendTheRule1(), (String)((String)entry.getValue()), (String)((String)entry.getKey()));
                hp.add((Widget)new SmallLabel(m));
                hp.add((Widget)this.getRemoveCatRulesIcon((String)entry.getKey()));
                vp.add((Widget)hp);
            }
            return vp;
        }
        return new HTML("&nbsp;&nbsp;");
    }

    private Image getRemoveCatRulesIcon(String rule) {
        Image remove = new Image("images/delete_item_small.gif");
        remove.addClickListener((ClickListener)new /* Unavailable Anonymous Inner Class!! */);
        return remove;
    }

    private Widget getAddCatRules() {
        ImageButton add = new ImageButton("images/new_item.gif");
        add.setTitle(this.constants.AddCatRuleToThePackage());
        add.addClickListener((ClickListener)new /* Unavailable Anonymous Inner Class!! */);
        HorizontalPanel hp = new HorizontalPanel();
        hp.add((Widget)add);
        hp.add((Widget)new InfoPopup(this.constants.CategoryParentRules(), this.constants.CatRulesInfo()));
        return hp;
    }

    private void addToCatRules(String category, String rule) {
        if (null != category && null != rule) {
            if (this.conf.catRules == null) {
                this.conf.catRules = new HashMap();
            }
            this.conf.catRules.put(rule, category);
        }
    }

    protected void showCatRuleSelector(Widget w) {
        FormStylePopup pop = new FormStylePopup("images/config.png", this.constants.AddACategoryRuleToThePackage());
        Button addbutton = new Button(this.constants.OK());
        TextBox ruleName = new TextBox();
        CategoryExplorerWidget exw = new CategoryExplorerWidget((CategorySelectHandler)new /* Unavailable Anonymous Inner Class!! */);
        ruleName.setVisibleLength(15);
        addbutton.setTitle(this.constants.CreateCategoryRule());
        addbutton.addClickListener((ClickListener)new /* Unavailable Anonymous Inner Class!! */);
        pop.addAttribute(this.constants.AllTheRulesInFollowingCategory(), (Widget)exw);
        pop.addAttribute(this.constants.WillExtendTheFollowingRuleCalled(), (Widget)ruleName);
        pop.addAttribute("", (Widget)addbutton);
        pop.show();
    }

    private String getDateString(Date d) {
        if (d != null) {
            return d.toLocaleString();
        }
        return "";
    }

    private Widget warnings() {
        if (this.previousResponse != null && this.previousResponse.hasErrors) {
            Image img = new Image("images/warning.gif");
            HorizontalPanel h = new HorizontalPanel();
            h.add((Widget)img);
            HTML msg = new HTML("<b>" + this.constants.ThereWereErrorsValidatingThisPackageConfiguration() + "</b>");
            h.add((Widget)msg);
            Button show = new Button(this.constants.ViewErrors());
            show.addClickListener((ClickListener)new /* Unavailable Anonymous Inner Class!! */);
            h.add((Widget)show);
            return h;
        }
        return new SimplePanel();
    }

    static String getSourceDownload(PackageConfigData conf) {
        return PackageEditor2.makeLink((PackageConfigData)conf) + ".drl";
    }

    static String getBinaryDownload(PackageConfigData conf) {
        return PackageEditor2.makeLink((PackageConfigData)conf);
    }

    static String getScenarios(PackageConfigData conf) {
        return PackageEditor2.makeLink((PackageConfigData)conf) + "/SCENARIOS";
    }

    public static String makeLink(PackageConfigData conf) {
        String hurl = GWT.getModuleBaseURL() + "package/" + conf.name;
        hurl = !conf.isSnapshot ? hurl + "/" + "LATEST" : hurl + "/" + conf.snapshotName;
        String uri = hurl;
        return uri;
    }

    protected void showStatusChanger(Widget w) {
        StatusChangePopup pop = new StatusChangePopup(this.conf.uuid, true);
        pop.setChangeStatusEvent((Command)new /* Unavailable Anonymous Inner Class!! */);
        pop.show();
    }

    private void setState(String state) {
        this.status.setHTML("<b>" + state + "</b>");
    }

    private Widget modifyWidgets() {
        HorizontalPanel horiz = new HorizontalPanel();
        Button copy = new Button(this.constants.Copy());
        copy.addClickListener((ClickListener)new /* Unavailable Anonymous Inner Class!! */);
        horiz.add((Widget)copy);
        Button rename = new Button(this.constants.Rename());
        rename.addClickListener((ClickListener)new /* Unavailable Anonymous Inner Class!! */);
        horiz.add((Widget)rename);
        Button archive = new Button(this.constants.Archive());
        archive.addClickListener((ClickListener)new /* Unavailable Anonymous Inner Class!! */);
        horiz.add((Widget)archive);
        return horiz;
    }

    private void showRenameDialog() {
        FormStylePopup pop = new FormStylePopup("images/new_wiz.gif", this.constants.RenameThePackage());
        pop.addRow((Widget)new HTML(this.constants.RenamePackageTip()));
        TextBox name = new TextBox();
        pop.addAttribute(this.constants.NewPackageNameIs(), (Widget)name);
        Button ok = new Button(this.constants.OK());
        pop.addAttribute("", (Widget)ok);
        ok.addClickListener((ClickListener)new /* Unavailable Anonymous Inner Class!! */);
        pop.show();
    }

    private void showCopyDialog() {
        FormStylePopup pop = new FormStylePopup("images/new_wiz.gif", this.constants.CopyThePackage());
        pop.addRow((Widget)new HTML(this.constants.CopyThePackageTip()));
        TextBox name = new TextBox();
        pop.addAttribute(this.constants.NewPackageNameIs(), (Widget)name);
        Button ok = new Button(this.constants.OK());
        pop.addAttribute("", (Widget)ok);
        ok.addClickListener((ClickListener)new /* Unavailable Anonymous Inner Class!! */);
        pop.show();
    }

    protected void doCopyPackage(String name) {
    }

    private void doSaveAction(Command refresh) {
        LoadingPopup.showMessage((String)this.constants.SavingPackageConfigurationPleaseWait());
        RepositoryServiceFactory.getService().savePackage(this.conf, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void reload() {
        LoadingPopup.showMessage((String)this.constants.RefreshingPackageData());
        RepositoryServiceFactory.getService().loadPackageConfig(this.conf.uuid, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private Widget externalURI() {
        TextBox box = new TextBox();
        box.setWidth("100%");
        box.setText(this.conf.externalURI);
        box.addChangeListener((ChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        return box;
    }

    private Widget header() {
        return new PackageHeaderWidget(this.conf);
    }

    private Widget description() {
        TextBox box = new TextBox();
        box.setText(this.conf.description);
        box.addChangeListener((ChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        box.setVisibleLength(64);
        return box;
    }

    static /* synthetic */ void access$000(PackageEditor2 x0, Command x1) {
        x0.doSaveAction(x1);
    }

    static /* synthetic */ PackageConfigData access$100(PackageEditor2 x0) {
        return x0.conf;
    }

    static /* synthetic */ Constants access$200(PackageEditor2 x0) {
        return x0.constants;
    }

    static /* synthetic */ void access$300(PackageEditor2 x0) {
        x0.refreshWidgets();
    }

    static /* synthetic */ void access$400(PackageEditor2 x0, String x1, String x2) {
        x0.addToCatRules(x1, x2);
    }

    static /* synthetic */ void access$500(PackageEditor2 x0, String x1) {
        x0.setState(x1);
    }

    static /* synthetic */ void access$600(PackageEditor2 x0) {
        x0.showCopyDialog();
    }

    static /* synthetic */ void access$700(PackageEditor2 x0) {
        x0.showRenameDialog();
    }

    static /* synthetic */ Command access$800(PackageEditor2 x0) {
        return x0.close;
    }

    static /* synthetic */ Command access$900(PackageEditor2 x0) {
        return x0.refreshPackageList;
    }

    static /* synthetic */ void access$1000(PackageEditor2 x0) {
        x0.reload();
    }

    static /* synthetic */ PackageConfigData access$102(PackageEditor2 x0, PackageConfigData x1) {
        x0.conf = x1;
        return x0.conf;
    }
}

