/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.explorer;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.ui.DockPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Widget;
import com.gwtext.client.core.Margins;
import com.gwtext.client.core.RegionPosition;
import com.gwtext.client.data.Node;
import com.gwtext.client.widgets.Component;
import com.gwtext.client.widgets.Panel;
import com.gwtext.client.widgets.QuickTips;
import com.gwtext.client.widgets.form.Field;
import com.gwtext.client.widgets.layout.AccordionLayout;
import com.gwtext.client.widgets.layout.BorderLayout;
import com.gwtext.client.widgets.layout.BorderLayoutData;
import com.gwtext.client.widgets.layout.ContainerLayout;
import com.gwtext.client.widgets.layout.FitLayout;
import com.gwtext.client.widgets.layout.LayoutData;
import com.gwtext.client.widgets.tree.TreeNode;
import com.gwtext.client.widgets.tree.TreePanel;
import org.drools.guvnor.client.LoggedInUserInfo;
import org.drools.guvnor.client.explorer.AdministrationPanel;
import org.drools.guvnor.client.explorer.CategoriesPanel;
import org.drools.guvnor.client.explorer.DeploymentPanel;
import org.drools.guvnor.client.explorer.ExplorerLayoutManager;
import org.drools.guvnor.client.explorer.ExplorerViewCenterPanel;
import org.drools.guvnor.client.explorer.PackagesPanel;
import org.drools.guvnor.client.explorer.Preferences;
import org.drools.guvnor.client.explorer.QAPanel;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.security.Capabilities;

/*
 * Exception performing whole class analysis ignored.
 */
public class ExplorerLayoutManager {
    protected static Capabilities capabilities;
    private ExplorerViewCenterPanel centertabbedPanel;
    private Panel northPanel;
    private Panel accordion;
    private Panel mainPanel;

    public ExplorerLayoutManager(LoggedInUserInfo uif, Capabilities caps) {
        Field.setMsgTarget((String)"side");
        QuickTips.init();
        Preferences.INSTANCE.loadPrefs(caps);
        String tok = History.getToken();
        this.centertabbedPanel = new ExplorerViewCenterPanel();
        BookmarkInfo bi = ExplorerLayoutManager.handleHistoryToken((String)tok);
        capabilities = caps;
        if (bi.showChrome) {
            this.northPanel = new Panel();
            DockPanel dock = new DockPanel();
            dock.setVerticalAlignment(DockPanel.ALIGN_MIDDLE);
            dock.add((Widget)new HTML("<div class='header'><img src='header_logo.gif' /></div>"), DockPanel.WEST);
            dock.add((Widget)uif, DockPanel.EAST);
            dock.setStyleName("header");
            dock.setWidth("100%");
            this.northPanel.add((Widget)dock);
            this.northPanel.setHeight(50);
            this.accordion = new Panel();
            this.accordion.setLayout((ContainerLayout)new AccordionLayout(true));
            this.createNavigationPanels();
            this.centertabbedPanel.openFind();
        }
        this.setUpMain(bi);
        if (bi.loadAsset) {
            this.centertabbedPanel.openAsset(bi.assetId);
        }
    }

    private void createNavigationPanels() {
        this.accordion.add((Component)new CategoriesPanel(this.centertabbedPanel));
        PackagesPanel tpPackageExplorer = new PackagesPanel(this.centertabbedPanel);
        if (ExplorerLayoutManager.shouldShow((Integer[])new Integer[]{Capabilities.SHOW_PACKAGE_VIEW})) {
            this.accordion.add((Component)tpPackageExplorer);
        }
        QAPanel tpQA = new QAPanel(this.centertabbedPanel);
        if (ExplorerLayoutManager.shouldShow((Integer[])new Integer[]{Capabilities.SHOW_QA})) {
            this.accordion.add((Component)tpQA);
        }
        DeploymentPanel tpDeployment = new DeploymentPanel(this.centertabbedPanel);
        if (ExplorerLayoutManager.shouldShow((Integer[])new Integer[]{Capabilities.SHOW_DEPLOYMENT, Capabilities.SHOW_DEPLOYMENT_NEW})) {
            this.accordion.add((Component)tpDeployment);
        }
        AdministrationPanel tpAdmin = new AdministrationPanel(this.centertabbedPanel);
        if (ExplorerLayoutManager.shouldShow((Integer[])new Integer[]{Capabilities.SHOW_ADMIN})) {
            this.accordion.add((Component)tpAdmin);
        }
    }

    private void setUpMain(BookmarkInfo bi) {
        this.mainPanel = new Panel();
        this.mainPanel.setLayout((ContainerLayout)new BorderLayout());
        this.mainPanel.setMargins(0, 0, 0, 0);
        BorderLayoutData northLayoutData = new BorderLayoutData(RegionPosition.NORTH);
        northLayoutData.setMargins(0, 0, 0, 0);
        BorderLayoutData centerLayoutData = new BorderLayoutData(RegionPosition.CENTER);
        centerLayoutData.setMargins(new Margins(5, 0, 5, 5));
        Panel centerPanelWrappper = new Panel();
        centerPanelWrappper.setLayout((ContainerLayout)new FitLayout());
        centerPanelWrappper.setBorder(false);
        centerPanelWrappper.setBodyBorder(false);
        if (bi.showChrome) {
            BorderLayoutData westLayoutData = new BorderLayoutData(RegionPosition.WEST);
            westLayoutData.setMargins(new Margins(5, 5, 0, 5));
            westLayoutData.setCMargins(new Margins(5, 5, 5, 5));
            westLayoutData.setMinSize(155);
            westLayoutData.setMaxSize(350);
            westLayoutData.setSplit(true);
            Panel westPanel = new Panel();
            westPanel.setId("side-nav");
            westPanel.setTitle(((Constants)GWT.create(Constants.class)).Navigate());
            westPanel.setLayout((ContainerLayout)new FitLayout());
            westPanel.setWidth(210);
            westPanel.setCollapsible(true);
            westPanel.add((Component)this.accordion);
            this.mainPanel.add((Component)westPanel, (LayoutData)westLayoutData);
        }
        centerPanelWrappper.add((Component)this.centertabbedPanel.getPanel());
        this.mainPanel.add((Component)centerPanelWrappper, (LayoutData)centerLayoutData);
        if (bi.showChrome) {
            this.mainPanel.add((Component)this.northPanel, (LayoutData)northLayoutData);
        }
    }

    public Panel getBaseLayout() {
        return this.mainPanel;
    }

    public static boolean shouldShow(Integer ... capability) {
        for (Integer cap : capability) {
            if (!ExplorerLayoutManager.capabilities.list.contains(cap)) continue;
            return true;
        }
        return false;
    }

    public static TreePanel genericExplorerWidget(TreeNode childNode) {
        TreePanel menuTree = new TreePanel();
        menuTree.setAnimate(true);
        menuTree.setEnableDD(true);
        menuTree.setContainerScroll(true);
        menuTree.setRootVisible(true);
        menuTree.setBodyBorder(false);
        menuTree.setBorder(false);
        menuTree.setRootNode((Node)childNode);
        return menuTree;
    }

    static BookmarkInfo handleHistoryToken(String tok) {
        if (tok == null) {
            return new BookmarkInfo();
        }
        BookmarkInfo bi = new BookmarkInfo();
        if (tok.startsWith("asset=")) {
            String uuid = tok.substring(6).split("&nochrome")[0];
            bi.loadAsset = true;
            bi.assetId = uuid;
        }
        if (tok.contains("nochrome") || tok.contains("nochrome==true")) {
            bi.showChrome = false;
        }
        return bi;
    }
}

