/*
 * Decompiled with CFR 0.152.
 */
package org.drools.grid.task;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.drools.eventmessaging.EventKey;
import org.drools.grid.generic.GenericNodeConnector;
import org.drools.grid.generic.Message;
import org.drools.grid.generic.MessageResponseHandler;
import org.drools.grid.task.HumanTaskService;
import org.drools.grid.task.TaskClientMessageHandlerImpl;
import org.drools.grid.task.eventmessaging.EventMessageResponseHandler;
import org.drools.task.Attachment;
import org.drools.task.Comment;
import org.drools.task.Content;
import org.drools.task.Task;
import org.drools.task.service.Command;
import org.drools.task.service.CommandName;
import org.drools.task.service.ContentData;
import org.drools.task.service.FaultData;
import org.drools.task.service.Operation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HumanTaskServiceImpl
implements HumanTaskService {
    private final GenericNodeConnector client;
    private final AtomicInteger counter;
    private int sessionId;
    private String clientName;

    public HumanTaskServiceImpl(GenericNodeConnector client, int sessionId) {
        this.client = client;
        this.counter = new AtomicInteger();
        this.clientName = String.valueOf(sessionId);
        this.sessionId = sessionId;
    }

    @Override
    public boolean connect() {
        try {
            return this.client.connect();
        }
        catch (RemoteException ex) {
            Logger.getLogger(HumanTaskServiceImpl.class.getName()).log(Level.SEVERE, null, ex);
            return false;
        }
    }

    @Override
    public void disconnect() {
        try {
            this.client.disconnect();
        }
        catch (RemoteException ex) {
            Logger.getLogger(HumanTaskServiceImpl.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void addTask(Task task, ContentData content, TaskClientMessageHandlerImpl.AddTaskMessageResponseHandler responseHandler) {
        ArrayList<Object> args = new ArrayList<Object>(2);
        args.add(task);
        args.add(content);
        Command cmd = new Command(this.counter.getAndIncrement(), CommandName.AddTaskRequest, args);
        Message msg = new Message(this.sessionId, this.counter.incrementAndGet(), false, (Object)cmd);
        this.client.write(msg, (MessageResponseHandler)responseHandler);
    }

    @Override
    public Task getTask(long taskId, TaskClientMessageHandlerImpl.GetTaskMessageResponseHandler responseHandler) {
        ArrayList<Long> args = new ArrayList<Long>(1);
        args.add(taskId);
        Command cmd = new Command(this.counter.getAndIncrement(), CommandName.GetTaskRequest, args);
        Message msg = new Message(this.sessionId, this.counter.incrementAndGet(), false, (Object)cmd);
        this.client.write(msg, (MessageResponseHandler)responseHandler);
        return null;
    }

    @Override
    public void addComment(long taskId, Comment comment, TaskClientMessageHandlerImpl.AddCommentMessageResponseHandler responseHandler) {
        ArrayList<Long> args = new ArrayList<Long>(2);
        args.add(taskId);
        args.add((Long)comment);
        Command cmd = new Command(this.counter.getAndIncrement(), CommandName.AddCommentRequest, args);
        Message msg = new Message(this.sessionId, this.counter.incrementAndGet(), false, (Object)cmd);
        this.client.write(msg, (MessageResponseHandler)responseHandler);
    }

    @Override
    public void deleteComment(long taskId, long commentId, TaskClientMessageHandlerImpl.DeleteCommentMessageResponseHandler responseHandler) {
        ArrayList<Long> args = new ArrayList<Long>(2);
        args.add(taskId);
        args.add(commentId);
        Command cmd = new Command(this.counter.getAndIncrement(), CommandName.DeleteCommentRequest, args);
        Message msg = new Message(this.sessionId, this.counter.incrementAndGet(), false, (Object)cmd);
        this.client.write(msg, (MessageResponseHandler)responseHandler);
    }

    @Override
    public void addAttachment(long taskId, Attachment attachment, Content content, TaskClientMessageHandlerImpl.AddAttachmentMessageResponseHandler responseHandler) {
        ArrayList<Long> args = new ArrayList<Long>(3);
        args.add(taskId);
        args.add((Long)attachment);
        args.add((Long)content);
        Command cmd = new Command(this.counter.getAndIncrement(), CommandName.AddAttachmentRequest, args);
        Message msg = new Message(this.sessionId, this.counter.incrementAndGet(), false, (Object)cmd);
        this.client.write(msg, (MessageResponseHandler)responseHandler);
    }

    @Override
    public void deleteAttachment(long taskId, long attachmentId, long contentId, TaskClientMessageHandlerImpl.DeleteAttachmentMessageResponseHandler responseHandler) {
        ArrayList<Long> args = new ArrayList<Long>(3);
        args.add(taskId);
        args.add(attachmentId);
        args.add(contentId);
        Command cmd = new Command(this.counter.getAndIncrement(), CommandName.DeleteAttachmentRequest, args);
        Message msg = new Message(this.sessionId, this.counter.incrementAndGet(), false, (Object)cmd);
        this.client.write(msg, (MessageResponseHandler)responseHandler);
    }

    @Override
    public void setDocumentContent(long taskId, Content content, TaskClientMessageHandlerImpl.SetDocumentMessageResponseHandler responseHandler) {
        ArrayList<Long> args = new ArrayList<Long>(2);
        args.add(taskId);
        args.add((Long)content);
        Command cmd = new Command(this.counter.getAndIncrement(), CommandName.SetDocumentContentRequest, args);
        Message msg = new Message(this.sessionId, this.counter.incrementAndGet(), false, (Object)cmd);
        this.client.write(msg, (MessageResponseHandler)responseHandler);
    }

    @Override
    public void getContent(long contentId, TaskClientMessageHandlerImpl.GetContentMessageResponseHandler responseHandler) {
        ArrayList<Long> args = new ArrayList<Long>(1);
        args.add(contentId);
        Command cmd = new Command(this.counter.getAndIncrement(), CommandName.GetContentRequest, args);
        Message msg = new Message(this.sessionId, this.counter.incrementAndGet(), false, (Object)cmd);
        this.client.write(msg, (MessageResponseHandler)responseHandler);
    }

    @Override
    public void claim(long taskId, String userId, TaskClientMessageHandlerImpl.TaskOperationMessageResponseHandler responseHandler) {
        ArrayList<Object> args = new ArrayList<Object>(3);
        args.add(Operation.Claim);
        args.add(taskId);
        args.add(userId);
        Command cmd = new Command(this.counter.getAndIncrement(), CommandName.OperationRequest, args);
        Message msg = new Message(this.sessionId, this.counter.incrementAndGet(), false, (Object)cmd);
        this.client.write(msg, (MessageResponseHandler)responseHandler);
    }

    @Override
    public void start(long taskId, String userId, TaskClientMessageHandlerImpl.TaskOperationMessageResponseHandler responseHandler) {
        ArrayList<Object> args = new ArrayList<Object>(3);
        args.add(Operation.Start);
        args.add(taskId);
        args.add(userId);
        Command cmd = new Command(this.counter.getAndIncrement(), CommandName.OperationRequest, args);
        Message msg = new Message(this.sessionId, this.counter.incrementAndGet(), false, (Object)cmd);
        this.client.write(msg, (MessageResponseHandler)responseHandler);
    }

    @Override
    public void stop(long taskId, String userId, TaskClientMessageHandlerImpl.TaskOperationMessageResponseHandler responseHandler) {
        ArrayList<Object> args = new ArrayList<Object>(3);
        args.add(Operation.Stop);
        args.add(taskId);
        args.add(userId);
        Command cmd = new Command(this.counter.getAndIncrement(), CommandName.OperationRequest, args);
        Message msg = new Message(this.sessionId, this.counter.incrementAndGet(), false, (Object)cmd);
        this.client.write(msg, (MessageResponseHandler)responseHandler);
    }

    @Override
    public void release(long taskId, String userId, TaskClientMessageHandlerImpl.TaskOperationMessageResponseHandler responseHandler) {
        ArrayList<Object> args = new ArrayList<Object>(3);
        args.add(Operation.Release);
        args.add(taskId);
        args.add(userId);
        Command cmd = new Command(this.counter.getAndIncrement(), CommandName.OperationRequest, args);
        Message msg = new Message(this.sessionId, this.counter.incrementAndGet(), false, (Object)cmd);
        this.client.write(msg, (MessageResponseHandler)responseHandler);
    }

    @Override
    public void suspend(long taskId, String userId, TaskClientMessageHandlerImpl.TaskOperationMessageResponseHandler responseHandler) {
        ArrayList<Object> args = new ArrayList<Object>(3);
        args.add(Operation.Suspend);
        args.add(taskId);
        args.add(userId);
        Command cmd = new Command(this.counter.getAndIncrement(), CommandName.OperationRequest, args);
        Message msg = new Message(this.sessionId, this.counter.incrementAndGet(), false, (Object)cmd);
        this.client.write(msg, (MessageResponseHandler)responseHandler);
    }

    @Override
    public void resume(long taskId, String userId, TaskClientMessageHandlerImpl.TaskOperationMessageResponseHandler responseHandler) {
        ArrayList<Object> args = new ArrayList<Object>(3);
        args.add(Operation.Resume);
        args.add(taskId);
        args.add(userId);
        Command cmd = new Command(this.counter.getAndIncrement(), CommandName.OperationRequest, args);
        Message msg = new Message(this.sessionId, this.counter.incrementAndGet(), false, (Object)cmd);
        this.client.write(msg, (MessageResponseHandler)responseHandler);
    }

    @Override
    public void skip(long taskId, String userId, TaskClientMessageHandlerImpl.TaskOperationMessageResponseHandler responseHandler) {
        ArrayList<Object> args = new ArrayList<Object>(3);
        args.add(Operation.Skip);
        args.add(taskId);
        args.add(userId);
        Command cmd = new Command(this.counter.getAndIncrement(), CommandName.OperationRequest, args);
        Message msg = new Message(this.sessionId, this.counter.incrementAndGet(), false, (Object)cmd);
        this.client.write(msg, (MessageResponseHandler)responseHandler);
    }

    @Override
    public void delegate(long taskId, String userId, String targetUserId, TaskClientMessageHandlerImpl.TaskOperationMessageResponseHandler responseHandler) {
        ArrayList<Object> args = new ArrayList<Object>(4);
        args.add(Operation.Delegate);
        args.add(taskId);
        args.add(userId);
        args.add(targetUserId);
        Command cmd = new Command(this.counter.getAndIncrement(), CommandName.OperationRequest, args);
        Message msg = new Message(this.sessionId, this.counter.incrementAndGet(), false, (Object)cmd);
        this.client.write(msg, (MessageResponseHandler)responseHandler);
    }

    @Override
    public void forward(long taskId, String userId, String targetEntityId, TaskClientMessageHandlerImpl.TaskOperationMessageResponseHandler responseHandler) {
        ArrayList<Object> args = new ArrayList<Object>(4);
        args.add(Operation.Forward);
        args.add(taskId);
        args.add(userId);
        args.add(targetEntityId);
        Command cmd = new Command(this.counter.getAndIncrement(), CommandName.OperationRequest, args);
        Message msg = new Message(this.sessionId, this.counter.incrementAndGet(), false, (Object)cmd);
        this.client.write(msg, (MessageResponseHandler)responseHandler);
    }

    @Override
    public void complete(long taskId, String userId, ContentData outputData, TaskClientMessageHandlerImpl.TaskOperationMessageResponseHandler responseHandler) {
        ArrayList<Object> args = new ArrayList<Object>(5);
        args.add(Operation.Complete);
        args.add(taskId);
        args.add(userId);
        args.add(null);
        args.add(outputData);
        Command cmd = new Command(this.counter.getAndIncrement(), CommandName.OperationRequest, args);
        Message msg = new Message(this.sessionId, this.counter.incrementAndGet(), false, (Object)cmd);
        this.client.write(msg, (MessageResponseHandler)responseHandler);
    }

    @Override
    public void fail(long taskId, String userId, FaultData faultData, TaskClientMessageHandlerImpl.TaskOperationMessageResponseHandler responseHandler) {
        ArrayList<Object> args = new ArrayList<Object>(5);
        args.add(Operation.Fail);
        args.add(taskId);
        args.add(userId);
        args.add(null);
        args.add(faultData);
        Command cmd = new Command(this.counter.getAndIncrement(), CommandName.OperationRequest, args);
        Message msg = new Message(this.sessionId, this.counter.incrementAndGet(), false, (Object)cmd);
        this.client.write(msg, (MessageResponseHandler)responseHandler);
    }

    @Override
    public void getTasksOwned(String userId, String language, TaskClientMessageHandlerImpl.TaskSummaryMessageResponseHandler responseHandler) {
        ArrayList<String> args = new ArrayList<String>(2);
        args.add(userId);
        args.add(language);
        Command cmd = new Command(this.counter.getAndIncrement(), CommandName.QueryTasksOwned, args);
        Message msg = new Message(this.sessionId, this.counter.incrementAndGet(), false, (Object)cmd);
        this.client.write(msg, (MessageResponseHandler)responseHandler);
    }

    @Override
    public void getTasksAssignedAsBusinessAdministrator(String userId, String language, TaskClientMessageHandlerImpl.TaskSummaryMessageResponseHandler responseHandler) {
        ArrayList<String> args = new ArrayList<String>(2);
        args.add(userId);
        args.add(language);
        Command cmd = new Command(this.counter.getAndIncrement(), CommandName.QueryTasksAssignedAsBusinessAdministrator, args);
        Message msg = new Message(this.sessionId, this.counter.incrementAndGet(), false, (Object)cmd);
        this.client.write(msg, (MessageResponseHandler)responseHandler);
    }

    @Override
    public void getTasksAssignedAsExcludedOwner(String userId, String language, TaskClientMessageHandlerImpl.TaskSummaryMessageResponseHandler responseHandler) {
        ArrayList<String> args = new ArrayList<String>(2);
        args.add(userId);
        args.add(language);
        Command cmd = new Command(this.counter.getAndIncrement(), CommandName.QueryTasksAssignedAsExcludedOwner, args);
        Message msg = new Message(this.sessionId, this.counter.incrementAndGet(), false, (Object)cmd);
        this.client.write(msg, (MessageResponseHandler)responseHandler);
    }

    @Override
    public void getTasksAssignedAsPotentialOwner(String userId, String language, TaskClientMessageHandlerImpl.TaskSummaryMessageResponseHandler responseHandler) {
        ArrayList<String> args = new ArrayList<String>(2);
        args.add(userId);
        args.add(language);
        Command cmd = new Command(this.counter.getAndIncrement(), CommandName.QueryTasksAssignedAsPotentialOwner, args);
        Message msg = new Message(this.sessionId, this.counter.incrementAndGet(), false, (Object)cmd);
        this.client.write(msg, (MessageResponseHandler)responseHandler);
    }

    @Override
    public void getTasksAssignedAsPotentialOwner(String userId, List<String> groupIds, String language, TaskClientMessageHandlerImpl.TaskSummaryMessageResponseHandler responseHandler) {
        ArrayList<Object> args = new ArrayList<Object>(2);
        args.add(userId);
        args.add(groupIds);
        args.add(language);
        Command cmd = new Command(this.counter.getAndIncrement(), CommandName.QueryTasksAssignedAsPotentialOwnerWithGroup, args);
        Message msg = new Message(this.sessionId, this.counter.incrementAndGet(), false, (Object)cmd);
        this.client.write(msg, (MessageResponseHandler)responseHandler);
    }

    @Override
    public void getSubTasksAssignedAsPotentialOwner(long parentId, String userId, String language, TaskClientMessageHandlerImpl.TaskSummaryMessageResponseHandler responseHandler) {
        ArrayList<Object> args = new ArrayList<Object>(2);
        args.add(parentId);
        args.add(userId);
        args.add(language);
        Command cmd = new Command(this.counter.getAndIncrement(), CommandName.QuerySubTasksAssignedAsPotentialOwner, args);
        Message msg = new Message(this.sessionId, this.counter.incrementAndGet(), false, (Object)cmd);
        this.client.write(msg, (MessageResponseHandler)responseHandler);
    }

    @Override
    public void getSubTasksByParent(long parentId, TaskClientMessageHandlerImpl.TaskSummaryMessageResponseHandler responseHandler) {
        ArrayList<Object> args = new ArrayList<Object>(2);
        args.add(parentId);
        args.add("en-UK");
        Command cmd = new Command(this.counter.getAndIncrement(), CommandName.QueryGetSubTasksByParentTaskId, args);
        Message msg = new Message(this.sessionId, this.counter.incrementAndGet(), false, (Object)cmd);
        this.client.write(msg, (MessageResponseHandler)responseHandler);
    }

    @Override
    public void getTasksAssignedAsRecipient(String userId, String language, TaskClientMessageHandlerImpl.TaskSummaryMessageResponseHandler responseHandler) {
        ArrayList<String> args = new ArrayList<String>(2);
        args.add(userId);
        args.add(language);
        Command cmd = new Command(this.counter.getAndIncrement(), CommandName.QueryTasksAssignedAsRecipient, args);
        Message msg = new Message(this.sessionId, this.counter.incrementAndGet(), false, (Object)cmd);
        this.client.write(msg, (MessageResponseHandler)responseHandler);
    }

    @Override
    public void getTasksAssignedAsTaskInitiator(String userId, String language, TaskClientMessageHandlerImpl.TaskSummaryMessageResponseHandler responseHandler) {
        ArrayList<String> args = new ArrayList<String>(2);
        args.add(userId);
        args.add(language);
        Command cmd = new Command(this.counter.getAndIncrement(), CommandName.QueryTasksAssignedAsTaskInitiator, args);
        Message msg = new Message(this.sessionId, this.counter.incrementAndGet(), false, (Object)cmd);
        this.client.write(msg, (MessageResponseHandler)responseHandler);
    }

    @Override
    public void getTasksAssignedAsTaskStakeholder(String userId, String language, TaskClientMessageHandlerImpl.TaskSummaryMessageResponseHandler responseHandler) {
        ArrayList<String> args = new ArrayList<String>(2);
        args.add(userId);
        args.add(language);
        Command cmd = new Command(this.counter.getAndIncrement(), CommandName.QueryTasksAssignedAsTaskStakeholder, args);
        Message msg = new Message(this.sessionId, this.counter.incrementAndGet(), false, (Object)cmd);
        this.client.write(msg, (MessageResponseHandler)responseHandler);
    }

    @Override
    public void registerForEvent(EventKey key, boolean remove, EventMessageResponseHandler responseHandler) {
        ArrayList<Object> args = new ArrayList<Object>(3);
        args.add(key);
        args.add(remove);
        args.add(this.clientName);
        Command cmd = new Command(this.counter.getAndIncrement(), CommandName.RegisterForEventRequest, args);
        int responseId = this.counter.incrementAndGet();
        Message msg = new Message(this.sessionId, responseId, false, (Object)cmd);
        this.client.write(msg, (MessageResponseHandler)responseHandler);
    }
}

