/*
 * Decompiled with CFR 0.152.
 */
package org.drools.examples.shopping;

import org.kie.api.io.ResourceType;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.internal.KnowledgeBase;
import org.kie.internal.KnowledgeBaseFactory;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.io.ResourceFactory;
import org.kie.internal.runtime.StatefulKnowledgeSession;

public class ShoppingExample {
    public static final void main(String[] args) {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"Shopping.drl", ShoppingExample.class), ResourceType.DRL);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        Customer mark = new Customer("mark", 0);
        ksession.insert((Object)mark);
        Product shoes = new Product("shoes", 60.0f);
        ksession.insert((Object)shoes);
        Product hat = new Product("hat", 60.0f);
        ksession.insert((Object)hat);
        ksession.insert((Object)new Purchase(mark, shoes));
        FactHandle hatPurchaseHandle = ksession.insert((Object)new Purchase(mark, hat));
        ksession.fireAllRules();
        ksession.retract(hatPurchaseHandle);
        System.out.println("Customer mark has returned the hat");
        ksession.fireAllRules();
    }

    public static class Purchase {
        private Customer customer;
        private Product product;

        public Purchase(Customer customer, Product product) {
            this.customer = customer;
            this.product = product;
        }

        public Customer getCustomer() {
            return this.customer;
        }

        public Product getProduct() {
            return this.product;
        }
    }

    public static class Product {
        private String name;
        private float price;

        public Product(String name, float price) {
            this.name = name;
            this.price = price;
        }

        public String getName() {
            return this.name;
        }

        public float getPrice() {
            return this.price;
        }
    }

    public static class Discount {
        private Customer customer;
        private int amount;

        public Discount(Customer customer, int amount) {
            this.customer = customer;
            this.amount = amount;
        }

        public Customer getCustomer() {
            return this.customer;
        }

        public int getAmount() {
            return this.amount;
        }
    }

    public static class Customer {
        private String name;
        private int discount;

        public Customer(String name, int discount) {
            this.name = name;
            this.discount = discount;
        }

        public String getName() {
            return this.name;
        }

        public int getDiscount() {
            return this.discount;
        }

        public void setDiscount(int discount) {
            this.discount = discount;
        }
    }
}

