/*
 * Decompiled with CFR 0.152.
 */
package org.drools.examples.sudoku.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridLayout;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.drools.examples.sudoku.swing.AbstractSudokuGridModel;
import org.drools.examples.sudoku.swing.SudokuGridEvent;
import org.drools.examples.sudoku.swing.SudokuGridListener;
import org.drools.examples.sudoku.swing.SudokuGridModel;

public class SudokuGridView
extends JComponent
implements SudokuGridListener,
ComponentListener {
    private static final long serialVersionUID = 510L;
    private SudokuGridModel model;
    private GridLayout gridLayout = new GridLayout(9, 9);
    private JTextField[][] textFields;

    public SudokuGridView() {
        this.setLayout(this.gridLayout);
        this.textFields = new JTextField[9][9];
        for (int row = 0; row < this.textFields.length; ++row) {
            for (int col = 0; col < this.textFields[row].length; ++col) {
                JTextField textField = new JTextField("");
                textField.setEditable(false);
                if (row == 0 && col == 0) {
                    textField.addComponentListener(this);
                }
                JPanel panel = new JPanel();
                int top = row % 3 == 0 ? 2 : 0;
                int left = col % 3 == 0 ? 2 : 0;
                int bottom = row == 8 ? 2 : 0;
                int right = col == 8 ? 2 : 0;
                panel.setBorder(BorderFactory.createMatteBorder(top, left, bottom, right, Color.BLACK));
                panel.setLayout(new BorderLayout());
                textField.setOpaque(true);
                textField.setBackground(Color.WHITE);
                textField.setHorizontalAlignment(0);
                this.textFields[row][col] = textField;
                panel.add("Center", textField);
                this.add(panel);
            }
        }
    }

    public SudokuGridView(SudokuGridModel model) {
        this();
        this.setModel(model);
    }

    public void setModel(SudokuGridModel model) {
        if (this.model != null && this.model instanceof AbstractSudokuGridModel) {
            ((AbstractSudokuGridModel)((Object)this.model)).removeSudokuGridListener(this);
        }
        this.model = model;
        this.refreshValues();
        if (this.model != null && this.model instanceof AbstractSudokuGridModel) {
            ((AbstractSudokuGridModel)((Object)this.model)).addSudokuGridListener(this);
        }
    }

    private void refreshValues() {
        for (int row = 0; row < this.textFields.length; ++row) {
            for (int col = 0; col < this.textFields[row].length; ++col) {
                this.refreshValue(row, col);
            }
        }
    }

    private void refreshValue(int row, int col) {
        String contents = this.model.getCellValue(row, col);
        this.textFields[row][col].setText(contents);
    }

    public void restart(SudokuGridEvent ev) {
        this.refreshValues();
    }

    public void cellModified(SudokuGridEvent ev) {
        this.refreshValue(ev.getRow(), ev.getCol());
    }

    public void componentHidden(ComponentEvent ev) {
    }

    public void componentMoved(ComponentEvent ev) {
    }

    public void componentResized(ComponentEvent ev) {
        JTextField textField = (JTextField)ev.getComponent();
        int height = textField.getHeight();
        Font font = textField.getFont();
        FontMetrics fontMetrics = textField.getGraphics().getFontMetrics(font);
        if (fontMetrics.getAscent() < height) {
            while (fontMetrics.getAscent() < height) {
                font = new Font(font.getName(), font.getStyle(), font.getSize() + 2);
                fontMetrics = textField.getGraphics().getFontMetrics(font);
            }
        } else if (fontMetrics.getAscent() > height) {
            while (fontMetrics.getAscent() > height) {
                font = new Font(font.getName(), font.getStyle(), font.getSize() - 2);
                fontMetrics = textField.getGraphics().getFontMetrics(font);
            }
        }
        for (int row = 0; row < this.textFields.length; ++row) {
            for (int col = 0; col < this.textFields[row].length; ++col) {
                this.textFields[row][col].setFont(font);
            }
        }
    }

    public void componentShown(ComponentEvent ev) {
    }
}

