/*
 * Decompiled with CFR 0.152.
 */
package org.drools.examples.sudoku;

import javax.swing.SwingUtilities;
import org.drools.KnowledgeBase;
import org.drools.event.rule.ObjectInsertedEvent;
import org.drools.event.rule.ObjectRetractedEvent;
import org.drools.event.rule.ObjectUpdatedEvent;
import org.drools.event.rule.WorkingMemoryEventListener;
import org.drools.examples.sudoku.Cell;
import org.drools.examples.sudoku.CellCol;
import org.drools.examples.sudoku.CellRow;
import org.drools.examples.sudoku.CellSqr;
import org.drools.examples.sudoku.Counter;
import org.drools.examples.sudoku.Setting;
import org.drools.examples.sudoku.swing.AbstractSudokuGridModel;
import org.drools.examples.sudoku.swing.SudokuGridEvent;
import org.drools.examples.sudoku.swing.SudokuGridModel;
import org.drools.runtime.StatefulKnowledgeSession;

public class Sudoku
extends AbstractSudokuGridModel
implements SudokuGridModel {
    private Cell[][] cells;
    private CellSqr[][] sqrs = new CellSqr[][]{new CellSqr[3], new CellSqr[3], new CellSqr[3]};
    private CellRow[] rows = new CellRow[9];
    private CellCol[] cols = new CellCol[9];
    private KnowledgeBase kBase;
    private StatefulKnowledgeSession session;
    private SudokuWorkingMemoryListener workingMemoryListener = new SudokuWorkingMemoryListener();
    private Counter counter;

    public Sudoku(KnowledgeBase kBase) {
        this.kBase = kBase;
    }

    public String getCellValue(int iRow, int iCol) {
        if (this.cells == null) {
            return " ";
        }
        return this.cells[iRow][iCol].valueAsString();
    }

    public void solve() {
        if (this.isSolved()) {
            return;
        }
        this.session.fireAllRules();
    }

    public void step() {
        if (this.isSolved()) {
            return;
        }
        this.counter.setCount(1);
        this.session.update(this.session.getFactHandle((Object)this.counter), (Object)this.counter);
        this.session.fireUntilHalt();
    }

    private boolean isSolved() {
        for (int iRow = 0; iRow < 9; ++iRow) {
            for (int iCol = 0; iCol < 9; ++iCol) {
                if (this.cells[iRow][iCol].getValue() != null) continue;
                return false;
            }
        }
        return true;
    }

    private void create() {
        int iCol;
        int iRow;
        int i;
        for (i = 0; i < 9; ++i) {
            this.session.insert((Object)(i + 1));
            this.rows[i] = new CellRow(i);
            this.cols[i] = new CellCol(i);
        }
        this.cells = new Cell[9][];
        for (iRow = 0; iRow < 9; ++iRow) {
            this.cells[iRow] = new Cell[9];
            for (iCol = 0; iCol < 9; ++iCol) {
                Cell cell = new Cell();
                this.cells[iRow][iCol] = cell;
                Cell cell2 = cell;
                this.rows[iRow].addCell(cell2);
                this.cols[iCol].addCell(cell2);
            }
        }
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.sqrs[i][j] = new CellSqr(this.rows[i * 3], this.rows[i * 3 + 1], this.rows[i * 3 + 2], this.cols[j * 3], this.cols[j * 3 + 1], this.cols[j * 3 + 2]);
            }
        }
        for (iRow = 0; iRow < 9; ++iRow) {
            for (iCol = 0; iCol < 9; ++iCol) {
                this.cells[iRow][iCol].makeReferences(this.rows[iRow], this.cols[iCol], this.sqrs[iRow / 3][iCol / 3]);
                this.session.insert((Object)this.cells[iRow][iCol]);
            }
            this.session.insert((Object)this.rows[iRow]);
            this.session.insert((Object)this.cols[iRow]);
            this.session.insert((Object)this.sqrs[iRow / 3][iRow % 3]);
        }
    }

    public void setCellValues(Integer[][] cellValues) {
        if (this.session != null) {
            this.session.removeEventListener((WorkingMemoryEventListener)this.workingMemoryListener);
            this.session.dispose();
        }
        System.out.println("setCellValues");
        this.session = this.kBase.newStatefulKnowledgeSession();
        this.session.addEventListener((WorkingMemoryEventListener)this.workingMemoryListener);
        this.create();
        int initial = 0;
        for (int iRow = 0; iRow < 9; ++iRow) {
            for (int iCol = 0; iCol < 9; ++iCol) {
                Integer value = cellValues[iRow][iCol];
                if (value == null) continue;
                this.session.insert((Object)new Setting(iRow, iCol, value));
                ++initial;
            }
        }
        this.counter = new Counter(initial);
        this.session.insert((Object)this.counter);
        this.session.fireUntilHalt();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Sudoku:").append('\n');
        for (int iRow = 0; iRow < 9; ++iRow) {
            sb.append("  ").append(this.rows[iRow].toString()).append('\n');
        }
        return sb.toString();
    }

    class SudokuWorkingMemoryListener
    implements WorkingMemoryEventListener {
        SudokuWorkingMemoryListener() {
        }

        public void objectInserted(ObjectInsertedEvent ev) {
            if (ev.getObject() instanceof Counter) {
                Sudoku.this.fireRestartEvent(null);
            }
        }

        public void objectRetracted(ObjectRetractedEvent ev) {
        }

        public void objectUpdated(ObjectUpdatedEvent ev) {
            Cell cell;
            if (ev.getObject() instanceof Cell && (cell = (Cell)ev.getObject()).getValue() != null) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        Sudoku.this.fireCellUpdatedEvent(new SudokuGridEvent(this, cell.getRowNo(), cell.getColNo(), cell.getValue()));
                    }
                });
            }
        }
    }
}

