/*
 * Decompiled with CFR 0.152.
 */
package org.drools.examples.broker.ui;

import com.jgoodies.looks.FontSets;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.JComponent;
import org.drools.examples.broker.model.StockTick;

public class ScrollingBanner
extends JComponent
implements Runnable {
    private static final long serialVersionUID = 510L;
    private static final long SPACE = 10L;
    private Queue<StockTick> ticks;
    private volatile boolean shutdown = false;
    private AtomicInteger headOffset = new AtomicInteger(0);
    private StockTick headTick = null;

    public ScrollingBanner() {
        this.ticks = new ConcurrentLinkedQueue<StockTick>();
        this.setBackground(Color.black);
        this.setForeground(Color.GREEN);
        this.setFont(FontSets.getLogicalFontSet().getTitleFont());
    }

    public void run() {
        this.shutdown = false;
        while (!this.shutdown) {
            this.repaint();
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                this.shutdown = true;
            }
        }
    }

    public void shutdown() {
        this.shutdown = true;
    }

    public void addTick(StockTick tick) {
        this.ticks.add(tick);
    }

    public void paint(Graphics g) {
        Dimension dim = this.getSize();
        int y = (dim.height - g.getFontMetrics().getHeight()) / 2 + g.getFontMetrics().getHeight() - 2;
        g.setColor(Color.BLACK);
        g.fillRect(0, 0, dim.width, dim.height);
        int width = 10;
        if (this.headTick == null) {
            this.headTick = this.ticks.poll();
            this.headOffset.set(0);
        }
        if (this.headTick != null) {
            String toDraw = this.headTick.toString().substring(this.headOffset.get());
            width = (int)((long)width + (10L + (long)this.drawString(g, y, width, this.headTick, toDraw)));
        }
        for (StockTick tick : this.ticks) {
            String toDraw;
            if ((width = (int)((long)width + (10L + (long)this.drawString(g, y, width, tick, toDraw = tick.toString())))) <= dim.width) continue;
            if (this.headOffset.addAndGet(2) < this.headTick.toString().length()) break;
            this.headTick = null;
            break;
        }
    }

    private int drawString(Graphics g, int y, int width, StockTick tick, String toDraw) {
        int size = g.getFontMetrics().stringWidth(toDraw);
        if (tick.getDelta() < 0.0) {
            g.setColor(Color.red);
        } else {
            g.setColor(Color.green);
        }
        g.drawString(toDraw, width, y);
        return size;
    }
}

