/*
 * Decompiled with CFR 0.152.
 */
package org.drools.commands.runtime.pmml;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import org.drools.commands.IdentifiableResult;
import org.kie.api.command.ExecutableCommand;
import org.kie.api.pmml.PMML4Result;
import org.kie.api.pmml.PMMLRequestData;
import org.kie.api.runtime.Context;
import org.kie.api.runtime.ExecutionResults;
import org.kie.internal.command.RegistryContext;
import org.kie.internal.pmml.PMMLCommandExecutorFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlRootElement(name="apply-pmml-model-command")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ApplyPmmlModelCommand
implements ExecutableCommand<PMML4Result>,
IdentifiableResult {
    private static Logger logger = LoggerFactory.getLogger(ApplyPmmlModelCommand.class);
    private static final long serialVersionUID = 19630331L;
    @XmlAttribute(name="outIdentifier")
    private String outIdentifier;
    @XmlAttribute(name="packageName")
    private String packageName;
    @XmlAttribute(name="hasMining")
    private Boolean hasMining;
    @XmlElement(name="requestData")
    private PMMLRequestData requestData;
    @XmlElements(value={@XmlElement(name="complexInputObject", type=Object.class)})
    private List<Object> complexInputObjects;

    public ApplyPmmlModelCommand() {
    }

    public ApplyPmmlModelCommand(PMMLRequestData requestData) {
        this.initialize(requestData, null, null);
    }

    public ApplyPmmlModelCommand(PMMLRequestData requestData, List<Object> complexInputList) {
        this.initialize(requestData, complexInputList, null);
    }

    public ApplyPmmlModelCommand(PMMLRequestData requestData, List<Object> complexInputList, Boolean hasMining) {
        this.initialize(requestData, complexInputList, hasMining);
    }

    private void initialize(PMMLRequestData requestData, List<Object> complexInputList, Boolean hasMining) {
        this.requestData = requestData;
        this.complexInputObjects = complexInputList != null ? new ArrayList<Object>(complexInputList) : new ArrayList();
        this.hasMining = hasMining != null ? hasMining : Boolean.FALSE;
    }

    public PMMLRequestData getRequestData() {
        return this.requestData;
    }

    public void setRequestData(PMMLRequestData requestData) {
        this.requestData = requestData;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public Boolean getHasMining() {
        return this.hasMining;
    }

    public void setHasMining(Boolean hasMining) {
        this.hasMining = hasMining;
    }

    public boolean isMining() {
        return this.hasMining != null && this.hasMining != false;
    }

    public void addComplexInputObject(Object o) {
        if (o != null) {
            this.complexInputObjects.add(o);
        }
    }

    @Override
    public String getOutIdentifier() {
        return this.outIdentifier;
    }

    @Override
    public void setOutIdentifier(String outIdentifier) {
        this.outIdentifier = outIdentifier;
    }

    public PMML4Result execute(Context context) {
        if (this.requestData == null) {
            throw new IllegalStateException("ApplyPmmlModelCommand requires request data (PMMLRequestData) to execute");
        }
        RegistryContext registryContext = (RegistryContext)context;
        PMML4Result toReturn = PMMLCommandExecutorFactory.get().newPMMLCommandExecutor().execute(this.requestData, context);
        Optional<ExecutionResults> execRes = Optional.ofNullable((ExecutionResults)registryContext.lookup(ExecutionResults.class));
        registryContext.register(PMML4Result.class, (Object)toReturn);
        execRes.ifPresent(result -> result.setResult("results", (Object)toReturn));
        return toReturn;
    }
}

