/*
 * Decompiled with CFR 0.152.
 */
package org.drools.commands;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.drools.commands.RequestContextImpl;
import org.drools.commands.impl.ContextImpl;
import org.kie.api.runtime.Context;

public class ConversationContextManager {
    private Map<String, Context> conversationContexts = new HashMap<String, Context>();

    public void startConversation(RequestContextImpl requestContext) {
        String conversationId = UUID.randomUUID().toString();
        ContextImpl ctx = new ContextImpl(conversationId, null);
        this.conversationContexts.put(conversationId, (Context)ctx);
        requestContext.setConversationContext((Context)ctx);
    }

    public void joinConversation(RequestContextImpl requestContext, String conversationId) {
        Context ctx = this.conversationContexts.get(conversationId);
        if (ctx == null) {
            throw new RuntimeException("Conversation cannot be found");
        }
        requestContext.setConversationContext(ctx);
    }

    public void endConversation(RequestContextImpl requestContext, String conversationId) {
        this.conversationContexts.remove(conversationId);
        requestContext.setConversationContext(null);
    }
}

