/*
 * Decompiled with CFR 0.152.
 */
package org.drools.commands;

import java.util.function.BiFunction;
import org.drools.commands.AbstractNewKieContainerCommand;
import org.kie.api.builder.ReleaseId;
import org.kie.api.command.ExecutableCommand;
import org.kie.api.runtime.Context;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.internal.command.RegistryContext;

public class NewKieSessionCommand
extends AbstractNewKieContainerCommand
implements ExecutableCommand<KieSession> {
    private static final long serialVersionUID = 8748826714594402049L;
    private String sessionName;
    private ReleaseId releaseId;
    private BiFunction<String, KieContainer, KieSessionConfiguration> customizeSessionConfiguration = (sessionName, kieContainer) -> kieContainer.getKieSessionConfiguration(sessionName);

    public NewKieSessionCommand(String sessionName2) {
        this.sessionName = sessionName2;
    }

    public NewKieSessionCommand(ReleaseId releaseId, String sessionName2) {
        this.sessionName = sessionName2;
        this.releaseId = releaseId;
    }

    public KieSession execute(Context context) {
        KieContainer kieContainer = this.getKieContainer((RegistryContext)context, this.releaseId);
        KieSessionConfiguration kieSessionConfiguration = this.customizeSessionConfiguration.apply(this.sessionName, kieContainer);
        KieSession ksession = kieContainer.newKieSession(this.sessionName, kieSessionConfiguration);
        ((RegistryContext)context).register(KieSession.class, (Object)ksession);
        return ksession;
    }

    public NewKieSessionCommand setCustomizeSessionConfiguration(BiFunction<String, KieContainer, KieSessionConfiguration> customizeSessionConfiguration) {
        this.customizeSessionConfiguration = customizeSessionConfiguration;
        return this;
    }

    public String toString() {
        return "NewKieSessionCommand{sessionName='" + this.sessionName + "', releaseId=" + this.releaseId + "}";
    }
}

