/*
 * Decompiled with CFR 0.152.
 */
package org.drools.benchmark.benchmarks;

import org.drools.benchmark.BenchmarkDefinition;
import org.drools.benchmark.benchmarks.AbstractBenchmark;
import org.drools.benchmark.model.Bean;
import org.kie.KnowledgeBase;
import org.kie.runtime.StatefulKnowledgeSession;
import org.kie.runtime.rule.FactHandle;

public class RandomBeansBenchmark
extends AbstractBenchmark {
    private final int beansNumber;
    private KnowledgeBase kbase;
    private StatefulKnowledgeSession ksession;
    private Bean[] beans;
    private FactHandle[] factHandles;

    public RandomBeansBenchmark(int beansNumber, String drlFile) {
        this.beansNumber = beansNumber;
        this.kbase = this.createKnowledgeBase(this.createKnowledgeBuilder(drlFile.split(",")));
    }

    @Override
    public void init(BenchmarkDefinition definition) {
        this.ksession = this.kbase.newStatefulKnowledgeSession();
        this.beans = Bean.generateRandomBeans(this.beansNumber);
        this.factHandles = new FactHandle[this.beans.length];
    }

    @Override
    public void execute(int repNr) {
        int i = 0;
        for (Bean bean : this.beans) {
            this.factHandles[i++] = this.ksession.insert((Object)bean);
        }
        this.ksession.fireAllRules();
        for (Bean bean : this.factHandles) {
            this.ksession.retract((FactHandle)bean);
        }
        this.ksession.fireAllRules();
    }

    @Override
    public void terminate() {
        this.ksession.dispose();
    }
}

