/*
 * Decompiled with CFR 0.152.
 */
package org.drools.benchmark.benchmarks;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.drools.benchmark.BenchmarkDefinition;
import org.drools.benchmark.benchmarks.AbstractBenchmark;
import org.drools.benchmark.model.manners.Context;
import org.drools.benchmark.model.manners.Count;
import org.drools.benchmark.model.manners.Guest;
import org.drools.benchmark.model.manners.Hobby;
import org.drools.benchmark.model.manners.LastSeat;
import org.drools.benchmark.model.manners.Sex;
import org.kie.KnowledgeBase;
import org.kie.runtime.StatefulKnowledgeSession;

public class MannersBenchmark
extends AbstractBenchmark {
    private StatefulKnowledgeSession ksession;

    @Override
    public void init(BenchmarkDefinition definition) {
        KnowledgeBase kbase = this.createKnowledgeBase(this.createKnowledgeBuilder("manners.drl"));
        this.ksession = kbase.newStatefulKnowledgeSession();
        InputStream is = this.getClass().getClassLoader().getResourceAsStream("manners128.dat");
        List<Object> list = this.getInputObjects(is);
        for (Object object : list) {
            this.ksession.insert(object);
        }
        this.ksession.insert((Object)new Count(1));
    }

    @Override
    public void execute(int repNr) {
        this.ksession.fireAllRules();
    }

    @Override
    public void terminate() {
        this.ksession.dispose();
    }

    private List<Object> getInputObjects(InputStream inputStream) {
        ArrayList<Object> list = new ArrayList<Object>();
        try {
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader(inputStream));
            while ((line = br.readLine()) != null) {
                if (line.trim().length() == 0 || line.trim().startsWith(";")) continue;
                StringTokenizer st = new StringTokenizer(line, "() ");
                String type = st.nextToken();
                if ("guest".equals(type)) {
                    if (!"name".equals(st.nextToken())) {
                        throw new IOException("expected 'name' in: " + line);
                    }
                    String name = st.nextToken();
                    if (!"sex".equals(st.nextToken())) {
                        throw new IOException("expected 'sex' in: " + line);
                    }
                    String sex = st.nextToken();
                    if (!"hobby".equals(st.nextToken())) {
                        throw new IOException("expected 'hobby' in: " + line);
                    }
                    String hobby = st.nextToken();
                    Guest guest = new Guest(name, Sex.resolve(sex), Hobby.resolve(hobby));
                    list.add(guest);
                }
                if ("last_seat".equals(type)) {
                    if (!"seat".equals(st.nextToken())) {
                        throw new IOException("expected 'seat' in: " + line);
                    }
                    list.add(new LastSeat(new Integer(st.nextToken())));
                }
                if (!"context".equals(type)) continue;
                if (!"state".equals(st.nextToken())) {
                    throw new IOException("expected 'state' in: " + line);
                }
                list.add(new Context(st.nextToken()));
            }
            inputStream.close();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not read inputstream properly.", e);
        }
        return list;
    }
}

