/*
 * Decompiled with CFR 0.152.
 */
package org.drools.agent;

import java.util.Properties;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactory;
import org.drools.agent.KnowledgeAgent;
import org.drools.agent.KnowledgeAgentConfiguration;
import org.drools.agent.KnowledgeAgentProvider;
import org.drools.builder.KnowledgeBuilderConfiguration;

public class KnowledgeAgentFactory {
    public static final String PROVIDER_CLASS_NAME_PROPERTY_NAME = "drools.agent.factory.provider";
    private static String providerClassName = "org.drools.agent.impl.KnowledgeAgentProviderImpl";
    private static KnowledgeAgentProvider provider;

    public static KnowledgeAgentConfiguration newKnowledgeAgentConfiguration() {
        return KnowledgeAgentFactory.getKnowledgeAgentProvider().newKnowledgeAgentConfiguration();
    }

    public static KnowledgeAgentConfiguration newKnowledgeAgentConfiguration(Properties properties) {
        return KnowledgeAgentFactory.getKnowledgeAgentProvider().newKnowledgeAgentConfiguration(properties);
    }

    public static KnowledgeAgent newKnowledgeAgent(String name) {
        return KnowledgeAgentFactory.getKnowledgeAgentProvider().newKnowledgeAgent(name, KnowledgeBaseFactory.newKnowledgeBase());
    }

    public static KnowledgeAgent newKnowledgeAgent(String name, KnowledgeBase kbase) {
        return KnowledgeAgentFactory.getKnowledgeAgentProvider().newKnowledgeAgent(name, kbase);
    }

    public static KnowledgeAgent newKnowledgeAgent(String name, KnowledgeAgentConfiguration configuration) {
        return KnowledgeAgentFactory.getKnowledgeAgentProvider().newKnowledgeAgent(name, KnowledgeBaseFactory.newKnowledgeBase(), configuration);
    }

    public static KnowledgeAgent newKnowledgeAgent(String name, KnowledgeBase kbase, KnowledgeAgentConfiguration configuration) {
        return KnowledgeAgentFactory.getKnowledgeAgentProvider().newKnowledgeAgent(name, kbase, configuration);
    }

    public static KnowledgeAgent newKnowledgeAgent(String name, KnowledgeBase kbase, KnowledgeAgentConfiguration configuration, KnowledgeBuilderConfiguration builderConfiguration) {
        return KnowledgeAgentFactory.getKnowledgeAgentProvider().newKnowledgeAgent(name, kbase, configuration, builderConfiguration);
    }

    private static synchronized void setKnowledgeAgentProvider(KnowledgeAgentProvider provider) {
        KnowledgeAgentFactory.provider = provider;
    }

    private static synchronized KnowledgeAgentProvider getKnowledgeAgentProvider() {
        if (provider == null) {
            KnowledgeAgentFactory.loadProvider();
        }
        return provider;
    }

    private static void loadProvider() {
        try {
            providerClassName = System.getProperty(PROVIDER_CLASS_NAME_PROPERTY_NAME, providerClassName);
            Class<?> cls = Class.forName(providerClassName);
            KnowledgeAgentFactory.setKnowledgeAgentProvider((KnowledgeAgentProvider)cls.newInstance());
        }
        catch (Exception e) {
            throw new RuntimeException("Provider " + providerClassName + " could not be set.");
        }
    }
}

