/*
 * Decompiled with CFR 0.152.
 */
package org.drools.analytics;

import java.util.List;
import org.drools.analytics.Solvers;
import org.drools.analytics.components.AnalyticsAccessorDescr;
import org.drools.analytics.components.AnalyticsAccumulateDescr;
import org.drools.analytics.components.AnalyticsClass;
import org.drools.analytics.components.AnalyticsCollectDescr;
import org.drools.analytics.components.AnalyticsComponent;
import org.drools.analytics.components.AnalyticsComponentType;
import org.drools.analytics.components.AnalyticsEvalDescr;
import org.drools.analytics.components.AnalyticsFieldAccessDescr;
import org.drools.analytics.components.AnalyticsFromDescr;
import org.drools.analytics.components.AnalyticsFunctionCallDescr;
import org.drools.analytics.components.AnalyticsMethodAccessDescr;
import org.drools.analytics.components.AnalyticsPredicateDescr;
import org.drools.analytics.components.AnalyticsRule;
import org.drools.analytics.components.Constraint;
import org.drools.analytics.components.Field;
import org.drools.analytics.components.LiteralRestriction;
import org.drools.analytics.components.OperatorDescr;
import org.drools.analytics.components.Pattern;
import org.drools.analytics.components.PatternPossibility;
import org.drools.analytics.components.QualifiedIdentifierRestriction;
import org.drools.analytics.components.ReturnValueRestriction;
import org.drools.analytics.components.RulePackage;
import org.drools.analytics.components.RulePossibility;
import org.drools.analytics.components.Variable;
import org.drools.analytics.components.VariableRestriction;
import org.drools.analytics.dao.AnalyticsData;
import org.drools.analytics.dao.AnalyticsDataFactory;
import org.drools.lang.descr.AccessorDescr;
import org.drools.lang.descr.AccumulateDescr;
import org.drools.lang.descr.AndDescr;
import org.drools.lang.descr.BaseDescr;
import org.drools.lang.descr.CollectDescr;
import org.drools.lang.descr.ConditionalElementDescr;
import org.drools.lang.descr.DeclarativeInvokerDescr;
import org.drools.lang.descr.EvalDescr;
import org.drools.lang.descr.ExistsDescr;
import org.drools.lang.descr.FieldAccessDescr;
import org.drools.lang.descr.FieldBindingDescr;
import org.drools.lang.descr.FieldConstraintDescr;
import org.drools.lang.descr.ForallDescr;
import org.drools.lang.descr.FromDescr;
import org.drools.lang.descr.FunctionCallDescr;
import org.drools.lang.descr.LiteralRestrictionDescr;
import org.drools.lang.descr.MethodAccessDescr;
import org.drools.lang.descr.NotDescr;
import org.drools.lang.descr.OrDescr;
import org.drools.lang.descr.PackageDescr;
import org.drools.lang.descr.PatternDescr;
import org.drools.lang.descr.PatternSourceDescr;
import org.drools.lang.descr.PredicateDescr;
import org.drools.lang.descr.QualifiedIdentifierRestrictionDescr;
import org.drools.lang.descr.RestrictionConnectiveDescr;
import org.drools.lang.descr.ReturnValueRestrictionDescr;
import org.drools.lang.descr.RuleDescr;
import org.drools.lang.descr.VariableRestrictionDescr;

public class PackageDescrFlattener {
    private Solvers solvers = new Solvers();
    private RulePackage currentPackage = null;
    private AnalyticsRule currentRule = null;
    private Pattern currentPattern = null;
    private Constraint currentConstraint = null;
    private AnalyticsClass currentClass = null;
    private Field currentField = null;

    public void insert(PackageDescr packageDescr) {
        AnalyticsData data = AnalyticsDataFactory.getAnalyticsData();
        RulePackage rulePackage = data.getRulePackageByName(packageDescr.getName());
        if (rulePackage == null) {
            rulePackage = new RulePackage();
            rulePackage.setName(packageDescr.getName());
            data.save(rulePackage);
        }
        this.currentPackage = rulePackage;
        this.flatten(packageDescr.getRules());
        this.formPossibilities();
    }

    private void flatten(List descrs) {
        for (Object o : descrs) {
            BaseDescr descr = (BaseDescr)o;
            if (descr instanceof PackageDescr) {
                this.flatten((PackageDescr)descr);
                continue;
            }
            if (descr instanceof RuleDescr) {
                this.flatten((RuleDescr)descr);
                continue;
            }
            if (descr instanceof PatternDescr) {
                this.flatten((PatternDescr)descr);
                continue;
            }
            if (descr instanceof VariableRestrictionDescr) {
                this.flatten((VariableRestrictionDescr)descr);
                continue;
            }
            if (descr instanceof FieldBindingDescr) {
                this.flatten((FieldBindingDescr)descr);
                continue;
            }
            if (descr instanceof FieldConstraintDescr) {
                this.flatten((FieldConstraintDescr)descr);
                continue;
            }
            if (descr instanceof RestrictionConnectiveDescr) {
                this.flatten((RestrictionConnectiveDescr)descr);
                continue;
            }
            if (descr instanceof LiteralRestrictionDescr) {
                this.flatten((LiteralRestrictionDescr)descr);
                continue;
            }
            if (descr instanceof ReturnValueRestrictionDescr) {
                this.flatten((ReturnValueRestrictionDescr)descr);
                continue;
            }
            if (descr instanceof QualifiedIdentifierRestrictionDescr) {
                this.flatten((QualifiedIdentifierRestrictionDescr)descr);
                continue;
            }
            if (descr instanceof FunctionCallDescr) {
                this.flatten((FunctionCallDescr)descr);
                continue;
            }
            if (descr instanceof PredicateDescr) {
                this.flatten((PredicateDescr)descr);
                continue;
            }
            if (descr instanceof AccessorDescr) {
                this.flatten((AccessorDescr)descr);
                continue;
            }
            if (descr instanceof MethodAccessDescr) {
                this.flatten((MethodAccessDescr)descr);
                continue;
            }
            if (descr instanceof FieldAccessDescr) {
                this.flatten((FieldAccessDescr)descr);
                continue;
            }
            if (descr instanceof PatternSourceDescr) {
                this.flatten((PatternSourceDescr)descr);
                continue;
            }
            if (!(descr instanceof ConditionalElementDescr)) continue;
            this.flatten((ConditionalElementDescr)descr);
        }
    }

    private AnalyticsComponent flatten(PatternSourceDescr descr) {
        if (descr instanceof AccumulateDescr) {
            return this.flatten((AccumulateDescr)descr);
        }
        if (descr instanceof CollectDescr) {
            return this.flatten((CollectDescr)descr);
        }
        if (descr instanceof FromDescr) {
            return this.flatten((FromDescr)descr);
        }
        return null;
    }

    private AnalyticsComponent flatten(DeclarativeInvokerDescr descr) {
        if (descr instanceof AccessorDescr) {
            return this.flatten((AccessorDescr)descr);
        }
        if (descr instanceof FieldAccessDescr) {
            return this.flatten((FieldAccessDescr)descr);
        }
        if (descr instanceof FunctionCallDescr) {
            return this.flatten((FunctionCallDescr)descr);
        }
        if (descr instanceof MethodAccessDescr) {
            return this.flatten((MethodAccessDescr)descr);
        }
        return null;
    }

    private void flatten(ConditionalElementDescr descr) {
        if (descr instanceof AndDescr) {
            this.flatten((AndDescr)descr);
        } else if (descr instanceof CollectDescr) {
            this.flatten((CollectDescr)descr);
        } else if (descr instanceof EvalDescr) {
            this.flatten((EvalDescr)descr);
        } else if (descr instanceof ExistsDescr) {
            this.flatten((ExistsDescr)descr);
        } else if (descr instanceof ForallDescr) {
            this.flatten((ForallDescr)descr);
        } else if (descr instanceof FromDescr) {
            this.flatten((FromDescr)descr);
        } else if (descr instanceof NotDescr) {
            this.flatten((NotDescr)descr);
        } else if (descr instanceof OrDescr) {
            this.flatten((OrDescr)descr);
        }
    }

    private void flatten(ForallDescr descr) {
        this.solvers.startForall();
        this.flatten(descr.getDescrs());
        this.solvers.endForall();
    }

    private void flatten(ExistsDescr descr) {
        this.solvers.startExists();
        this.flatten(descr.getDescrs());
        this.solvers.endExists();
    }

    private void flatten(NotDescr descr) {
        this.solvers.startNot();
        this.flatten(descr.getDescrs());
        this.solvers.endNot();
    }

    private AnalyticsFunctionCallDescr flatten(FunctionCallDescr descr) {
        AnalyticsFunctionCallDescr functionCall = new AnalyticsFunctionCallDescr();
        functionCall.setName(descr.getName());
        functionCall.setArguments(descr.getArguments());
        return functionCall;
    }

    private AnalyticsPredicateDescr flatten(PredicateDescr descr) {
        AnalyticsPredicateDescr predicate = new AnalyticsPredicateDescr();
        predicate.setContent(descr.getContent().toString());
        predicate.setClassMethodName(descr.getClassMethodName());
        return predicate;
    }

    private AnalyticsEvalDescr flatten(EvalDescr descr) {
        AnalyticsEvalDescr eval = new AnalyticsEvalDescr();
        eval.setContent(descr.getContent().toString());
        eval.setClassMethodName(descr.getClassMethodName());
        return eval;
    }

    private AnalyticsFromDescr flatten(FromDescr descr) {
        AnalyticsFromDescr from = new AnalyticsFromDescr();
        AnalyticsComponent ds = this.flatten(descr.getDataSource());
        from.setDataSourceId(ds.getId());
        from.setDataSourceType(ds.getComponentType());
        return from;
    }

    private AnalyticsAccumulateDescr flatten(AccumulateDescr descr) {
        AnalyticsAccumulateDescr accumulate = new AnalyticsAccumulateDescr();
        accumulate.setInputPatternId(this.flatten(descr.getInputPattern()));
        accumulate.setInitCode(descr.getInitCode());
        accumulate.setActionCode(descr.getActionCode());
        accumulate.setReverseCode(descr.getReverseCode());
        accumulate.setResultCode(descr.getResultCode());
        accumulate.setClassName(descr.getClassName());
        accumulate.setExternalFunction(descr.isExternalFunction());
        accumulate.setFunctionIdentifier(descr.getFunctionIdentifier());
        accumulate.setExpression(descr.getExpression());
        return accumulate;
    }

    private AnalyticsCollectDescr flatten(CollectDescr descr) {
        AnalyticsCollectDescr collect = new AnalyticsCollectDescr();
        collect.setClassMethodName(descr.getClassMethodName());
        collect.setInsidePatternId(this.flatten(descr.getInputPattern()));
        return collect;
    }

    private AnalyticsAccessorDescr flatten(AccessorDescr descr) {
        AnalyticsAccessorDescr accessor = new AnalyticsAccessorDescr();
        return accessor;
    }

    private AnalyticsMethodAccessDescr flatten(MethodAccessDescr descr) {
        AnalyticsMethodAccessDescr accessor = new AnalyticsMethodAccessDescr();
        accessor.setMethodName(descr.getMethodName());
        accessor.setArguments(descr.getArguments());
        return accessor;
    }

    private AnalyticsFieldAccessDescr flatten(FieldAccessDescr descr) {
        AnalyticsFieldAccessDescr accessor = new AnalyticsFieldAccessDescr();
        accessor.setFieldName(descr.getFieldName());
        accessor.setArgument(descr.getArgument());
        return accessor;
    }

    private void flatten(PackageDescr descr) {
        this.flatten(descr.getRules());
    }

    private void flatten(RuleDescr descr) {
        AnalyticsData data = AnalyticsDataFactory.getAnalyticsData();
        AnalyticsRule rule = new AnalyticsRule();
        rule.setRuleName(descr.getName());
        rule.setRuleSalience(descr.getSalience());
        rule.setConsequence(descr.getConsequence().toString());
        rule.setLineNumber(descr.getLine());
        rule.setPackageId(this.currentPackage.getId());
        data.save(rule);
        this.currentPackage.getRules().add(rule);
        this.currentRule = rule;
        this.solvers.startRuleSolver(rule);
        this.flatten(descr.getLhs());
        this.solvers.endRuleSolver();
    }

    private void flatten(OrDescr descr) {
        OperatorDescr operatorDescr = OperatorDescr.valueOf(OperatorDescr.Type.OR);
        this.solvers.startOperator(operatorDescr);
        this.flatten(descr.getDescrs());
        this.solvers.endOperator();
    }

    private void flatten(AndDescr descr) {
        OperatorDescr operatorDescr = OperatorDescr.valueOf(OperatorDescr.Type.AND);
        this.solvers.startOperator(operatorDescr);
        this.flatten(descr.getDescrs());
        this.solvers.endOperator();
    }

    private int flatten(PatternDescr descr) {
        AnalyticsData data = AnalyticsDataFactory.getAnalyticsData();
        AnalyticsClass clazz = data.getClassByPackageAndName(descr.getObjectType());
        if (clazz == null) {
            clazz = new AnalyticsClass();
            clazz.setName(descr.getObjectType());
            data.save(clazz);
        }
        this.currentClass = clazz;
        Pattern pattern = new Pattern();
        pattern.setRuleId(this.currentRule.getId());
        pattern.setRuleName(this.currentRule.getRuleName());
        pattern.setClassId(clazz.getId());
        pattern.setPatternNot(this.solvers.getRuleSolver().isChildNot());
        pattern.setPatternExists(this.solvers.getRuleSolver().isExists());
        pattern.setPatternForall(this.solvers.getRuleSolver().isForall());
        data.save(pattern);
        this.currentPattern = pattern;
        if (descr.getIdentifier() != null) {
            Variable variable = new Variable();
            variable.setRuleId(this.currentRule.getId());
            variable.setName(descr.getIdentifier());
            variable.setObjectType(AnalyticsComponentType.CLASS);
            variable.setObjectId(clazz.getId());
            variable.setObjectName(descr.getObjectType());
            data.save(variable);
        }
        if (descr.getSource() != null) {
            AnalyticsComponent source = this.flatten(descr.getSource());
            pattern.setSourceId(source.getId());
            pattern.setSourceType(source.getComponentType());
        } else {
            pattern.setSourceId(0);
            pattern.setSourceType(AnalyticsComponentType.NOTHING);
        }
        this.solvers.startPatternSolver(pattern);
        this.flatten(descr.getConstraint());
        this.solvers.endPatternSolver();
        return pattern.getId();
    }

    private void flatten(FieldConstraintDescr descr) {
        AnalyticsData data = AnalyticsDataFactory.getAnalyticsData();
        Field field = data.getFieldByClassAndFieldName(this.currentClass.getName(), descr.getFieldName());
        if (field == null) {
            field = this.createField(descr.getFieldName(), descr.getLine(), this.currentClass.getId(), this.currentClass.getName());
            data.save(field);
        }
        this.currentField = field;
        Constraint constraint = new Constraint();
        constraint.setRuleId(this.currentRule.getId());
        constraint.setFieldId(this.currentField.getId());
        constraint.setPatternId(this.currentPattern.getId());
        constraint.setPatternIsNot(this.currentPattern.isPatternNot());
        constraint.setFieldId(field.getId());
        data.save(constraint);
        this.currentConstraint = constraint;
        this.flatten(descr.getRestriction());
    }

    private void flatten(RestrictionConnectiveDescr descr) {
        this.flatten(descr.getRestrictions());
    }

    private void flatten(FieldBindingDescr descr) {
        AnalyticsData data = AnalyticsDataFactory.getAnalyticsData();
        Variable variable = new Variable();
        variable.setRuleId(this.currentRule.getId());
        variable.setName(descr.getIdentifier());
        variable.setObjectType(AnalyticsComponentType.FIELD);
        data.save(variable);
    }

    private void flatten(VariableRestrictionDescr descr) {
        AnalyticsData data = AnalyticsDataFactory.getAnalyticsData();
        Variable variable = data.getVariableByRuleAndVariableName(this.currentRule.getRuleName(), descr.getIdentifier());
        VariableRestriction restriction = new VariableRestriction();
        restriction.setRuleId(this.currentRule.getId());
        restriction.setRuleName(this.currentRule.getRuleName());
        restriction.setPatternId(this.currentPattern.getId());
        restriction.setPatternIsNot(this.currentPattern.isPatternNot());
        restriction.setConstraintId(this.currentConstraint.getId());
        restriction.setFieldId(this.currentConstraint.getFieldId());
        restriction.setEvaluator(descr.getEvaluator());
        restriction.setVariableId(variable.getId());
        restriction.setVariableName(descr.getIdentifier());
        this.currentField.setFieldType(Field.FieldType.VARIABLE);
        data.save(restriction);
        this.solvers.addRestriction(restriction);
    }

    private void flatten(ReturnValueRestrictionDescr descr) {
        AnalyticsData data = AnalyticsDataFactory.getAnalyticsData();
        ReturnValueRestriction restriction = new ReturnValueRestriction();
        restriction.setRuleId(this.currentRule.getId());
        restriction.setRuleName(this.currentRule.getRuleName());
        restriction.setPatternId(this.currentPattern.getId());
        restriction.setPatternIsNot(this.currentPattern.isPatternNot());
        restriction.setConstraintId(this.currentConstraint.getId());
        restriction.setFieldId(this.currentConstraint.getFieldId());
        restriction.setEvaluator(descr.getEvaluator());
        restriction.setClassMethodName(descr.getClassMethodName());
        restriction.setContent(descr.getContent());
        restriction.setDeclarations(descr.getDeclarations());
        data.save(restriction);
        this.solvers.addRestriction(restriction);
    }

    private void flatten(LiteralRestrictionDescr descr) {
        AnalyticsData data = AnalyticsDataFactory.getAnalyticsData();
        LiteralRestriction restriction = new LiteralRestriction();
        restriction.setRuleId(this.currentRule.getId());
        restriction.setRuleName(this.currentRule.getRuleName());
        restriction.setRuleId(this.currentRule.getId());
        restriction.setPatternId(this.currentPattern.getId());
        restriction.setPatternIsNot(this.currentPattern.isPatternNot());
        restriction.setConstraintId(this.currentConstraint.getId());
        restriction.setFieldId(this.currentConstraint.getFieldId());
        restriction.setEvaluator(descr.getEvaluator());
        restriction.setValue(descr.getText());
        this.currentField.setFieldType(restriction.getValueType());
        data.save(restriction);
        this.solvers.addRestriction(restriction);
    }

    private void flatten(QualifiedIdentifierRestrictionDescr descr) {
        AnalyticsData data = AnalyticsDataFactory.getAnalyticsData();
        String text = descr.getText();
        Variable variable = data.getVariableByRuleAndVariableName(this.currentRule.getRuleName(), text.substring(0, text.indexOf(".")));
        QualifiedIdentifierRestriction restriction = new QualifiedIdentifierRestriction();
        restriction.setRuleId(this.currentRule.getId());
        restriction.setPatternId(this.currentPattern.getId());
        restriction.setPatternIsNot(this.currentPattern.isPatternNot());
        restriction.setConstraintId(this.currentConstraint.getId());
        restriction.setFieldId(this.currentConstraint.getFieldId());
        restriction.setEvaluator(descr.getEvaluator());
        restriction.setVariableId(variable.getId());
        restriction.setVariableName(text.substring(0, text.indexOf(".")));
        restriction.setVariablePath(text.substring(text.indexOf(".")));
        this.currentField.setFieldType(Field.FieldType.VARIABLE);
        variable.setObjectType(AnalyticsComponentType.FIELD);
        data.save(restriction);
        this.solvers.addRestriction(restriction);
    }

    private Field createField(String fieldName, int line, int classId, String className) {
        Field field = new Field();
        field.setClassId(classId);
        field.setClassName(className);
        field.setName(fieldName);
        field.setLineNumber(line);
        this.currentClass.getFields().add(field);
        return field;
    }

    private void formPossibilities() {
        AnalyticsData data = AnalyticsDataFactory.getAnalyticsData();
        for (PatternPossibility patternPossibility : this.solvers.getPatternPossibilities()) {
            data.save(patternPossibility);
        }
        for (RulePossibility rulePossibility : this.solvers.getRulePossibilities()) {
            data.save(rulePossibility);
        }
    }
}

