/*
 * Decompiled with CFR 0.152.
 */
package org.drools.javaparser.ast.visitor;

import java.util.ArrayList;
import java.util.Optional;
import org.drools.javaparser.ast.ArrayCreationLevel;
import org.drools.javaparser.ast.CompilationUnit;
import org.drools.javaparser.ast.ImportDeclaration;
import org.drools.javaparser.ast.Node;
import org.drools.javaparser.ast.NodeList;
import org.drools.javaparser.ast.PackageDeclaration;
import org.drools.javaparser.ast.body.AnnotationDeclaration;
import org.drools.javaparser.ast.body.AnnotationMemberDeclaration;
import org.drools.javaparser.ast.body.BodyDeclaration;
import org.drools.javaparser.ast.body.ClassOrInterfaceDeclaration;
import org.drools.javaparser.ast.body.ConstructorDeclaration;
import org.drools.javaparser.ast.body.EnumConstantDeclaration;
import org.drools.javaparser.ast.body.EnumDeclaration;
import org.drools.javaparser.ast.body.FieldDeclaration;
import org.drools.javaparser.ast.body.InitializerDeclaration;
import org.drools.javaparser.ast.body.MethodDeclaration;
import org.drools.javaparser.ast.body.Parameter;
import org.drools.javaparser.ast.body.ReceiverParameter;
import org.drools.javaparser.ast.body.TypeDeclaration;
import org.drools.javaparser.ast.body.VariableDeclarator;
import org.drools.javaparser.ast.comments.BlockComment;
import org.drools.javaparser.ast.comments.Comment;
import org.drools.javaparser.ast.comments.JavadocComment;
import org.drools.javaparser.ast.comments.LineComment;
import org.drools.javaparser.ast.expr.AnnotationExpr;
import org.drools.javaparser.ast.expr.ArrayAccessExpr;
import org.drools.javaparser.ast.expr.ArrayCreationExpr;
import org.drools.javaparser.ast.expr.ArrayInitializerExpr;
import org.drools.javaparser.ast.expr.AssignExpr;
import org.drools.javaparser.ast.expr.BinaryExpr;
import org.drools.javaparser.ast.expr.BooleanLiteralExpr;
import org.drools.javaparser.ast.expr.CastExpr;
import org.drools.javaparser.ast.expr.CharLiteralExpr;
import org.drools.javaparser.ast.expr.ClassExpr;
import org.drools.javaparser.ast.expr.ConditionalExpr;
import org.drools.javaparser.ast.expr.DoubleLiteralExpr;
import org.drools.javaparser.ast.expr.EnclosedExpr;
import org.drools.javaparser.ast.expr.Expression;
import org.drools.javaparser.ast.expr.FieldAccessExpr;
import org.drools.javaparser.ast.expr.InstanceOfExpr;
import org.drools.javaparser.ast.expr.IntegerLiteralExpr;
import org.drools.javaparser.ast.expr.LambdaExpr;
import org.drools.javaparser.ast.expr.LongLiteralExpr;
import org.drools.javaparser.ast.expr.MarkerAnnotationExpr;
import org.drools.javaparser.ast.expr.MemberValuePair;
import org.drools.javaparser.ast.expr.MethodCallExpr;
import org.drools.javaparser.ast.expr.MethodReferenceExpr;
import org.drools.javaparser.ast.expr.Name;
import org.drools.javaparser.ast.expr.NameExpr;
import org.drools.javaparser.ast.expr.NormalAnnotationExpr;
import org.drools.javaparser.ast.expr.NullLiteralExpr;
import org.drools.javaparser.ast.expr.ObjectCreationExpr;
import org.drools.javaparser.ast.expr.SimpleName;
import org.drools.javaparser.ast.expr.SingleMemberAnnotationExpr;
import org.drools.javaparser.ast.expr.StringLiteralExpr;
import org.drools.javaparser.ast.expr.SuperExpr;
import org.drools.javaparser.ast.expr.ThisExpr;
import org.drools.javaparser.ast.expr.TypeExpr;
import org.drools.javaparser.ast.expr.UnaryExpr;
import org.drools.javaparser.ast.expr.VariableDeclarationExpr;
import org.drools.javaparser.ast.modules.ModuleDeclaration;
import org.drools.javaparser.ast.modules.ModuleExportsStmt;
import org.drools.javaparser.ast.modules.ModuleOpensStmt;
import org.drools.javaparser.ast.modules.ModuleProvidesStmt;
import org.drools.javaparser.ast.modules.ModuleRequiresStmt;
import org.drools.javaparser.ast.modules.ModuleStmt;
import org.drools.javaparser.ast.modules.ModuleUsesStmt;
import org.drools.javaparser.ast.stmt.AssertStmt;
import org.drools.javaparser.ast.stmt.BlockStmt;
import org.drools.javaparser.ast.stmt.BreakStmt;
import org.drools.javaparser.ast.stmt.CatchClause;
import org.drools.javaparser.ast.stmt.ContinueStmt;
import org.drools.javaparser.ast.stmt.DoStmt;
import org.drools.javaparser.ast.stmt.EmptyStmt;
import org.drools.javaparser.ast.stmt.ExplicitConstructorInvocationStmt;
import org.drools.javaparser.ast.stmt.ExpressionStmt;
import org.drools.javaparser.ast.stmt.ForStmt;
import org.drools.javaparser.ast.stmt.ForeachStmt;
import org.drools.javaparser.ast.stmt.IfStmt;
import org.drools.javaparser.ast.stmt.LabeledStmt;
import org.drools.javaparser.ast.stmt.LocalClassDeclarationStmt;
import org.drools.javaparser.ast.stmt.ReturnStmt;
import org.drools.javaparser.ast.stmt.Statement;
import org.drools.javaparser.ast.stmt.SwitchEntryStmt;
import org.drools.javaparser.ast.stmt.SwitchStmt;
import org.drools.javaparser.ast.stmt.SynchronizedStmt;
import org.drools.javaparser.ast.stmt.ThrowStmt;
import org.drools.javaparser.ast.stmt.TryStmt;
import org.drools.javaparser.ast.stmt.UnparsableStmt;
import org.drools.javaparser.ast.stmt.WhileStmt;
import org.drools.javaparser.ast.type.ArrayType;
import org.drools.javaparser.ast.type.ClassOrInterfaceType;
import org.drools.javaparser.ast.type.IntersectionType;
import org.drools.javaparser.ast.type.PrimitiveType;
import org.drools.javaparser.ast.type.ReferenceType;
import org.drools.javaparser.ast.type.Type;
import org.drools.javaparser.ast.type.TypeParameter;
import org.drools.javaparser.ast.type.UnionType;
import org.drools.javaparser.ast.type.UnknownType;
import org.drools.javaparser.ast.type.VoidType;
import org.drools.javaparser.ast.type.WildcardType;
import org.drools.javaparser.ast.visitor.GenericVisitor;
import org.drools.javaparser.ast.visitor.Visitable;
import org.drools.javaparser.utils.Pair;

public class ModifierVisitor<A>
implements GenericVisitor<Visitable, A> {
    @Override
    public Visitable visit(AnnotationDeclaration n, A arg) {
        NodeList<BodyDeclaration<?>> members = this.modifyList(n.getMembers(), arg);
        SimpleName name = (SimpleName)n.getName().accept(this, arg);
        NodeList<AnnotationExpr> annotations = this.modifyList(n.getAnnotations(), arg);
        Comment comment = n.getComment().map(s -> (Comment)s.accept(this, arg)).orElse(null);
        if (name == null) {
            return null;
        }
        n.setMembers((NodeList)members);
        n.setName(name);
        n.setAnnotations((NodeList)annotations);
        n.setComment(comment);
        return n;
    }

    @Override
    public Visitable visit(AnnotationMemberDeclaration n, A arg) {
        Expression defaultValue = n.getDefaultValue().map(s -> (Expression)s.accept(this, arg)).orElse(null);
        SimpleName name = (SimpleName)n.getName().accept(this, arg);
        Type type = (Type)n.getType().accept(this, arg);
        NodeList<AnnotationExpr> annotations = this.modifyList(n.getAnnotations(), arg);
        Comment comment = n.getComment().map(s -> (Comment)s.accept(this, arg)).orElse(null);
        if (name == null || type == null) {
            return null;
        }
        n.setDefaultValue(defaultValue);
        n.setName(name);
        n.setType(type);
        n.setAnnotations((NodeList)annotations);
        n.setComment(comment);
        return n;
    }

    @Override
    public Visitable visit(ArrayAccessExpr n, A arg) {
        Expression index = (Expression)n.getIndex().accept(this, arg);
        Expression name = (Expression)n.getName().accept(this, arg);
        Comment comment = n.getComment().map(s -> (Comment)s.accept(this, arg)).orElse(null);
        if (index == null || name == null) {
            return null;
        }
        n.setIndex(index);
        n.setName(name);
        n.setComment(comment);
        return n;
    }

    @Override
    public Visitable visit(ArrayCreationExpr n, A arg) {
        Type elementType = (Type)n.getElementType().accept(this, arg);
        ArrayInitializerExpr initializer = n.getInitializer().map(s -> (ArrayInitializerExpr)s.accept(this, arg)).orElse(null);
        NodeList<ArrayCreationLevel> levels = this.modifyList(n.getLevels(), arg);
        Comment comment = n.getComment().map(s -> (Comment)s.accept(this, arg)).orElse(null);
        if (elementType == null || levels.isEmpty()) {
            return null;
        }
        n.setElementType(elementType);
        n.setInitializer(initializer);
        n.setLevels(levels);
        n.setComment(comment);
        return n;
    }

    @Override
    public Visitable visit(ArrayInitializerExpr n, A arg) {
        NodeList<Expression> values = this.modifyList(n.getValues(), arg);
        Comment comment = n.getComment().map(s -> (Comment)s.accept(this, arg)).orElse(null);
        n.setValues(values);
        n.setComment(comment);
        return n;
    }

    @Override
    public Visitable visit(AssertStmt n, A arg) {
        Expression check = (Expression)n.getCheck().accept(this, arg);
        Expression message = n.getMessage().map(s -> (Expression)s.accept(this, arg)).orElse(null);
        Comment comment = n.getComment().map(s -> (Comment)s.accept(this, arg)).orElse(null);
        if (check == null) {
            return null;
        }
        n.setCheck(check);
        n.setMessage(message);
        n.setComment(comment);
        return n;
    }

    @Override
    public Visitable visit(AssignExpr n, A arg) {
        Expression target = (Expression)n.getTarget().accept(this, arg);
        Expression value = (Expression)n.getValue().accept(this, arg);
        Comment comment = n.getComment().map(s -> (Comment)s.accept(this, arg)).orElse(null);
        if (target == null || value == null) {
            return null;
        }
        n.setTarget(target);
        n.setValue(value);
        n.setComment(comment);
        return n;
    }

    @Override
    public Visitable visit(BinaryExpr n, A arg) {
        Expression left = (Expression)n.getLeft().accept(this, arg);
        Expression right = (Expression)n.getRight().accept(this, arg);
        Comment comment = n.getComment().map(s -> (Comment)s.accept(this, arg)).orElse(null);
        if (left == null) {
            return right;
        }
        if (right == null) {
            return left;
        }
        n.setLeft(left);
        n.setRight(right);
        n.setComment(comment);
        return n;
    }

    @Override
    public Visitable visit(BlockStmt n, A arg) {
        NodeList<Statement> statements = this.modifyList(n.getStatements(), arg);
        Comment comment = n.getComment().map(s -> (Comment)s.accept(this, arg)).orElse(null);
        n.setStatements((NodeList)statements);
        n.setComment(comment);
        return n;
    }

    @Override
    public Visitable visit(BooleanLiteralExpr n, A arg) {
        Comment comment = n.getComment().map(s -> (Comment)s.accept(this, arg)).orElse(null);
        n.setComment(comment);
        return n;
    }

    @Override
    public Visitable visit(BreakStmt n, A arg) {
        SimpleName label = n.getLabel().map(s -> (SimpleName)s.accept(this, arg)).orElse(null);
        Comment comment = n.getComment().map(s -> (Comment)s.accept(this, arg)).orElse(null);
        n.setLabel(label);
        n.setComment(comment);
        return n;
    }

    @Override
    public Visitable visit(CastExpr n, A arg) {
        Expression expression = (Expression)n.getExpression().accept(this, arg);
        Type type = (Type)n.getType().accept(this, arg);
        Comment comment = n.getComment().map(s -> (Comment)s.accept(this, arg)).orElse(null);
        if (expression == null || type == null) {
            return null;
        }
        n.setExpression(expression);
        n.setType(type);
        n.setComment(comment);
        return n;
    }

    @Override
    public Visitable visit(CatchClause n, A arg) {
        BlockStmt body = (BlockStmt)n.getBody().accept(this, arg);
        Parameter parameter = (Parameter)n.getParameter().accept(this, arg);
        Comment comment = n.getComment().map(s -> (Comment)s.accept(this, arg)).orElse(null);
        if (body == null || parameter == null) {
            return null;
        }
        n.setBody(body);
        n.setParameter(parameter);
        n.setComment(comment);
        return n;
    }

    @Override
    public Visitable visit(CharLiteralExpr n, A arg) {
        Comment comment = n.getComment().map(s -> (Comment)s.accept(this, arg)).orElse(null);
        n.setComment(comment);
        return n;
    }

    @Override
    public Visitable visit(ClassExpr n, A arg) {
        Type type = (Type)n.getType().accept(this, arg);
        Comment comment = n.getComment().map(s -> (Comment)s.accept(this, arg)).orElse(null);
        if (type == null) {
            return null;
        }
        n.setType(type);
        n.setComment(comment);
        return n;
    }

    @Override
    public Visitable visit(ClassOrInterfaceDeclaration n, A arg) {
        NodeList<ClassOrInterfaceType> extendedTypes = this.modifyList(n.getExtendedTypes(), arg);
        NodeList<ClassOrInterfaceType> implementedTypes = this.modifyList(n.getImplementedTypes(), arg);
        NodeList<TypeParameter> typeParameters = this.modifyList(n.getTypeParameters(), arg);
        NodeList<BodyDeclaration<?>> members = this.modifyList(n.getMembers(), arg);
        SimpleName name = (SimpleName)n.getName().accept(this, arg);
        NodeList<AnnotationExpr> annotations = this.modifyList(n.getAnnotations(), arg);
        Comment comment = n.getComment().map(s -> (Comment)s.accept(this, arg)).orElse(null);
        if (name == null) {
            return null;
        }
        n.setExtendedTypes((NodeList)extendedTypes);
        n.setImplementedTypes((NodeList)implementedTypes);
        n.setTypeParameters((NodeList)typeParameters);
        n.setMembers((NodeList)members);
        n.setName(name);
        n.setAnnotations((NodeList)annotations);
        n.setComment(comment);
        return n;
    }

    @Override
    public Visitable visit(ClassOrInterfaceType n, A arg) {
        SimpleName name = (SimpleName)n.getName().accept(this, arg);
        ClassOrInterfaceType scope = n.getScope().map(s -> (ClassOrInterfaceType)s.accept(this, arg)).orElse(null);
        NodeList typeArguments = this.modifyList(n.getTypeArguments(), arg);
        NodeList<AnnotationExpr> annotations = this.modifyList(n.getAnnotations(), arg);
        Comment comment = n.getComment().map(s -> (Comment)s.accept(this, arg)).orElse(null);
        if (name == null) {
            return null;
        }
        n.setName(name);
        n.setScope(scope);
        n.setTypeArguments(typeArguments);
        n.setAnnotations((NodeList)annotations);
        n.setComment(comment);
        return n;
    }

    @Override
    public Visitable visit(CompilationUnit n, A arg) {
        NodeList<ImportDeclaration> imports = this.modifyList(n.getImports(), arg);
        ModuleDeclaration module = n.getModule().map(s -> (ModuleDeclaration)s.accept(this, arg)).orElse(null);
        PackageDeclaration packageDeclaration = n.getPackageDeclaration().map(s -> (PackageDeclaration)s.accept(this, arg)).orElse(null);
        NodeList<TypeDeclaration<?>> types = this.modifyList(n.getTypes(), arg);
        Comment comment = n.getComment().map(s -> (Comment)s.accept(this, arg)).orElse(null);
        n.setImports(imports);
        n.setModule(module);
        n.setPackageDeclaration(packageDeclaration);
        n.setTypes(types);
        n.setComment(comment);
        return n;
    }

    @Override
    public Visitable visit(ConditionalExpr n, A arg) {
        Expression condition = (Expression)n.getCondition().accept(this, arg);
        Expression elseExpr = (Expression)n.getElseExpr().accept(this, arg);
        Expression thenExpr = (Expression)n.getThenExpr().accept(this, arg);
        Comment comment = n.getComment().map(s -> (Comment)s.accept(this, arg)).orElse(null);
        if (condition == null || elseExpr == null || thenExpr == null) {
            return null;
        }
        n.setCondition(condition);
        n.setElseExpr(elseExpr);
        n.setThenExpr(thenExpr);
        n.setComment(comment);
        return n;
    }

    @Override
    public Visitable visit(ConstructorDeclaration n, A arg) {
        BlockStmt body = (BlockStmt)n.getBody().accept(this, arg);
        SimpleName name = (SimpleName)n.getName().accept(this, arg);
        NodeList<Parameter> parameters = this.modifyList(n.getParameters(), arg);
        ReceiverParameter receiverParameter = n.getReceiverParameter().map(s -> (ReceiverParameter)s.accept(this, arg)).orElse(null);
        NodeList<ReferenceType> thrownExceptions = this.modifyList(n.getThrownExceptions(), arg);
        NodeList<TypeParameter> typeParameters = this.modifyList(n.getTypeParameters(), arg);
        NodeList<AnnotationExpr> annotations = this.modifyList(n.getAnnotations(), arg);
        Comment comment = n.getComment().map(s -> (Comment)s.accept(this, arg)).orElse(null);
        if (body == null || name == null) {
            return null;
        }
        n.setBody(body);
        n.setName(name);
        n.setParameters((NodeList)parameters);
        n.setReceiverParameter(receiverParameter);
        n.setThrownExceptions((NodeList)thrownExceptions);
        n.setTypeParameters((NodeList)typeParameters);
        n.setAnnotations((NodeList)annotations);
        n.setComment(comment);
        return n;
    }

    @Override
    public Visitable visit(ContinueStmt n, A arg) {
        SimpleName label = n.getLabel().map(s -> (SimpleName)s.accept(this, arg)).orElse(null);
        Comment comment = n.getComment().map(s -> (Comment)s.accept(this, arg)).orElse(null);
        n.setLabel(label);
        n.setComment(comment);
        return n;
    }

    @Override
    public Visitable visit(DoStmt n, A arg) {
        Statement body = (Statement)n.getBody().accept(this, arg);
        Expression condition = (Expression)n.getCondition().accept(this, arg);
        Comment comment = n.getComment().map(s -> (Comment)s.accept(this, arg)).orElse(null);
        if (body == null || condition == null) {
            return null;
        }
        n.setBody(body);
        n.setCondition(condition);
        n.setComment(comment);
        return n;
    }

    @Override
    public Visitable visit(DoubleLiteralExpr n, A arg) {
        Comment comment = n.getComment().map(s -> (Comment)s.accept(this, arg)).orElse(null);
        n.setComment(comment);
        return n;
    }

    @Override
    public Visitable visit(EmptyStmt n, A arg) {
        Comment comment = n.getComment().map(s -> (Comment)s.accept(this, arg)).orElse(null);
        n.setComment(comment);
        return n;
    }

    @Override
    public Visitable visit(EnclosedExpr n, A arg) {
        Expression inner = (Expression)n.getInner().accept(this, arg);
        Comment comment = n.getComment().map(s -> (Comment)s.accept(this, arg)).orElse(null);
        if (inner == null) {
            return null;
        }
        n.setInner(inner);
        n.setComment(comment);
        return n;
    }

    @Override
    public Visitable visit(EnumConstantDeclaration n, A arg) {
        NodeList<Expression> arguments = this.modifyList(n.getArguments(), arg);
        NodeList<BodyDeclaration<?>> classBody = this.modifyList(n.getClassBody(), arg);
        SimpleName name = (SimpleName)n.getName().accept(this, arg);
        NodeList<AnnotationExpr> annotations = this.modifyList(n.getAnnotations(), arg);
        Comment comment = n.getComment().map(s -> (Comment)s.accept(this, arg)).orElse(null);
        if (name == null) {
            return null;
        }
        n.setArguments((NodeList)arguments);
        n.setClassBody(classBody);
        n.setName(name);
        n.setAnnotations((NodeList)annotations);
        n.setComment(comment);
        return n;
    }

    @Override
    public Visitable visit(EnumDeclaration n, A arg) {
        NodeList<EnumConstantDeclaration> entries = this.modifyList(n.getEntries(), arg);
        NodeList<ClassOrInterfaceType> implementedTypes = this.modifyList(n.getImplementedTypes(), arg);
        NodeList<BodyDeclaration<?>> members = this.modifyList(n.getMembers(), arg);
        SimpleName name = (SimpleName)n.getName().accept(this, arg);
        NodeList<AnnotationExpr> annotations = this.modifyList(n.getAnnotations(), arg);
        Comment comment = n.getComment().map(s -> (Comment)s.accept(this, arg)).orElse(null);
        if (name == null) {
            return null;
        }
        n.setEntries(entries);
        n.setImplementedTypes((NodeList)implementedTypes);
        n.setMembers((NodeList)members);
        n.setName(name);
        n.setAnnotations((NodeList)annotations);
        n.setComment(comment);
        return n;
    }

    @Override
    public Visitable visit(ExplicitConstructorInvocationStmt n, A arg) {
        NodeList<Expression> arguments = this.modifyList(n.getArguments(), arg);
        Expression expression = n.getExpression().map(s -> (Expression)s.accept(this, arg)).orElse(null);
        NodeList typeArguments = this.modifyList(n.getTypeArguments(), arg);
        Comment comment = n.getComment().map(s -> (Comment)s.accept(this, arg)).orElse(null);
        n.setArguments(arguments);
        n.setExpression(expression);
        n.setTypeArguments(typeArguments);
        n.setComment(comment);
        return n;
    }

    @Override
    public Visitable visit(ExpressionStmt n, A arg) {
        Expression expression = (Expression)n.getExpression().accept(this, arg);
        Comment comment = n.getComment().map(s -> (Comment)s.accept(this, arg)).orElse(null);
        if (expression == null) {
            return null;
        }
        n.setExpression(expression);
        n.setComment(comment);
        return n;
    }

    @Override
    public Visitable visit(FieldAccessExpr n, A arg) {
        SimpleName name = (SimpleName)n.getName().accept(this, arg);
        Expression scope = (Expression)n.getScope().accept(this, arg);
        NodeList typeArguments = this.modifyList(n.getTypeArguments(), arg);
        Comment comment = n.getComment().map(s -> (Comment)s.accept(this, arg)).orElse(null);
        if (name == null || scope == null) {
            return null;
        }
        n.setName(name);
        n.setScope(scope);
        n.setTypeArguments(typeArguments);
        n.setComment(comment);
        return n;
    }

    @Override
    public Visitable visit(FieldDeclaration n, A arg) {
        NodeList<VariableDeclarator> variables = this.modifyList(n.getVariables(), arg);
        NodeList<AnnotationExpr> annotations = this.modifyList(n.getAnnotations(), arg);
        Comment comment = n.getComment().map(s -> (Comment)s.accept(this, arg)).orElse(null);
        if (variables.isEmpty()) {
            return null;
        }
        n.setVariables((NodeList)variables);
        n.setAnnotations((NodeList)annotations);
        n.setComment(comment);
        return n;
    }

    @Override
    public Visitable visit(ForeachStmt n, A arg) {
        Statement body = (Statement)n.getBody().accept(this, arg);
        Expression iterable = (Expression)n.getIterable().accept(this, arg);
        VariableDeclarationExpr variable = (VariableDeclarationExpr)n.getVariable().accept(this, arg);
        Comment comment = n.getComment().map(s -> (Comment)s.accept(this, arg)).orElse(null);
        if (body == null || iterable == null || variable == null) {
            return null;
        }
        n.setBody(body);
        n.setIterable(iterable);
        n.setVariable(variable);
        n.setComment(comment);
        return n;
    }

    @Override
    public Visitable visit(ForStmt n, A arg) {
        Statement body = (Statement)n.getBody().accept(this, arg);
        Expression compare = n.getCompare().map(s -> (Expression)s.accept(this, arg)).orElse(null);
        NodeList<Expression> initialization = this.modifyList(n.getInitialization(), arg);
        NodeList<Expression> update = this.modifyList(n.getUpdate(), arg);
        Comment comment = n.getComment().map(s -> (Comment)s.accept(this, arg)).orElse(null);
        if (body == null) {
            return null;
        }
        n.setBody(body);
        n.setCompare(compare);
        n.setInitialization(initialization);
        n.setUpdate(update);
        n.setComment(comment);
        return n;
    }

    @Override
    public Visitable visit(IfStmt n, A arg) {
        Expression condition = (Expression)n.getCondition().accept(this, arg);
        Statement elseStmt = n.getElseStmt().map(s -> (Statement)s.accept(this, arg)).orElse(null);
        Statement thenStmt = (Statement)n.getThenStmt().accept(this, arg);
        Comment comment = n.getComment().map(s -> (Comment)s.accept(this, arg)).orElse(null);
        if (condition == null || thenStmt == null) {
            return null;
        }
        n.setCondition(condition);
        n.setElseStmt(elseStmt);
        n.setThenStmt(thenStmt);
        n.setComment(comment);
        return n;
    }

    @Override
    public Visitable visit(InitializerDeclaration n, A arg) {
        BlockStmt body = (BlockStmt)n.getBody().accept(this, arg);
        NodeList<AnnotationExpr> annotations = this.modifyList(n.getAnnotations(), arg);
        Comment comment = n.getComment().map(s -> (Comment)s.accept(this, arg)).orElse(null);
        if (body == null) {
            return null;
        }
        n.setBody(body);
        n.setAnnotations((NodeList)annotations);
        n.setComment(comment);
        return n;
    }

    @Override
    public Visitable visit(InstanceOfExpr n, A arg) {
        Expression expression = (Expression)n.getExpression().accept(this, arg);
        ReferenceType type = (ReferenceType)n.getType().accept(this, arg);
        Comment comment = n.getComment().map(s -> (Comment)s.accept(this, arg)).orElse(null);
        if (expression == null || type == null) {
            return null;
        }
        n.setExpression(expression);
        n.setType(type);
        n.setComment(comment);
        return n;
    }

    @Override
    public Visitable visit(IntegerLiteralExpr n, A arg) {
        Comment comment = n.getComment().map(s -> (Comment)s.accept(this, arg)).orElse(null);
        n.setComment(comment);
        return n;
    }

    @Override
    public Visitable visit(JavadocComment n, A arg) {
        Comment comment = n.getComment().map(s -> (Comment)s.accept(this, arg)).orElse(null);
        n.setComment(comment);
        return n;
    }

    @Override
    public Visitable visit(LabeledStmt n, A arg) {
        SimpleName label = (SimpleName)n.getLabel().accept(this, arg);
        Statement statement = (Statement)n.getStatement().accept(this, arg);
        Comment comment = n.getComment().map(s -> (Comment)s.accept(this, arg)).orElse(null);
        if (label == null || statement == null) {
            return null;
        }
        n.setLabel(label);
        n.setStatement(statement);
        n.setComment(comment);
        return n;
    }

    @Override
    public Visitable visit(LongLiteralExpr n, A arg) {
        Comment comment = n.getComment().map(s -> (Comment)s.accept(this, arg)).orElse(null);
        n.setComment(comment);
        return n;
    }

    @Override
    public Visitable visit(MarkerAnnotationExpr n, A arg) {
        Name name = (Name)n.getName().accept(this, arg);
        Comment comment = n.getComment().map(s -> (Comment)s.accept(this, arg)).orElse(null);
        if (name == null) {
            return null;
        }
        n.setName(name);
        n.setComment(comment);
        return n;
    }

    @Override
    public Visitable visit(MemberValuePair n, A arg) {
        SimpleName name = (SimpleName)n.getName().accept(this, arg);
        Expression value = (Expression)n.getValue().accept(this, arg);
        Comment comment = n.getComment().map(s -> (Comment)s.accept(this, arg)).orElse(null);
        if (name == null || value == null) {
            return null;
        }
        n.setName(name);
        n.setValue(value);
        n.setComment(comment);
        return n;
    }

    @Override
    public Visitable visit(MethodCallExpr n, A arg) {
        NodeList<Expression> arguments = this.modifyList(n.getArguments(), arg);
        SimpleName name = (SimpleName)n.getName().accept(this, arg);
        Expression scope = n.getScope().map(s -> (Expression)s.accept(this, arg)).orElse(null);
        NodeList typeArguments = this.modifyList(n.getTypeArguments(), arg);
        Comment comment = n.getComment().map(s -> (Comment)s.accept(this, arg)).orElse(null);
        if (name == null) {
            return null;
        }
        n.setArguments((NodeList)arguments);
        n.setName(name);
        n.setScope(scope);
        n.setTypeArguments(typeArguments);
        n.setComment(comment);
        return n;
    }

    @Override
    public Visitable visit(MethodDeclaration n, A arg) {
        BlockStmt body = n.getBody().map(s -> (BlockStmt)s.accept(this, arg)).orElse(null);
        Type type = (Type)n.getType().accept(this, arg);
        SimpleName name = (SimpleName)n.getName().accept(this, arg);
        NodeList<Parameter> parameters = this.modifyList(n.getParameters(), arg);
        ReceiverParameter receiverParameter = n.getReceiverParameter().map(s -> (ReceiverParameter)s.accept(this, arg)).orElse(null);
        NodeList<ReferenceType> thrownExceptions = this.modifyList(n.getThrownExceptions(), arg);
        NodeList<TypeParameter> typeParameters = this.modifyList(n.getTypeParameters(), arg);
        NodeList<AnnotationExpr> annotations = this.modifyList(n.getAnnotations(), arg);
        Comment comment = n.getComment().map(s -> (Comment)s.accept(this, arg)).orElse(null);
        if (type == null || name == null) {
            return null;
        }
        n.setBody(body);
        n.setType(type);
        n.setName(name);
        n.setParameters((NodeList)parameters);
        n.setReceiverParameter(receiverParameter);
        n.setThrownExceptions((NodeList)thrownExceptions);
        n.setTypeParameters((NodeList)typeParameters);
        n.setAnnotations((NodeList)annotations);
        n.setComment(comment);
        return n;
    }

    @Override
    public Visitable visit(NameExpr n, A arg) {
        SimpleName name = (SimpleName)n.getName().accept(this, arg);
        Comment comment = n.getComment().map(s -> (Comment)s.accept(this, arg)).orElse(null);
        if (name == null) {
            return null;
        }
        n.setName(name);
        n.setComment(comment);
        return n;
    }

    @Override
    public Visitable visit(NormalAnnotationExpr n, A arg) {
        NodeList<MemberValuePair> pairs = this.modifyList(n.getPairs(), arg);
        Name name = (Name)n.getName().accept(this, arg);
        Comment comment = n.getComment().map(s -> (Comment)s.accept(this, arg)).orElse(null);
        if (name == null) {
            return null;
        }
        n.setPairs(pairs);
        n.setName(name);
        n.setComment(comment);
        return n;
    }

    @Override
    public Visitable visit(NullLiteralExpr n, A arg) {
        Comment comment = n.getComment().map(s -> (Comment)s.accept(this, arg)).orElse(null);
        n.setComment(comment);
        return n;
    }

    @Override
    public Visitable visit(ObjectCreationExpr n, A arg) {
        NodeList<BodyDeclaration<?>> anonymousClassBody = this.modifyList(n.getAnonymousClassBody(), arg);
        NodeList<Expression> arguments = this.modifyList(n.getArguments(), arg);
        Expression scope = n.getScope().map(s -> (Expression)s.accept(this, arg)).orElse(null);
        ClassOrInterfaceType type = (ClassOrInterfaceType)n.getType().accept(this, arg);
        NodeList typeArguments = this.modifyList(n.getTypeArguments(), arg);
        Comment comment = n.getComment().map(s -> (Comment)s.accept(this, arg)).orElse(null);
        if (type == null) {
            return null;
        }
        n.setAnonymousClassBody(anonymousClassBody);
        n.setArguments((NodeList)arguments);
        n.setScope(scope);
        n.setType(type);
        n.setTypeArguments(typeArguments);
        n.setComment(comment);
        return n;
    }

    @Override
    public Visitable visit(PackageDeclaration n, A arg) {
        NodeList<AnnotationExpr> annotations = this.modifyList(n.getAnnotations(), arg);
        Name name = (Name)n.getName().accept(this, arg);
        Comment comment = n.getComment().map(s -> (Comment)s.accept(this, arg)).orElse(null);
        if (name == null) {
            return null;
        }
        n.setAnnotations((NodeList)annotations);
        n.setName(name);
        n.setComment(comment);
        return n;
    }

    @Override
    public Visitable visit(Parameter n, A arg) {
        NodeList<AnnotationExpr> annotations = this.modifyList(n.getAnnotations(), arg);
        SimpleName name = (SimpleName)n.getName().accept(this, arg);
        Type type = (Type)n.getType().accept(this, arg);
        NodeList<AnnotationExpr> varArgsAnnotations = this.modifyList(n.getVarArgsAnnotations(), arg);
        Comment comment = n.getComment().map(s -> (Comment)s.accept(this, arg)).orElse(null);
        if (name == null || type == null) {
            return null;
        }
        n.setAnnotations((NodeList)annotations);
        n.setName(name);
        n.setType(type);
        n.setVarArgsAnnotations(varArgsAnnotations);
        n.setComment(comment);
        return n;
    }

    @Override
    public Visitable visit(Name n, A arg) {
        NodeList<AnnotationExpr> annotations = this.modifyList(n.getAnnotations(), arg);
        Name qualifier = n.getQualifier().map(s -> (Name)s.accept(this, arg)).orElse(null);
        Comment comment = n.getComment().map(s -> (Comment)s.accept(this, arg)).orElse(null);
        n.setAnnotations((NodeList)annotations);
        n.setQualifier(qualifier);
        n.setComment(comment);
        return n;
    }

    @Override
    public Visitable visit(PrimitiveType n, A arg) {
        NodeList<AnnotationExpr> annotations = this.modifyList(n.getAnnotations(), arg);
        Comment comment = n.getComment().map(s -> (Comment)s.accept(this, arg)).orElse(null);
        n.setAnnotations((NodeList)annotations);
        n.setComment(comment);
        return n;
    }

    @Override
    public Visitable visit(SimpleName n, A arg) {
        Comment comment = n.getComment().map(s -> (Comment)s.accept(this, arg)).orElse(null);
        n.setComment(comment);
        return n;
    }

    @Override
    public Visitable visit(ArrayType n, A arg) {
        Type componentType = (Type)n.getComponentType().accept(this, arg);
        NodeList<AnnotationExpr> annotations = this.modifyList(n.getAnnotations(), arg);
        Comment comment = n.getComment().map(s -> (Comment)s.accept(this, arg)).orElse(null);
        if (componentType == null) {
            return null;
        }
        n.setComponentType(componentType);
        n.setAnnotations((NodeList)annotations);
        n.setComment(comment);
        return n;
    }

    @Override
    public Visitable visit(ArrayCreationLevel n, A arg) {
        NodeList<AnnotationExpr> annotations = this.modifyList(n.getAnnotations(), arg);
        Expression dimension = n.getDimension().map(s -> (Expression)s.accept(this, arg)).orElse(null);
        Comment comment = n.getComment().map(s -> (Comment)s.accept(this, arg)).orElse(null);
        n.setAnnotations((NodeList)annotations);
        n.setDimension(dimension);
        n.setComment(comment);
        return n;
    }

    @Override
    public Visitable visit(IntersectionType n, A arg) {
        NodeList<ReferenceType> elements = this.modifyList(n.getElements(), arg);
        NodeList<AnnotationExpr> annotations = this.modifyList(n.getAnnotations(), arg);
        Comment comment = n.getComment().map(s -> (Comment)s.accept(this, arg)).orElse(null);
        if (elements.isEmpty()) {
            return null;
        }
        n.setElements(elements);
        n.setAnnotations((NodeList)annotations);
        n.setComment(comment);
        return n;
    }

    @Override
    public Visitable visit(UnionType n, A arg) {
        NodeList<ReferenceType> elements = this.modifyList(n.getElements(), arg);
        NodeList<AnnotationExpr> annotations = this.modifyList(n.getAnnotations(), arg);
        Comment comment = n.getComment().map(s -> (Comment)s.accept(this, arg)).orElse(null);
        if (elements.isEmpty()) {
            return null;
        }
        n.setElements(elements);
        n.setAnnotations((NodeList)annotations);
        n.setComment(comment);
        return n;
    }

    @Override
    public Visitable visit(ReturnStmt n, A arg) {
        Expression expression = n.getExpression().map(s -> (Expression)s.accept(this, arg)).orElse(null);
        Comment comment = n.getComment().map(s -> (Comment)s.accept(this, arg)).orElse(null);
        n.setExpression(expression);
        n.setComment(comment);
        return n;
    }

    @Override
    public Visitable visit(SingleMemberAnnotationExpr n, A arg) {
        Expression memberValue = (Expression)n.getMemberValue().accept(this, arg);
        Name name = (Name)n.getName().accept(this, arg);
        Comment comment = n.getComment().map(s -> (Comment)s.accept(this, arg)).orElse(null);
        if (memberValue == null || name == null) {
            return null;
        }
        n.setMemberValue(memberValue);
        n.setName(name);
        n.setComment(comment);
        return n;
    }

    @Override
    public Visitable visit(StringLiteralExpr n, A arg) {
        Comment comment = n.getComment().map(s -> (Comment)s.accept(this, arg)).orElse(null);
        n.setComment(comment);
        return n;
    }

    @Override
    public Visitable visit(SuperExpr n, A arg) {
        Expression classExpr = n.getClassExpr().map(s -> (Expression)s.accept(this, arg)).orElse(null);
        Comment comment = n.getComment().map(s -> (Comment)s.accept(this, arg)).orElse(null);
        n.setClassExpr(classExpr);
        n.setComment(comment);
        return n;
    }

    @Override
    public Visitable visit(SwitchEntryStmt n, A arg) {
        Expression label = n.getLabel().map(s -> (Expression)s.accept(this, arg)).orElse(null);
        NodeList<Statement> statements = this.modifyList(n.getStatements(), arg);
        Comment comment = n.getComment().map(s -> (Comment)s.accept(this, arg)).orElse(null);
        n.setLabel(label);
        n.setStatements((NodeList)statements);
        n.setComment(comment);
        return n;
    }

    @Override
    public Visitable visit(SwitchStmt n, A arg) {
        NodeList<SwitchEntryStmt> entries = this.modifyList(n.getEntries(), arg);
        Expression selector = (Expression)n.getSelector().accept(this, arg);
        Comment comment = n.getComment().map(s -> (Comment)s.accept(this, arg)).orElse(null);
        if (selector == null) {
            return null;
        }
        n.setEntries(entries);
        n.setSelector(selector);
        n.setComment(comment);
        return n;
    }

    @Override
    public Visitable visit(SynchronizedStmt n, A arg) {
        BlockStmt body = (BlockStmt)n.getBody().accept(this, arg);
        Expression expression = (Expression)n.getExpression().accept(this, arg);
        Comment comment = n.getComment().map(s -> (Comment)s.accept(this, arg)).orElse(null);
        if (body == null || expression == null) {
            return null;
        }
        n.setBody(body);
        n.setExpression(expression);
        n.setComment(comment);
        return n;
    }

    @Override
    public Visitable visit(ThisExpr n, A arg) {
        Expression classExpr = n.getClassExpr().map(s -> (Expression)s.accept(this, arg)).orElse(null);
        Comment comment = n.getComment().map(s -> (Comment)s.accept(this, arg)).orElse(null);
        n.setClassExpr(classExpr);
        n.setComment(comment);
        return n;
    }

    @Override
    public Visitable visit(ThrowStmt n, A arg) {
        Expression expression = (Expression)n.getExpression().accept(this, arg);
        Comment comment = n.getComment().map(s -> (Comment)s.accept(this, arg)).orElse(null);
        if (expression == null) {
            return null;
        }
        n.setExpression(expression);
        n.setComment(comment);
        return n;
    }

    @Override
    public Visitable visit(TryStmt n, A arg) {
        NodeList<CatchClause> catchClauses = this.modifyList(n.getCatchClauses(), arg);
        BlockStmt finallyBlock = n.getFinallyBlock().map(s -> (BlockStmt)s.accept(this, arg)).orElse(null);
        NodeList<Expression> resources = this.modifyList(n.getResources(), arg);
        BlockStmt tryBlock = (BlockStmt)n.getTryBlock().accept(this, arg);
        Comment comment = n.getComment().map(s -> (Comment)s.accept(this, arg)).orElse(null);
        if (tryBlock == null) {
            return null;
        }
        n.setCatchClauses(catchClauses);
        n.setFinallyBlock(finallyBlock);
        n.setResources(resources);
        n.setTryBlock(tryBlock);
        n.setComment(comment);
        return n;
    }

    @Override
    public Visitable visit(LocalClassDeclarationStmt n, A arg) {
        ClassOrInterfaceDeclaration classDeclaration = (ClassOrInterfaceDeclaration)n.getClassDeclaration().accept(this, arg);
        Comment comment = n.getComment().map(s -> (Comment)s.accept(this, arg)).orElse(null);
        if (classDeclaration == null) {
            return null;
        }
        n.setClassDeclaration(classDeclaration);
        n.setComment(comment);
        return n;
    }

    @Override
    public Visitable visit(TypeParameter n, A arg) {
        SimpleName name = (SimpleName)n.getName().accept(this, arg);
        NodeList<ClassOrInterfaceType> typeBound = this.modifyList(n.getTypeBound(), arg);
        NodeList<AnnotationExpr> annotations = this.modifyList(n.getAnnotations(), arg);
        Comment comment = n.getComment().map(s -> (Comment)s.accept(this, arg)).orElse(null);
        if (name == null) {
            return null;
        }
        n.setName(name);
        n.setTypeBound(typeBound);
        n.setAnnotations((NodeList)annotations);
        n.setComment(comment);
        return n;
    }

    @Override
    public Visitable visit(UnaryExpr n, A arg) {
        Expression expression = (Expression)n.getExpression().accept(this, arg);
        Comment comment = n.getComment().map(s -> (Comment)s.accept(this, arg)).orElse(null);
        if (expression == null) {
            return null;
        }
        n.setExpression(expression);
        n.setComment(comment);
        return n;
    }

    @Override
    public Visitable visit(UnknownType n, A arg) {
        NodeList<AnnotationExpr> annotations = this.modifyList(n.getAnnotations(), arg);
        Comment comment = n.getComment().map(s -> (Comment)s.accept(this, arg)).orElse(null);
        n.setAnnotations((NodeList)annotations);
        n.setComment(comment);
        return n;
    }

    @Override
    public Visitable visit(VariableDeclarationExpr n, A arg) {
        NodeList<AnnotationExpr> annotations = this.modifyList(n.getAnnotations(), arg);
        NodeList<VariableDeclarator> variables = this.modifyList(n.getVariables(), arg);
        Comment comment = n.getComment().map(s -> (Comment)s.accept(this, arg)).orElse(null);
        if (variables.isEmpty()) {
            return null;
        }
        n.setAnnotations((NodeList)annotations);
        n.setVariables((NodeList)variables);
        n.setComment(comment);
        return n;
    }

    @Override
    public Visitable visit(VariableDeclarator n, A arg) {
        Expression initializer = n.getInitializer().map(s -> (Expression)s.accept(this, arg)).orElse(null);
        SimpleName name = (SimpleName)n.getName().accept(this, arg);
        Type type = (Type)n.getType().accept(this, arg);
        Comment comment = n.getComment().map(s -> (Comment)s.accept(this, arg)).orElse(null);
        if (name == null || type == null) {
            return null;
        }
        n.setInitializer(initializer);
        n.setName(name);
        n.setType(type);
        n.setComment(comment);
        return n;
    }

    @Override
    public Visitable visit(VoidType n, A arg) {
        NodeList<AnnotationExpr> annotations = this.modifyList(n.getAnnotations(), arg);
        Comment comment = n.getComment().map(s -> (Comment)s.accept(this, arg)).orElse(null);
        n.setAnnotations((NodeList)annotations);
        n.setComment(comment);
        return n;
    }

    @Override
    public Visitable visit(WhileStmt n, A arg) {
        Statement body = (Statement)n.getBody().accept(this, arg);
        Expression condition = (Expression)n.getCondition().accept(this, arg);
        Comment comment = n.getComment().map(s -> (Comment)s.accept(this, arg)).orElse(null);
        if (body == null || condition == null) {
            return null;
        }
        n.setBody(body);
        n.setCondition(condition);
        n.setComment(comment);
        return n;
    }

    @Override
    public Visitable visit(WildcardType n, A arg) {
        ReferenceType extendedType = n.getExtendedType().map(s -> (ReferenceType)s.accept(this, arg)).orElse(null);
        ReferenceType superType = n.getSuperType().map(s -> (ReferenceType)s.accept(this, arg)).orElse(null);
        NodeList<AnnotationExpr> annotations = this.modifyList(n.getAnnotations(), arg);
        Comment comment = n.getComment().map(s -> (Comment)s.accept(this, arg)).orElse(null);
        n.setExtendedType(extendedType);
        n.setSuperType(superType);
        n.setAnnotations((NodeList)annotations);
        n.setComment(comment);
        return n;
    }

    @Override
    public Visitable visit(LambdaExpr n, A arg) {
        Statement body = (Statement)n.getBody().accept(this, arg);
        NodeList<Parameter> parameters = this.modifyList(n.getParameters(), arg);
        Comment comment = n.getComment().map(s -> (Comment)s.accept(this, arg)).orElse(null);
        if (body == null) {
            return null;
        }
        n.setBody(body);
        n.setParameters((NodeList)parameters);
        n.setComment(comment);
        return n;
    }

    @Override
    public Visitable visit(MethodReferenceExpr n, A arg) {
        Expression scope = (Expression)n.getScope().accept(this, arg);
        NodeList typeArguments = this.modifyList(n.getTypeArguments(), arg);
        Comment comment = n.getComment().map(s -> (Comment)s.accept(this, arg)).orElse(null);
        if (scope == null) {
            return null;
        }
        n.setScope(scope);
        n.setTypeArguments(typeArguments);
        n.setComment(comment);
        return n;
    }

    @Override
    public Visitable visit(TypeExpr n, A arg) {
        Type type = (Type)n.getType().accept(this, arg);
        Comment comment = n.getComment().map(s -> (Comment)s.accept(this, arg)).orElse(null);
        if (type == null) {
            return null;
        }
        n.setType(type);
        n.setComment(comment);
        return n;
    }

    @Override
    public Visitable visit(NodeList n, A arg) {
        if (n.isEmpty()) {
            return n;
        }
        ArrayList<Pair<Node, Node>> changeList = new ArrayList<Pair<Node, Node>>();
        ArrayList listCopy = new ArrayList(n);
        for (Node node : listCopy) {
            Node newNode = (Node)node.accept(this, arg);
            changeList.add(new Pair<Node, Node>(node, newNode));
        }
        for (Pair pair : changeList) {
            if (pair.b == null) {
                n.remove((Node)pair.a);
                continue;
            }
            int i = n.indexOf(pair.a);
            if (i == -1) continue;
            n.set(i, (Node)pair.b);
        }
        return n;
    }

    @Override
    public Node visit(ImportDeclaration n, A arg) {
        Name name = (Name)n.getName().accept(this, arg);
        Comment comment = n.getComment().map(s -> (Comment)s.accept(this, arg)).orElse(null);
        if (name == null) {
            return null;
        }
        n.setName(name);
        n.setComment(comment);
        return n;
    }

    @Override
    public Visitable visit(BlockComment n, A arg) {
        Comment comment = n.getComment().map(s -> (Comment)s.accept(this, arg)).orElse(null);
        n.setComment(comment);
        return n;
    }

    @Override
    public Visitable visit(LineComment n, A arg) {
        Comment comment = n.getComment().map(s -> (Comment)s.accept(this, arg)).orElse(null);
        n.setComment(comment);
        return n;
    }

    private <N extends Node> NodeList<N> modifyList(NodeList<N> list, A arg) {
        return (NodeList)list.accept(this, arg);
    }

    private <N extends Node> NodeList<N> modifyList(Optional<NodeList<N>> list, A arg) {
        return list.map(ns -> this.modifyList((NodeList)ns, arg)).orElse(null);
    }

    @Override
    public Visitable visit(ModuleDeclaration n, A arg) {
        NodeList<AnnotationExpr> annotations = this.modifyList(n.getAnnotations(), arg);
        NodeList<ModuleStmt> moduleStmts = this.modifyList(n.getModuleStmts(), arg);
        Name name = (Name)n.getName().accept(this, arg);
        Comment comment = n.getComment().map(s -> (Comment)s.accept(this, arg)).orElse(null);
        if (name == null) {
            return null;
        }
        n.setAnnotations((NodeList)annotations);
        n.setModuleStmts(moduleStmts);
        n.setName(name);
        n.setComment(comment);
        return n;
    }

    @Override
    public Visitable visit(ModuleRequiresStmt n, A arg) {
        Name name = (Name)n.getName().accept(this, arg);
        Comment comment = n.getComment().map(s -> (Comment)s.accept(this, arg)).orElse(null);
        if (name == null) {
            return null;
        }
        n.setName(name);
        n.setComment(comment);
        return n;
    }

    @Override
    public Visitable visit(ModuleExportsStmt n, A arg) {
        NodeList<Name> moduleNames = this.modifyList(n.getModuleNames(), arg);
        Name name = (Name)n.getName().accept(this, arg);
        Comment comment = n.getComment().map(s -> (Comment)s.accept(this, arg)).orElse(null);
        if (name == null) {
            return null;
        }
        n.setModuleNames(moduleNames);
        n.setName(name);
        n.setComment(comment);
        return n;
    }

    @Override
    public Visitable visit(ModuleProvidesStmt n, A arg) {
        Type type = (Type)n.getType().accept(this, arg);
        NodeList<Type> withTypes = this.modifyList(n.getWithTypes(), arg);
        Comment comment = n.getComment().map(s -> (Comment)s.accept(this, arg)).orElse(null);
        if (type == null) {
            return null;
        }
        n.setType(type);
        n.setWithTypes(withTypes);
        n.setComment(comment);
        return n;
    }

    @Override
    public Visitable visit(ModuleUsesStmt n, A arg) {
        Type type = (Type)n.getType().accept(this, arg);
        Comment comment = n.getComment().map(s -> (Comment)s.accept(this, arg)).orElse(null);
        if (type == null) {
            return null;
        }
        n.setType(type);
        n.setComment(comment);
        return n;
    }

    @Override
    public Visitable visit(ModuleOpensStmt n, A arg) {
        NodeList<Name> moduleNames = this.modifyList(n.getModuleNames(), arg);
        Name name = (Name)n.getName().accept(this, arg);
        Comment comment = n.getComment().map(s -> (Comment)s.accept(this, arg)).orElse(null);
        if (name == null) {
            return null;
        }
        n.setModuleNames(moduleNames);
        n.setName(name);
        n.setComment(comment);
        return n;
    }

    @Override
    public Visitable visit(UnparsableStmt n, A arg) {
        Comment comment = n.getComment().map(s -> (Comment)s.accept(this, arg)).orElse(null);
        n.setComment(comment);
        return n;
    }

    @Override
    public Visitable visit(ReceiverParameter n, A arg) {
        NodeList<AnnotationExpr> annotations = this.modifyList(n.getAnnotations(), arg);
        Name name = (Name)n.getName().accept(this, arg);
        Type type = (Type)n.getType().accept(this, arg);
        Comment comment = n.getComment().map(s -> (Comment)s.accept(this, arg)).orElse(null);
        if (name == null || type == null) {
            return null;
        }
        n.setAnnotations((NodeList)annotations);
        n.setName(name);
        n.setType(type);
        n.setComment(comment);
        return n;
    }
}

