package org.drools.javaparser.ast.nodeTypes.modifiers;

import org.drools.javaparser.ast.Node;
import org.drools.javaparser.ast.nodeTypes.NodeWithModifiers;

import static org.drools.javaparser.ast.Modifier.STATIC;

/**
 * A node that can be static.
 */
public interface NodeWithStaticModifier<N extends Node> extends NodeWithModifiers<N> {

    default boolean isStatic() {
        return getModifiers().contains(STATIC);
    }

    @SuppressWarnings("unchecked")
    default N setStatic(boolean set) {
        return setModifier(STATIC, set);
    }

}
