/*
 * Decompiled with CFR 0.152.
 */
package org.drools.javaparser.ast.stmt;

import java.util.Optional;
import java.util.function.Consumer;
import org.drools.javaparser.TokenRange;
import org.drools.javaparser.ast.AllFieldsConstructor;
import org.drools.javaparser.ast.Node;
import org.drools.javaparser.ast.expr.SimpleName;
import org.drools.javaparser.ast.observer.ObservableProperty;
import org.drools.javaparser.ast.stmt.Statement;
import org.drools.javaparser.ast.visitor.CloneVisitor;
import org.drools.javaparser.ast.visitor.GenericVisitor;
import org.drools.javaparser.ast.visitor.VoidVisitor;
import org.drools.javaparser.metamodel.BreakStmtMetaModel;
import org.drools.javaparser.metamodel.JavaParserMetaModel;
import org.drools.javaparser.metamodel.OptionalProperty;

public final class BreakStmt
extends Statement {
    @OptionalProperty
    private SimpleName label;

    public BreakStmt() {
        this(null, new SimpleName());
    }

    public BreakStmt(String label) {
        this(null, new SimpleName(label));
    }

    @AllFieldsConstructor
    public BreakStmt(SimpleName label) {
        this(null, label);
    }

    public BreakStmt(TokenRange tokenRange, SimpleName label) {
        super(tokenRange);
        this.setLabel(label);
        this.customInitialization();
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        v.visit(this, arg);
    }

    public Optional<SimpleName> getLabel() {
        return Optional.ofNullable(this.label);
    }

    public BreakStmt setLabel(SimpleName label) {
        if (label == this.label) {
            return this;
        }
        this.notifyPropertyChange(ObservableProperty.LABEL, this.label, label);
        if (this.label != null) {
            this.label.setParentNode(null);
        }
        this.label = label;
        this.setAsParentNodeOf(label);
        return this;
    }

    @Override
    public boolean remove(Node node) {
        if (node == null) {
            return false;
        }
        if (this.label != null && node == this.label) {
            this.removeLabel();
            return true;
        }
        return super.remove(node);
    }

    public BreakStmt removeLabel() {
        return this.setLabel(null);
    }

    @Override
    public BreakStmt clone() {
        return (BreakStmt)this.accept(new CloneVisitor(), null);
    }

    @Override
    public BreakStmtMetaModel getMetaModel() {
        return JavaParserMetaModel.breakStmtMetaModel;
    }

    @Override
    public boolean replace(Node node, Node replacementNode) {
        if (node == null) {
            return false;
        }
        if (this.label != null && node == this.label) {
            this.setLabel((SimpleName)replacementNode);
            return true;
        }
        return super.replace(node, replacementNode);
    }

    @Override
    public boolean isBreakStmt() {
        return true;
    }

    @Override
    public BreakStmt asBreakStmt() {
        return this;
    }

    @Override
    public void ifBreakStmt(Consumer<BreakStmt> action) {
        action.accept(this);
    }

    @Override
    public Optional<BreakStmt> toBreakStmt() {
        return Optional.of(this);
    }
}

