package org.drools.javaparser.ast.nodeTypes.modifiers;

import org.drools.javaparser.ast.Node;
import org.drools.javaparser.ast.nodeTypes.NodeWithModifiers;

import static org.drools.javaparser.ast.Modifier.FINAL;

/**
 * A node that can be final.
 */
public interface NodeWithFinalModifier<N extends Node> extends NodeWithModifiers<N> {
    default boolean isFinal() {
        return getModifiers().contains(FINAL);
    }

    @SuppressWarnings("unchecked")
    default N setFinal(boolean set) {
        return setModifier(FINAL, set);
    }
}
