package org.drools.javaparser.ast.nodeTypes;

import org.drools.javaparser.ast.Node;
import org.drools.javaparser.ast.expr.SimpleName;

import java.util.Optional;

import static org.drools.javaparser.utils.Utils.assertNonEmpty;

/**
 * A node that has an optional label.
 */
public interface NodeWithOptionalLabel<T extends Node> {
    Optional<SimpleName> getLabel();

    T setLabel(SimpleName label);
    
    T removeLabel();

    default T setLabel(String label) {
        assertNonEmpty(label);
        return setLabel(new SimpleName(label));
    }

    default Optional<String> getLabelAsString() {
        return getLabel().flatMap(l -> Optional.of(l.getIdentifier()));
    }
}
