/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.util;

import java.awt.Color;
import java.util.Objects;
import org.apache.pdfbox.pdmodel.graphics.color.PDColor;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceRGB;

public class ColorUtil {
    public static PDColor toPDColor(Color color) {
        Objects.requireNonNull(color, "the color can not be null");
        return new PDColor(new float[]{(float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f}, (PDColorSpace)PDDeviceRGB.INSTANCE);
    }

    public static String toPDColorString(Color color) {
        float[] components = ColorUtil.toPDColor(color).getComponents();
        return String.join((CharSequence)" ", Float.toString(components[0]), Float.toString(components[1]), Float.toString(components[2]), "rg");
    }

    public static Color toColor(PDColor color) {
        Objects.requireNonNull(color, "the color can not be null");
        return new Color(color.toRGB());
    }

    public static Color toColor(String hexString) {
        Objects.requireNonNull(hexString, "the hex string can not be null");
        return Color.decode(hexString);
    }

    public static String toHexString(Color color) {
        Objects.requireNonNull(color, "the color can not be null");
        return String.format("#%02x%02x%02x", color.getRed(), color.getGreen(), color.getBlue());
    }
}

