/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.support.fonts;

import java.awt.Font;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fontbox.FontBoxFont;
import org.apache.fontbox.cff.CFFCIDFont;
import org.apache.fontbox.cff.CFFFont;
import org.apache.fontbox.ttf.NamingTable;
import org.apache.fontbox.ttf.OS2WindowsMetricsTable;
import org.apache.fontbox.ttf.OTFParser;
import org.apache.fontbox.ttf.OpenTypeFont;
import org.apache.fontbox.ttf.TTFParser;
import org.apache.fontbox.ttf.TTFTable;
import org.apache.fontbox.ttf.TrueTypeCollection;
import org.apache.fontbox.ttf.TrueTypeFont;
import org.apache.fontbox.type1.Type1Font;
import org.apache.fontbox.util.autodetect.FontFileFinder;
import org.apache.pdfbox.io.RandomAccessRead;
import org.apache.pdfbox.io.RandomAccessReadBufferedFile;
import org.apache.pdfbox.pdmodel.font.CIDSystemInfo;
import org.apache.pdfbox.pdmodel.font.FontCache;
import org.apache.pdfbox.pdmodel.font.FontFormat;
import org.apache.pdfbox.pdmodel.font.PDPanoseClassification;
import org.dromara.pdf.pdfbox.core.enums.FontType;
import org.dromara.pdf.pdfbox.support.Constants;
import org.dromara.pdf.pdfbox.support.fonts.FontInfo;
import org.dromara.pdf.pdfbox.support.fonts.FontProvider;

public class FileSystemFontProvider
extends FontProvider {
    private static final Log LOG = LogFactory.getLog(FileSystemFontProvider.class);
    private final List<FSFontInfo> fontInfoList = new ArrayList<FSFontInfo>();
    private final FontCache cache;

    FileSystemFontProvider(FontCache cache) {
        boolean scanDiskFont;
        this.cache = cache;
        boolean bl = scanDiskFont = !Objects.equals("false", System.getProperty("org.dromara.pdfbox.scan.font"));
        if (scanDiskFont) {
            try {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)"Will search the local system for fonts");
                }
                FontFileFinder fontFileFinder = new FontFileFinder();
                List fonts = fontFileFinder.find();
                ArrayList<File> files = new ArrayList<File>(fonts.size());
                for (URI font : fonts) {
                    files.add(new File(font));
                }
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Found " + files.size() + " fonts on the local system"));
                }
                if (!files.isEmpty()) {
                    List<FSFontInfo> cachedInfos = this.loadDiskCache(files);
                    if (cachedInfos != null && !cachedInfos.isEmpty()) {
                        this.fontInfoList.addAll(cachedInfos);
                    } else {
                        LOG.warn((Object)"Building on-disk font cache, this may take a while");
                        this.scanFonts(files);
                        this.saveDiskCache();
                        LOG.warn((Object)("Finished building on-disk font cache, found " + this.fontInfoList.size() + " fonts"));
                    }
                }
            }
            catch (SecurityException e) {
                LOG.error((Object)"Error accessing the file system", (Throwable)e);
            }
        }
    }

    @Override
    public String addFont(File file) {
        try {
            String filePath = file.getPath().toLowerCase();
            if (filePath.endsWith(".ttf") || filePath.endsWith(".otf")) {
                this.addTrueTypeFont(file, null);
            } else if (filePath.endsWith(".ttc") || filePath.endsWith(".otc")) {
                this.addTrueTypeCollection(file, null);
            } else if (filePath.endsWith(".pfb")) {
                this.addType1Font(file, null);
            }
        }
        catch (IOException e) {
            LOG.warn((Object)("Error parsing font " + file.getPath()), (Throwable)e);
        }
        return this.fontInfoList.get(this.fontInfoList.size() - 1).getFontName();
    }

    @Override
    public String addFont(File file, String alias) {
        try {
            String filePath = file.getPath().toLowerCase();
            if (filePath.endsWith(".ttf") || filePath.endsWith(".otf")) {
                this.addTrueTypeFont(file, alias);
            } else if (filePath.endsWith(".ttc") || filePath.endsWith(".otc")) {
                this.addTrueTypeCollection(file, alias);
            } else if (filePath.endsWith(".pfb")) {
                this.addType1Font(file, alias);
            }
        }
        catch (IOException e) {
            LOG.warn((Object)("Error parsing font " + file.getPath()), (Throwable)e);
        }
        return this.fontInfoList.get(this.fontInfoList.size() - 1).getFontName();
    }

    @Override
    public String addFont(InputStream inputStream, String tempName, FontType type) {
        try {
            if (type == FontType.TTF || type == FontType.OTF) {
                this.addTrueTypeFont(inputStream, tempName, type);
            } else if (type == FontType.TTC || type == FontType.OTC) {
                this.addTrueTypeCollection(inputStream, tempName, type);
            } else if (type == FontType.PFB) {
                this.addType1Font(inputStream, tempName, type);
            }
        }
        catch (IOException e) {
            LOG.warn((Object)("Error parsing font " + (Object)((Object)type)), (Throwable)e);
        }
        return this.fontInfoList.get(this.fontInfoList.size() - 1).getFontName();
    }

    private void scanFonts(List<File> files) {
        files.forEach(this::addFont);
    }

    private File getDiskCacheFile() {
        String path = Constants.FONT_CACHE_PATH;
        if (!(path != null && new File(path).isDirectory() && new File(path).canWrite() || (path = Constants.USER_HOME_PATH) != null && new File(path).isDirectory() && new File(path).canWrite())) {
            path = Constants.TEMP_FILE_PATH;
        }
        return new File(path, ".pdfbox.cache");
    }

    private void saveDiskCache() {
        try {
            File file = this.getDiskCacheFile();
            try (BufferedWriter writer = new BufferedWriter(new FileWriter(file));){
                for (FSFontInfo fontInfo : this.fontInfoList) {
                    this.writeFontInfo(writer, fontInfo);
                }
            }
            catch (IOException e) {
                LOG.warn((Object)"Could not write to font cache", (Throwable)e);
                LOG.warn((Object)"Installed fonts information will have to be reloaded for each start");
                LOG.warn((Object)"You can assign a directory to the 'pdfbox.fontcache' property");
            }
        }
        catch (SecurityException e) {
            LOG.debug((Object)"Couldn't create writer for font cache file", (Throwable)e);
        }
    }

    private void writeFontInfo(BufferedWriter writer, FSFontInfo fontInfo) throws IOException {
        writer.write(fontInfo.postScriptName.trim());
        writer.write("|");
        writer.write(fontInfo.format.toString());
        writer.write("|");
        if (fontInfo.cidSystemInfo != null) {
            writer.write(fontInfo.cidSystemInfo.getRegistry() + '-' + fontInfo.cidSystemInfo.getOrdering() + '-' + fontInfo.cidSystemInfo.getSupplement());
        }
        writer.write("|");
        if (fontInfo.usWeightClass > -1) {
            writer.write(Integer.toHexString(fontInfo.usWeightClass));
        }
        writer.write("|");
        if (fontInfo.sFamilyClass > -1) {
            writer.write(Integer.toHexString(fontInfo.sFamilyClass));
        }
        writer.write("|");
        writer.write(Integer.toHexString(fontInfo.ulCodePageRange1));
        writer.write("|");
        writer.write(Integer.toHexString(fontInfo.ulCodePageRange2));
        writer.write("|");
        if (fontInfo.macStyle > -1) {
            writer.write(Integer.toHexString(fontInfo.macStyle));
        }
        writer.write("|");
        if (fontInfo.panose != null) {
            byte[] bytes = fontInfo.panose.getBytes();
            for (int i = 0; i < 10; ++i) {
                String str = Integer.toHexString(bytes[i]);
                if (str.length() == 1) {
                    writer.write(48);
                }
                writer.write(str);
            }
        }
        writer.write("|");
        writer.write(fontInfo.file.getAbsolutePath());
        writer.newLine();
    }

    private List<FSFontInfo> loadDiskCache(List<File> files) {
        File file2;
        HashSet<String> pending = new HashSet<String>(files.size());
        for (File file2 : files) {
            pending.add(file2.getAbsolutePath());
        }
        ArrayList<FSFontInfo> results = new ArrayList<FSFontInfo>();
        file2 = null;
        boolean fileExists = false;
        try {
            file2 = this.getDiskCacheFile();
            fileExists = file2.exists();
        }
        catch (SecurityException e) {
            LOG.debug((Object)"Error checking for file existence", (Throwable)e);
        }
        if (fileExists) {
            try (BufferedReader reader = new BufferedReader(new FileReader(file2));){
                String line;
                while ((line = reader.readLine()) != null) {
                    File fontFile;
                    String[] parts = line.split("\\|", 10);
                    if (parts.length < 10) {
                        LOG.warn((Object)("Incorrect line '" + line + "' in font disk cache is skipped"));
                        continue;
                    }
                    CIDSystemInfo cidSystemInfo = null;
                    int usWeightClass = -1;
                    int sFamilyClass = -1;
                    int macStyle = -1;
                    byte[] panose = null;
                    String postScriptName = parts[0];
                    FontFormat format = FontFormat.valueOf((String)parts[1]);
                    if (!parts[2].isEmpty()) {
                        String[] ros = parts[2].split("-");
                        cidSystemInfo = new CIDSystemInfo(ros[0], ros[1], Integer.parseInt(ros[2]));
                    }
                    if (!parts[3].isEmpty()) {
                        usWeightClass = (int)Long.parseLong(parts[3], 16);
                    }
                    if (!parts[4].isEmpty()) {
                        sFamilyClass = (int)Long.parseLong(parts[4], 16);
                    }
                    int ulCodePageRange1 = (int)Long.parseLong(parts[5], 16);
                    int ulCodePageRange2 = (int)Long.parseLong(parts[6], 16);
                    if (!parts[7].isEmpty()) {
                        macStyle = (int)Long.parseLong(parts[7], 16);
                    }
                    if (!parts[8].isEmpty()) {
                        panose = new byte[10];
                        for (int i = 0; i < 10; ++i) {
                            String str = parts[8].substring(i * 2, i * 2 + 2);
                            int b = Integer.parseInt(str, 16);
                            panose[i] = (byte)(b & 0xFF);
                        }
                    }
                    if ((fontFile = new File(parts[9])).exists()) {
                        String fontName;
                        try {
                            fontName = Font.createFont(0, fontFile).getFontName();
                        }
                        catch (Exception e) {
                            fontName = postScriptName;
                        }
                        FSFontInfo info = new FSFontInfo(fontFile, format, fontName, postScriptName, cidSystemInfo, usWeightClass, sFamilyClass, ulCodePageRange1, ulCodePageRange2, macStyle, panose, this);
                        results.add(info);
                    } else {
                        LOG.debug((Object)("Font file " + fontFile.getAbsolutePath() + " not found, skipped"));
                    }
                    pending.remove(fontFile.getAbsolutePath());
                }
            }
            catch (IOException e) {
                LOG.warn((Object)"Error loading font cache, will be re-built", (Throwable)e);
                return null;
            }
        }
        if (!pending.isEmpty()) {
            LOG.warn((Object)"New fonts found, font cache will be re-built");
            return null;
        }
        return results;
    }

    private void addTrueTypeCollection(File ttcFile, String alias) throws IOException {
        try (TrueTypeCollection ttc = new TrueTypeCollection(ttcFile);){
            ttc.processAllFonts(ttf -> this.addTrueTypeFontImpl(ttf, ttcFile, alias));
        }
        catch (IOException e) {
            LOG.warn((Object)("Could not load font file: " + ttcFile), (Throwable)e);
        }
    }

    private void addTrueTypeCollection(InputStream inputStream, String tempName, FontType type) throws IOException {
        try (TrueTypeCollection ttc = new TrueTypeCollection(inputStream);){
            File tempFile = new File(Constants.TEMP_FILE_PATH, tempName + type.getSuffix());
            FileUtils.writeByteArrayToFile((File)tempFile, (byte[])IOUtils.toByteArray((InputStream)inputStream));
            ttc.processAllFonts(ttf -> this.addTrueTypeFontImpl(ttf, tempFile, null));
        }
        catch (IOException e) {
            LOG.warn((Object)("Could not load font file: " + tempName + type.getSuffix()), (Throwable)e);
        }
    }

    private void addTrueTypeFont(File file, String alias) throws IOException {
        try {
            if (file.getPath().toLowerCase().endsWith(".otf")) {
                OTFParser parser = new OTFParser(true);
                OpenTypeFont otf = parser.parse((RandomAccessRead)new RandomAccessReadBufferedFile(file));
                this.addTrueTypeFontImpl((TrueTypeFont)otf, file, alias);
            } else {
                TTFParser parser = new TTFParser(true);
                TrueTypeFont ttf = parser.parse((RandomAccessRead)new RandomAccessReadBufferedFile(file));
                this.addTrueTypeFontImpl(ttf, file, alias);
            }
        }
        catch (IOException e) {
            LOG.warn((Object)("Could not load font file: " + file), (Throwable)e);
        }
    }

    private void addTrueTypeFont(InputStream inputStream, String tempName, FontType type) throws IOException {
        try {
            File tempFile = new File(Constants.TEMP_FILE_PATH, tempName + type.getSuffix());
            FileUtils.writeByteArrayToFile((File)tempFile, (byte[])IOUtils.toByteArray((InputStream)inputStream));
            this.addTrueTypeFont(tempFile, null);
        }
        catch (IOException e) {
            LOG.warn((Object)("Could not load font file: " + tempName + type.getSuffix()), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addTrueTypeFontImpl(TrueTypeFont ttf, File file, String alias) throws IOException {
        try {
            if (ttf.getName() != null && ttf.getName().contains("|")) {
                this.fontInfoList.add(new FSIgnored(file, FontFormat.TTF, this.getFontName(file, "*skippipeinname*"), "*skippipeinname*"));
                if (Objects.nonNull(alias)) {
                    this.fontInfoList.add(new FSIgnored(file, FontFormat.TTF, alias, "*skippipeinname*"));
                }
                LOG.warn((Object)("Skipping font with '|' in name " + ttf.getName() + " in file " + file));
            } else if (ttf.getName() != null) {
                NamingTable name;
                String format;
                if (ttf.getHeader() == null) {
                    this.fontInfoList.add(new FSIgnored(file, FontFormat.TTF, this.getFontName(file, ttf.getName()), ttf.getName()));
                    if (Objects.nonNull(alias)) {
                        this.fontInfoList.add(new FSIgnored(file, FontFormat.TTF, alias, ttf.getName()));
                    }
                    return;
                }
                int macStyle = ttf.getHeader().getMacStyle();
                int sFamilyClass = -1;
                int usWeightClass = -1;
                int ulCodePageRange1 = 0;
                int ulCodePageRange2 = 0;
                byte[] panose = null;
                OS2WindowsMetricsTable os2WindowsMetricsTable = ttf.getOS2Windows();
                if (os2WindowsMetricsTable != null) {
                    sFamilyClass = os2WindowsMetricsTable.getFamilyClass();
                    usWeightClass = os2WindowsMetricsTable.getWeightClass();
                    ulCodePageRange1 = (int)os2WindowsMetricsTable.getCodePageRange1();
                    ulCodePageRange2 = (int)os2WindowsMetricsTable.getCodePageRange2();
                    panose = os2WindowsMetricsTable.getPanose();
                }
                if (ttf instanceof OpenTypeFont && ((OpenTypeFont)ttf).isPostScript()) {
                    format = "OTF";
                    CFFFont cff = ((OpenTypeFont)ttf).getCFF().getFont();
                    CIDSystemInfo ros = null;
                    if (cff instanceof CFFCIDFont) {
                        CFFCIDFont cidFont = (CFFCIDFont)cff;
                        String registry = cidFont.getRegistry();
                        String ordering = cidFont.getOrdering();
                        int supplement = cidFont.getSupplement();
                        ros = new CIDSystemInfo(registry, ordering, supplement);
                    }
                    this.fontInfoList.add(new FSFontInfo(file, FontFormat.OTF, this.getFontName(file, ttf.getName()), ttf.getName(), ros, usWeightClass, sFamilyClass, ulCodePageRange1, ulCodePageRange2, macStyle, panose, this));
                    if (Objects.nonNull(alias)) {
                        this.fontInfoList.add(new FSFontInfo(file, FontFormat.OTF, alias, ttf.getName(), ros, usWeightClass, sFamilyClass, ulCodePageRange1, ulCodePageRange2, macStyle, panose, this));
                    }
                } else {
                    CIDSystemInfo ros = null;
                    if (ttf.getTableMap().containsKey("gcid")) {
                        byte[] bytes = ttf.getTableBytes((TTFTable)ttf.getTableMap().get("gcid"));
                        String reg = new String(bytes, 10, 64, StandardCharsets.US_ASCII);
                        String registryName = reg.substring(0, reg.indexOf(0));
                        String ord = new String(bytes, 76, 64, StandardCharsets.US_ASCII);
                        String orderName = ord.substring(0, ord.indexOf(0));
                        int supplementVersion = bytes[140] << 8 & (bytes[141] & 0xFF);
                        ros = new CIDSystemInfo(registryName, orderName, supplementVersion);
                    }
                    format = "TTF";
                    this.fontInfoList.add(new FSFontInfo(file, FontFormat.TTF, this.getFontName(file, ttf.getName()), ttf.getName(), ros, usWeightClass, sFamilyClass, ulCodePageRange1, ulCodePageRange2, macStyle, panose, this));
                    if (Objects.nonNull(alias)) {
                        this.fontInfoList.add(new FSFontInfo(file, FontFormat.TTF, alias, ttf.getName(), ros, usWeightClass, sFamilyClass, ulCodePageRange1, ulCodePageRange2, macStyle, panose, this));
                    }
                }
                if (LOG.isTraceEnabled() && (name = ttf.getNaming()) != null) {
                    LOG.trace((Object)(format + ": '" + name.getPostScriptName() + "' / '" + name.getFontFamily() + "' / '" + name.getFontSubFamily() + "'"));
                }
            } else {
                this.fontInfoList.add(new FSIgnored(file, FontFormat.TTF, this.getFontName(file, "*skipnoname*"), "*skipnoname*"));
                if (Objects.nonNull(alias)) {
                    this.fontInfoList.add(new FSIgnored(file, FontFormat.TTF, alias, "*skipnoname*"));
                }
                LOG.warn((Object)("Missing 'name' entry for PostScript name in font " + file));
            }
        }
        catch (IOException e) {
            this.fontInfoList.add(new FSIgnored(file, FontFormat.TTF, this.getFontName(file, "*skipexception*"), "*skipexception*"));
            if (Objects.nonNull(alias)) {
                this.fontInfoList.add(new FSIgnored(file, FontFormat.TTF, alias, "*skipexception*"));
            }
            LOG.warn((Object)("Could not load font file: " + file), (Throwable)e);
        }
        finally {
            ttf.close();
        }
    }

    private void addType1Font(File pfbFile, String alias) throws IOException {
        try (InputStream inputStream = Files.newInputStream(pfbFile.toPath(), new OpenOption[0]);){
            Type1Font type1 = Type1Font.createWithPFB((InputStream)inputStream);
            this.addType1Font(pfbFile, type1, alias);
        }
        catch (IOException e) {
            LOG.warn((Object)("Could not load font file: " + pfbFile), (Throwable)e);
        }
    }

    private void addType1Font(InputStream inputStream, String tempName, FontType type) throws IOException {
        try {
            Type1Font type1 = Type1Font.createWithPFB((InputStream)inputStream);
            File tempFile = new File(Constants.TEMP_FILE_PATH, tempName + type.getSuffix());
            FileUtils.writeByteArrayToFile((File)tempFile, (byte[])IOUtils.toByteArray((InputStream)inputStream));
            this.addType1Font(tempFile, type1, null);
        }
        catch (IOException e) {
            LOG.warn((Object)("Could not load font file: " + tempName + type.getSuffix()), (Throwable)e);
        }
    }

    private void addType1Font(File pfbFile, Type1Font type1, String alias) throws IOException {
        try {
            if (type1.getName() == null) {
                this.fontInfoList.add(new FSIgnored(pfbFile, FontFormat.PFB, this.getFontName(pfbFile, "*skipnoname*"), "*skipnoname*"));
                if (Objects.nonNull(alias)) {
                    this.fontInfoList.add(new FSIgnored(pfbFile, FontFormat.PFB, alias, "*skipnoname*"));
                }
                LOG.warn((Object)("Missing 'name' entry for PostScript name in font " + pfbFile));
                return;
            }
            if (type1.getName().contains("|")) {
                this.fontInfoList.add(new FSIgnored(pfbFile, FontFormat.PFB, this.getFontName(pfbFile, "*skippipeinname*"), "*skippipeinname*"));
                if (Objects.nonNull(alias)) {
                    this.fontInfoList.add(new FSIgnored(pfbFile, FontFormat.PFB, alias, "*skippipeinname*"));
                }
                LOG.warn((Object)("Skipping font with '|' in name " + type1.getName() + " in file " + pfbFile));
                return;
            }
            this.fontInfoList.add(new FSFontInfo(pfbFile, FontFormat.PFB, this.getFontName(pfbFile, type1.getName()), type1.getName(), null, -1, -1, 0, 0, -1, null, this));
            if (Objects.nonNull(alias)) {
                this.fontInfoList.add(new FSFontInfo(pfbFile, FontFormat.PFB, alias, type1.getName(), null, -1, -1, 0, 0, -1, null, this));
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("PFB: '" + type1.getName() + "' / '" + type1.getFamilyName() + "' / '" + type1.getWeight() + "'"));
            }
        }
        catch (Exception e) {
            LOG.warn((Object)"Could not load font file: pfb", (Throwable)e);
        }
    }

    @Override
    public String toDebugString() {
        StringBuilder sb = new StringBuilder();
        for (FSFontInfo info : this.fontInfoList) {
            sb.append(info.getFormat());
            sb.append(": ");
            sb.append(info.getPostScriptName());
            sb.append(": ");
            sb.append(info.file.getPath());
            sb.append('\n');
        }
        return sb.toString();
    }

    @Override
    public List<? extends FontInfo> getFontInfo() {
        return this.fontInfoList;
    }

    private String getFontName(File file, String postScriptName) {
        String fontName;
        try {
            fontName = Font.createFont(0, file).getFontName();
        }
        catch (Exception e) {
            fontName = postScriptName;
        }
        return fontName;
    }

    private static final class FSIgnored
    extends FSFontInfo {
        private FSIgnored(File file, FontFormat format, String fontName, String postScriptName) {
            super(file, format, fontName, postScriptName, null, 0, 0, 0, 0, 0, null, null);
        }
    }

    private static class FSFontInfo
    extends FontInfo {
        private final String fontName;
        private final String postScriptName;
        private final FontFormat format;
        private final CIDSystemInfo cidSystemInfo;
        private final int usWeightClass;
        private final int sFamilyClass;
        private final int ulCodePageRange1;
        private final int ulCodePageRange2;
        private final int macStyle;
        private final PDPanoseClassification panose;
        private final File file;
        private final FileSystemFontProvider parent;

        private FSFontInfo(File file, FontFormat format, String fontName, String postScriptName, CIDSystemInfo cidSystemInfo, int usWeightClass, int sFamilyClass, int ulCodePageRange1, int ulCodePageRange2, int macStyle, byte[] panose, FileSystemFontProvider parent) {
            this.file = file;
            this.format = format;
            this.fontName = fontName;
            this.postScriptName = postScriptName;
            this.cidSystemInfo = cidSystemInfo;
            this.usWeightClass = usWeightClass;
            this.sFamilyClass = sFamilyClass;
            this.ulCodePageRange1 = ulCodePageRange1;
            this.ulCodePageRange2 = ulCodePageRange2;
            this.macStyle = macStyle;
            this.panose = panose != null && panose.length >= 10 ? new PDPanoseClassification(panose) : null;
            this.parent = parent;
        }

        @Override
        public String getFontName() {
            return this.fontName;
        }

        public String getPostScriptName() {
            return this.postScriptName;
        }

        public FontFormat getFormat() {
            return this.format;
        }

        public CIDSystemInfo getCIDSystemInfo() {
            return this.cidSystemInfo;
        }

        public synchronized FontBoxFont getFont() {
            Type1Font font;
            FontBoxFont cached = this.parent.cache.getFont((org.apache.pdfbox.pdmodel.font.FontInfo)this);
            if (cached != null) {
                return cached;
            }
            switch (this.format) {
                case PFB: {
                    font = this.getType1Font(this.postScriptName, this.file);
                    break;
                }
                case TTF: {
                    font = this.getTrueTypeFont(this.postScriptName, this.file);
                    break;
                }
                case OTF: {
                    font = this.getOTFFont(this.postScriptName, this.file);
                    break;
                }
                default: {
                    throw new RuntimeException("can't happen");
                }
            }
            if (font != null) {
                this.parent.cache.addFont((org.apache.pdfbox.pdmodel.font.FontInfo)this, (FontBoxFont)font);
            }
            return font;
        }

        public int getFamilyClass() {
            return this.sFamilyClass;
        }

        public int getWeightClass() {
            return this.usWeightClass;
        }

        public int getCodePageRange1() {
            return this.ulCodePageRange1;
        }

        public int getCodePageRange2() {
            return this.ulCodePageRange2;
        }

        public int getMacStyle() {
            return this.macStyle;
        }

        public PDPanoseClassification getPanose() {
            return this.panose;
        }

        public String toString() {
            return super.toString() + " " + this.file;
        }

        private TrueTypeFont getTrueTypeFont(String postScriptName, File file) {
            try {
                TrueTypeFont ttf = this.readTrueTypeFont(postScriptName, file);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Loaded " + postScriptName + " from " + file));
                }
                return ttf;
            }
            catch (IOException e) {
                LOG.warn((Object)("Could not load font file: " + file), (Throwable)e);
                return null;
            }
        }

        private TrueTypeFont readTrueTypeFont(String postScriptName, File file) throws IOException {
            if (file.getName().toLowerCase().endsWith(".ttc")) {
                TrueTypeFont ttf;
                TrueTypeCollection ttc = new TrueTypeCollection(file);
                try {
                    ttf = ttc.getFontByName(postScriptName);
                }
                catch (IOException ex) {
                    ttc.close();
                    throw ex;
                }
                if (ttf == null) {
                    ttc.close();
                    throw new IOException("Font " + postScriptName + " not found in " + file);
                }
                return ttf;
            }
            TTFParser ttfParser = new TTFParser(true);
            return ttfParser.parse((RandomAccessRead)new RandomAccessReadBufferedFile(file));
        }

        private OpenTypeFont getOTFFont(String postScriptName, File file) {
            try {
                if (file.getName().toLowerCase().endsWith(".ttc")) {
                    TrueTypeFont ttf;
                    TrueTypeCollection ttc = new TrueTypeCollection(file);
                    try {
                        ttf = ttc.getFontByName(postScriptName);
                    }
                    catch (IOException ex) {
                        LOG.error((Object)ex.getMessage(), (Throwable)ex);
                        ttc.close();
                        return null;
                    }
                    if (ttf == null) {
                        ttc.close();
                        throw new IOException("Font " + postScriptName + " not found in " + file);
                    }
                    return (OpenTypeFont)ttf;
                }
                OTFParser parser = new OTFParser(true);
                OpenTypeFont otf = parser.parse((RandomAccessRead)new RandomAccessReadBufferedFile(file));
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Loaded " + postScriptName + " from " + file));
                }
                return otf;
            }
            catch (IOException e) {
                LOG.warn((Object)("Could not load font file: " + file), (Throwable)e);
                return null;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private Type1Font getType1Font(String postScriptName, File file) {
            try (InputStream input = Files.newInputStream(file.toPath(), new OpenOption[0]);){
                Type1Font type1 = Type1Font.createWithPFB((InputStream)input);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Loaded " + postScriptName + " from " + file));
                }
                Type1Font type1Font = type1;
                return type1Font;
            }
            catch (IOException e) {
                LOG.warn((Object)("Could not load font file: " + file), (Throwable)e);
                return null;
            }
        }
    }
}

