/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.core.ext.processor;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentCatalog;
import org.apache.pdfbox.pdmodel.fixup.AcroFormDefaultFixup;
import org.apache.pdfbox.pdmodel.fixup.PDDocumentFixup;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationWidget;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceCharacteristicsDictionary;
import org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm;
import org.apache.pdfbox.pdmodel.interactive.form.PDField;
import org.apache.pdfbox.pdmodel.interactive.form.PDPushButton;
import org.apache.pdfbox.pdmodel.interactive.form.PDTextField;
import org.dromara.pdf.pdfbox.core.base.Document;
import org.dromara.pdf.pdfbox.core.enums.ImageType;
import org.dromara.pdf.pdfbox.core.ext.processor.AbstractProcessor;
import org.dromara.pdf.pdfbox.handler.PdfHandler;
import org.dromara.pdf.pdfbox.util.ColorUtil;
import org.dromara.pdf.pdfbox.util.ImageUtil;

public class FormProcessor
extends AbstractProcessor {
    protected PDAcroForm form;
    protected PDFont font;
    protected Float fontSize;
    protected Color fontColor;

    public FormProcessor(Document document) {
        this(document, false, true);
    }

    public FormProcessor(Document document, boolean isFixForm, boolean isNeedAppearance) {
        super(document);
        this.form = this.initForm(document.getTarget(), isFixForm, isNeedAppearance);
    }

    public List<PDField> getFields() {
        return this.form.getFields();
    }

    public void setFont(String fontName, float fontSize, Color fontColor) {
        this.font = PdfHandler.getFontHandler().getPDFont(this.getDocument(), fontName, true);
        this.fontSize = Float.valueOf(fontSize);
        this.fontColor = fontColor;
        this.form.getDefaultResources().put(COSName.getPDFName((String)this.font.getName()), this.font);
    }

    public void replaceKey(Map<String, String> keyMap) {
        keyMap.forEach((key, value) -> {
            PDField field = this.form.getField(key);
            if (Objects.nonNull(field)) {
                field.setMappingName(value);
            }
        });
        this.reset();
    }

    public void remove(String ... keys) {
        if (Objects.nonNull(keys) && keys.length > 0) {
            List<PDField> fields = this.getFields();
            for (String key : keys) {
                PDField field = this.form.getField(key);
                if (!Objects.nonNull(field)) continue;
                fields.remove(field);
            }
            this.form.setFields(fields);
        } else {
            this.form.setFields(new ArrayList(0));
        }
        this.reset();
    }

    public void fillText(Map<String, String> formMap) {
        Objects.requireNonNull(formMap, "the form map can not be null");
        Set<Map.Entry<String, String>> entrySet = formMap.entrySet();
        for (Map.Entry<String, String> entry : entrySet) {
            PDField field = this.form.getField(entry.getKey());
            if (Objects.nonNull(field)) {
                if (field instanceof PDTextField) {
                    if (this.isAddAppearance()) {
                        ((PDTextField)field).setDefaultAppearance(this.createDefaultAppearance());
                    }
                    field.setValue(entry.getValue());
                    continue;
                }
                this.log.warn((Object)("the field['" + entry.getKey() + "'] is not text field, will be ignored"));
                continue;
            }
            this.log.warn((Object)("the field['" + entry.getKey() + "'] is not exist, will be ignored"));
        }
        this.reset();
        if (this.isAddAppearance()) {
            this.font.subset();
        }
    }

    public void fillImage(Map<String, BufferedImage> formMap) {
        Objects.requireNonNull(formMap, "the form map can not be null");
        Set<Map.Entry<String, BufferedImage>> entrySet = formMap.entrySet();
        for (Map.Entry<String, BufferedImage> entry : entrySet) {
            PDAppearanceCharacteristicsDictionary appearanceCharacteristics;
            List widgets;
            PDField field = this.form.getField(entry.getKey());
            if (!Objects.nonNull(field) || !(field instanceof PDPushButton) || (widgets = field.getWidgets()).isEmpty() || !Objects.nonNull(appearanceCharacteristics = ((PDAnnotationWidget)field.getWidgets().get(0)).getAppearanceCharacteristics())) continue;
            BufferedImage image = entry.getValue();
            if (Objects.nonNull(image)) {
                appearanceCharacteristics.getCOSObject().setItem(COSName.I, (COSBase)PDImageXObject.createFromByteArray((PDDocument)this.getDocument(), (byte[])ImageUtil.toBytes(image, ImageType.PNG.getType()), (String)ImageType.PNG.getType()).getCOSObject());
                continue;
            }
            appearanceCharacteristics.getCOSObject().setItem(COSName.I, null);
        }
        this.reset();
    }

    public void flatten(boolean refreshAppearances, String ... keys) {
        List<PDField> fields = this.getFields();
        if (Objects.nonNull(keys) && keys.length > 0) {
            fields = new ArrayList<PDField>(keys.length);
            for (String key : keys) {
                PDField field = this.form.getField(key);
                if (Objects.nonNull(field)) {
                    fields.add(field);
                    continue;
                }
                this.log.warn((Object)("the field['" + key + "'] is not exist, will be ignored"));
            }
        }
        this.form.flatten(fields, refreshAppearances);
        this.reset();
    }

    public void readOnly(String ... keys) {
        if (Objects.nonNull(keys) && keys.length > 0) {
            for (String key : keys) {
                PDField field2 = this.form.getField(key);
                if (Objects.nonNull(field2)) {
                    field2.setReadOnly(true);
                    continue;
                }
                this.log.warn((Object)("the field['" + key + "'] is not exist, will be ignored"));
            }
        } else {
            this.getFields().forEach(field -> field.setReadOnly(true));
        }
        this.reset();
    }

    protected PDAcroForm initForm(PDDocument document, boolean isFixForm, boolean isNeedAppearance) {
        PDDocumentCatalog documentCatalog = document.getDocumentCatalog();
        PDAcroForm acroForm = isFixForm ? documentCatalog.getAcroForm((PDDocumentFixup)new AcroFormDefaultFixup(document)) : documentCatalog.getAcroForm(null);
        if (Objects.isNull(acroForm)) {
            acroForm = new PDAcroForm(document);
        }
        acroForm.setNeedAppearances(Boolean.valueOf(isNeedAppearance));
        acroForm.setCacheFields(true);
        return acroForm;
    }

    protected boolean isAddAppearance() {
        return Objects.nonNull(this.font);
    }

    protected String createDefaultAppearance() {
        Float fontSize = this.fontSize;
        Color fontColor = this.fontColor;
        if (Objects.isNull(fontSize)) {
            fontSize = Float.valueOf(12.0f);
        }
        if (Objects.isNull(fontColor)) {
            fontColor = Color.BLACK;
        }
        return String.format("/%s %d Tf %s", this.font.getName(), fontSize.intValue(), ColorUtil.toPDColorString(fontColor));
    }

    protected void reset() {
        this.getDocument().getDocumentCatalog().setAcroForm(this.form);
    }

    public PDAcroForm getForm() {
        return this.form;
    }

    public PDFont getFont() {
        return this.font;
    }

    public Float getFontSize() {
        return this.fontSize;
    }

    public Color getFontColor() {
        return this.fontColor;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FormProcessor)) {
            return false;
        }
        FormProcessor other = (FormProcessor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Float this$fontSize = this.getFontSize();
        Float other$fontSize = other.getFontSize();
        if (this$fontSize == null ? other$fontSize != null : !((Object)this$fontSize).equals(other$fontSize)) {
            return false;
        }
        PDAcroForm this$form = this.getForm();
        PDAcroForm other$form = other.getForm();
        if (this$form == null ? other$form != null : !this$form.equals(other$form)) {
            return false;
        }
        PDFont this$font = this.getFont();
        PDFont other$font = other.getFont();
        if (this$font == null ? other$font != null : !((Object)this$font).equals(other$font)) {
            return false;
        }
        Color this$fontColor = this.getFontColor();
        Color other$fontColor = other.getFontColor();
        return !(this$fontColor == null ? other$fontColor != null : !((Object)this$fontColor).equals(other$fontColor));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FormProcessor;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Float $fontSize = this.getFontSize();
        result = result * 59 + ($fontSize == null ? 43 : ((Object)$fontSize).hashCode());
        PDAcroForm $form = this.getForm();
        result = result * 59 + ($form == null ? 43 : $form.hashCode());
        PDFont $font = this.getFont();
        result = result * 59 + ($font == null ? 43 : ((Object)$font).hashCode());
        Color $fontColor = this.getFontColor();
        result = result * 59 + ($fontColor == null ? 43 : ((Object)$fontColor).hashCode());
        return result;
    }
}

