/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.core.ext.extractor;

import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageTree;
import org.dromara.pdf.pdfbox.core.base.Document;
import org.dromara.pdf.pdfbox.core.ext.extractor.AbstractExtractor;
import org.dromara.pdf.pdfbox.util.CommonUtil;

public abstract class AbstractImageExtractor
extends AbstractExtractor {
    public AbstractImageExtractor(Document document) {
        super(document);
    }

    public abstract Map<Integer, List<BufferedImage>> extract(int ... var1);

    protected Map<Integer, List<BufferedImage>> processImage(int ... pageIndexes) {
        HashMap<Integer, List<BufferedImage>> data = new HashMap<Integer, List<BufferedImage>>(32);
        PDPageTree pageTree = this.getDocument().getPages();
        if (Objects.nonNull(pageIndexes) && pageIndexes.length > 0) {
            Arrays.stream(pageIndexes).sorted().forEach(index -> data.put(index, this.processImage(pageTree.get(index))));
        } else {
            int index2 = 0;
            for (PDPage page : pageTree) {
                data.put(index2, this.processImage(page));
                ++index2;
            }
        }
        return data;
    }

    protected List<BufferedImage> processImage(PDPage page) {
        return CommonUtil.extractImage(page);
    }
}

