/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.core.component;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.dromara.pdf.pdfbox.core.base.BorderData;
import org.dromara.pdf.pdfbox.core.base.Page;
import org.dromara.pdf.pdfbox.core.base.config.BorderConfiguration;
import org.dromara.pdf.pdfbox.core.component.Table;
import org.dromara.pdf.pdfbox.core.component.TableRow;
import org.dromara.pdf.pdfbox.core.enums.HorizontalAlignment;
import org.dromara.pdf.pdfbox.core.enums.VerticalAlignment;

public abstract class AbstractTableHeaderOrFooter
extends BorderData {
    protected Color backgroundColor;
    protected Table table;
    protected List<TableRow> rows;
    protected Boolean isBreak;
    protected Boolean isTogether;
    protected Boolean isPagingBorder;
    protected Float contentMarginTop;
    protected Float contentMarginBottom;
    protected Float contentMarginLeft;
    protected Float contentMarginRight;
    protected HorizontalAlignment contentHorizontalAlignment;
    protected VerticalAlignment contentVerticalAlignment;

    public AbstractTableHeaderOrFooter(Table table) {
        this.table = table;
        this.borderConfiguration = new BorderConfiguration(false);
    }

    protected AbstractTableHeaderOrFooter() {
    }

    public void setContentMargin(float margin) {
        this.contentMarginTop = Float.valueOf(margin);
        this.contentMarginBottom = Float.valueOf(margin);
        this.contentMarginLeft = Float.valueOf(margin);
        this.contentMarginRight = Float.valueOf(margin);
    }

    public void setRows(List<TableRow> rows) {
        this.rows = rows;
    }

    public void setRows(TableRow ... rows) {
        if (Objects.nonNull(rows)) {
            this.rows = new ArrayList<TableRow>(rows.length);
            Collections.addAll(this.rows, rows);
        } else {
            this.rows = null;
        }
    }

    public void addRows(List<TableRow> rows) {
        if (Objects.nonNull(rows)) {
            if (Objects.isNull(this.rows)) {
                this.rows = new ArrayList<TableRow>(rows);
            } else {
                this.rows.addAll(rows);
            }
        }
    }

    public void addRows(TableRow ... rows) {
        if (Objects.nonNull(rows)) {
            if (Objects.isNull(this.rows)) {
                this.rows = new ArrayList<TableRow>(rows.length);
            }
            Collections.addAll(this.rows, rows);
        }
    }

    public Float getHeight() {
        if (Objects.isNull(this.rows)) {
            return Float.valueOf(0.0f);
        }
        return Float.valueOf((float)this.rows.stream().mapToDouble(TableRow::getHeight).sum());
    }

    protected float render(Page page, float beginX, float beginY) {
        this.init();
        if (Objects.nonNull(this.getRows())) {
            for (TableRow row : this.getRows()) {
                if (this.getContext().getIsVirtualRender().booleanValue()) {
                    row.virtualRender(page, Float.valueOf(beginX), Float.valueOf(beginY));
                } else {
                    row.render(page, Float.valueOf(beginX), Float.valueOf(beginY));
                }
                beginY -= row.getHeight().floatValue();
            }
        }
        return beginY;
    }

    protected void init() {
        if (Objects.isNull(this.backgroundColor)) {
            this.backgroundColor = this.table.getBackgroundColor();
        }
        if (Objects.isNull(this.isBreak)) {
            this.isBreak = Boolean.FALSE;
        }
        if (Objects.isNull(this.isTogether)) {
            this.isTogether = this.table.getIsTogether();
        }
        if (Objects.isNull(this.isPagingBorder)) {
            this.isPagingBorder = this.table.getIsPagingBorder();
        }
        if (Objects.isNull(this.contentMarginTop)) {
            this.contentMarginTop = this.table.getContentMarginTop();
        }
        if (Objects.isNull(this.contentMarginBottom)) {
            this.contentMarginBottom = this.table.getContentMarginBottom();
        }
        if (Objects.isNull(this.contentMarginLeft)) {
            this.contentMarginLeft = this.table.getContentMarginLeft();
        }
        if (Objects.isNull(this.contentMarginRight)) {
            this.contentMarginRight = this.table.getContentMarginRight();
        }
        if (Objects.isNull((Object)this.contentHorizontalAlignment)) {
            this.contentHorizontalAlignment = this.table.getContentHorizontalAlignment();
        }
        if (Objects.isNull((Object)this.contentVerticalAlignment)) {
            this.contentVerticalAlignment = this.table.getContentVerticalAlignment();
        }
        this.initBorder();
        this.initRows();
    }

    protected void initBorder() {
        super.init(this.table, this.table.getBorderConfiguration());
    }

    protected void initRows() {
        if (Objects.nonNull(this.rows)) {
            int last = this.rows.size() - 1;
            for (int i = 0; i < this.rows.size(); ++i) {
                TableRow tableRow = this.rows.get(i);
                tableRow.setIndex(i);
                if (i > 0) {
                    tableRow.setPrevious(this.rows.get(i - 1));
                }
                if (i >= last) continue;
                tableRow.setNext(this.rows.get(i + 1));
            }
        }
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public Table getTable() {
        return this.table;
    }

    public List<TableRow> getRows() {
        return this.rows;
    }

    public Boolean getIsBreak() {
        return this.isBreak;
    }

    public Boolean getIsTogether() {
        return this.isTogether;
    }

    public Boolean getIsPagingBorder() {
        return this.isPagingBorder;
    }

    public Float getContentMarginTop() {
        return this.contentMarginTop;
    }

    public Float getContentMarginBottom() {
        return this.contentMarginBottom;
    }

    public Float getContentMarginLeft() {
        return this.contentMarginLeft;
    }

    public Float getContentMarginRight() {
        return this.contentMarginRight;
    }

    public HorizontalAlignment getContentHorizontalAlignment() {
        return this.contentHorizontalAlignment;
    }

    public VerticalAlignment getContentVerticalAlignment() {
        return this.contentVerticalAlignment;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public void setIsBreak(Boolean isBreak) {
        this.isBreak = isBreak;
    }

    public void setIsTogether(Boolean isTogether) {
        this.isTogether = isTogether;
    }

    public void setIsPagingBorder(Boolean isPagingBorder) {
        this.isPagingBorder = isPagingBorder;
    }

    public void setContentMarginTop(Float contentMarginTop) {
        this.contentMarginTop = contentMarginTop;
    }

    public void setContentMarginBottom(Float contentMarginBottom) {
        this.contentMarginBottom = contentMarginBottom;
    }

    public void setContentMarginLeft(Float contentMarginLeft) {
        this.contentMarginLeft = contentMarginLeft;
    }

    public void setContentMarginRight(Float contentMarginRight) {
        this.contentMarginRight = contentMarginRight;
    }

    public void setContentHorizontalAlignment(HorizontalAlignment contentHorizontalAlignment) {
        this.contentHorizontalAlignment = contentHorizontalAlignment;
    }

    public void setContentVerticalAlignment(VerticalAlignment contentVerticalAlignment) {
        this.contentVerticalAlignment = contentVerticalAlignment;
    }

    @Override
    public String toString() {
        return "AbstractTableHeaderOrFooter(backgroundColor=" + this.getBackgroundColor() + ", table=" + this.getTable() + ", rows=" + this.getRows() + ", isBreak=" + this.getIsBreak() + ", isTogether=" + this.getIsTogether() + ", isPagingBorder=" + this.getIsPagingBorder() + ", contentMarginTop=" + this.getContentMarginTop() + ", contentMarginBottom=" + this.getContentMarginBottom() + ", contentMarginLeft=" + this.getContentMarginLeft() + ", contentMarginRight=" + this.getContentMarginRight() + ", contentHorizontalAlignment=" + (Object)((Object)this.getContentHorizontalAlignment()) + ", contentVerticalAlignment=" + (Object)((Object)this.getContentVerticalAlignment()) + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractTableHeaderOrFooter)) {
            return false;
        }
        AbstractTableHeaderOrFooter other = (AbstractTableHeaderOrFooter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$isBreak = this.getIsBreak();
        Boolean other$isBreak = other.getIsBreak();
        if (this$isBreak == null ? other$isBreak != null : !((Object)this$isBreak).equals(other$isBreak)) {
            return false;
        }
        Boolean this$isTogether = this.getIsTogether();
        Boolean other$isTogether = other.getIsTogether();
        if (this$isTogether == null ? other$isTogether != null : !((Object)this$isTogether).equals(other$isTogether)) {
            return false;
        }
        Boolean this$isPagingBorder = this.getIsPagingBorder();
        Boolean other$isPagingBorder = other.getIsPagingBorder();
        if (this$isPagingBorder == null ? other$isPagingBorder != null : !((Object)this$isPagingBorder).equals(other$isPagingBorder)) {
            return false;
        }
        Float this$contentMarginTop = this.getContentMarginTop();
        Float other$contentMarginTop = other.getContentMarginTop();
        if (this$contentMarginTop == null ? other$contentMarginTop != null : !((Object)this$contentMarginTop).equals(other$contentMarginTop)) {
            return false;
        }
        Float this$contentMarginBottom = this.getContentMarginBottom();
        Float other$contentMarginBottom = other.getContentMarginBottom();
        if (this$contentMarginBottom == null ? other$contentMarginBottom != null : !((Object)this$contentMarginBottom).equals(other$contentMarginBottom)) {
            return false;
        }
        Float this$contentMarginLeft = this.getContentMarginLeft();
        Float other$contentMarginLeft = other.getContentMarginLeft();
        if (this$contentMarginLeft == null ? other$contentMarginLeft != null : !((Object)this$contentMarginLeft).equals(other$contentMarginLeft)) {
            return false;
        }
        Float this$contentMarginRight = this.getContentMarginRight();
        Float other$contentMarginRight = other.getContentMarginRight();
        if (this$contentMarginRight == null ? other$contentMarginRight != null : !((Object)this$contentMarginRight).equals(other$contentMarginRight)) {
            return false;
        }
        Color this$backgroundColor = this.getBackgroundColor();
        Color other$backgroundColor = other.getBackgroundColor();
        if (this$backgroundColor == null ? other$backgroundColor != null : !((Object)this$backgroundColor).equals(other$backgroundColor)) {
            return false;
        }
        Table this$table = this.getTable();
        Table other$table = other.getTable();
        if (this$table == null ? other$table != null : !((Object)this$table).equals(other$table)) {
            return false;
        }
        List<TableRow> this$rows = this.getRows();
        List<TableRow> other$rows = other.getRows();
        if (this$rows == null ? other$rows != null : !((Object)this$rows).equals(other$rows)) {
            return false;
        }
        HorizontalAlignment this$contentHorizontalAlignment = this.getContentHorizontalAlignment();
        HorizontalAlignment other$contentHorizontalAlignment = other.getContentHorizontalAlignment();
        if (this$contentHorizontalAlignment == null ? other$contentHorizontalAlignment != null : !((Object)((Object)this$contentHorizontalAlignment)).equals((Object)other$contentHorizontalAlignment)) {
            return false;
        }
        VerticalAlignment this$contentVerticalAlignment = this.getContentVerticalAlignment();
        VerticalAlignment other$contentVerticalAlignment = other.getContentVerticalAlignment();
        return !(this$contentVerticalAlignment == null ? other$contentVerticalAlignment != null : !((Object)((Object)this$contentVerticalAlignment)).equals((Object)other$contentVerticalAlignment));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof AbstractTableHeaderOrFooter;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $isBreak = this.getIsBreak();
        result = result * 59 + ($isBreak == null ? 43 : ((Object)$isBreak).hashCode());
        Boolean $isTogether = this.getIsTogether();
        result = result * 59 + ($isTogether == null ? 43 : ((Object)$isTogether).hashCode());
        Boolean $isPagingBorder = this.getIsPagingBorder();
        result = result * 59 + ($isPagingBorder == null ? 43 : ((Object)$isPagingBorder).hashCode());
        Float $contentMarginTop = this.getContentMarginTop();
        result = result * 59 + ($contentMarginTop == null ? 43 : ((Object)$contentMarginTop).hashCode());
        Float $contentMarginBottom = this.getContentMarginBottom();
        result = result * 59 + ($contentMarginBottom == null ? 43 : ((Object)$contentMarginBottom).hashCode());
        Float $contentMarginLeft = this.getContentMarginLeft();
        result = result * 59 + ($contentMarginLeft == null ? 43 : ((Object)$contentMarginLeft).hashCode());
        Float $contentMarginRight = this.getContentMarginRight();
        result = result * 59 + ($contentMarginRight == null ? 43 : ((Object)$contentMarginRight).hashCode());
        Color $backgroundColor = this.getBackgroundColor();
        result = result * 59 + ($backgroundColor == null ? 43 : ((Object)$backgroundColor).hashCode());
        Table $table = this.getTable();
        result = result * 59 + ($table == null ? 43 : ((Object)$table).hashCode());
        List<TableRow> $rows = this.getRows();
        result = result * 59 + ($rows == null ? 43 : ((Object)$rows).hashCode());
        HorizontalAlignment $contentHorizontalAlignment = this.getContentHorizontalAlignment();
        result = result * 59 + ($contentHorizontalAlignment == null ? 43 : ((Object)((Object)$contentHorizontalAlignment)).hashCode());
        VerticalAlignment $contentVerticalAlignment = this.getContentVerticalAlignment();
        result = result * 59 + ($contentVerticalAlignment == null ? 43 : ((Object)((Object)$contentVerticalAlignment)).hashCode());
        return result;
    }
}

