/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.core.base;

import java.util.Objects;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dromara.pdf.pdfbox.core.base.Context;
import org.dromara.pdf.pdfbox.core.enums.ContentMode;

public abstract class AbstractBase {
    protected final Log log = LogFactory.getLog(this.getClass());
    protected Context context;
    protected ContentMode contentMode;
    protected Boolean isResetContentStream;

    protected void init(Context context) {
        this.context = context;
        this.contentMode = ContentMode.APPEND;
        this.isResetContentStream = Boolean.TRUE;
    }

    protected void init(AbstractBase base) {
        this.context = base.context;
        if (Objects.isNull((Object)this.contentMode)) {
            this.contentMode = base.contentMode;
        }
        if (Objects.isNull(this.isResetContentStream)) {
            this.isResetContentStream = base.isResetContentStream;
        }
    }

    public Log getLog() {
        return this.log;
    }

    public Context getContext() {
        return this.context;
    }

    public ContentMode getContentMode() {
        return this.contentMode;
    }

    public Boolean getIsResetContentStream() {
        return this.isResetContentStream;
    }

    public void setContext(Context context) {
        this.context = context;
    }

    public void setContentMode(ContentMode contentMode) {
        this.contentMode = contentMode;
    }

    public void setIsResetContentStream(Boolean isResetContentStream) {
        this.isResetContentStream = isResetContentStream;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractBase)) {
            return false;
        }
        AbstractBase other = (AbstractBase)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$isResetContentStream = this.getIsResetContentStream();
        Boolean other$isResetContentStream = other.getIsResetContentStream();
        if (this$isResetContentStream == null ? other$isResetContentStream != null : !((Object)this$isResetContentStream).equals(other$isResetContentStream)) {
            return false;
        }
        Log this$log = this.getLog();
        Log other$log = other.getLog();
        if (this$log == null ? other$log != null : !this$log.equals(other$log)) {
            return false;
        }
        Context this$context = this.getContext();
        Context other$context = other.getContext();
        if (this$context == null ? other$context != null : !((Object)this$context).equals(other$context)) {
            return false;
        }
        ContentMode this$contentMode = this.getContentMode();
        ContentMode other$contentMode = other.getContentMode();
        return !(this$contentMode == null ? other$contentMode != null : !((Object)((Object)this$contentMode)).equals((Object)other$contentMode));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AbstractBase;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $isResetContentStream = this.getIsResetContentStream();
        result = result * 59 + ($isResetContentStream == null ? 43 : ((Object)$isResetContentStream).hashCode());
        Log $log = this.getLog();
        result = result * 59 + ($log == null ? 43 : $log.hashCode());
        Context $context = this.getContext();
        result = result * 59 + ($context == null ? 43 : ((Object)$context).hashCode());
        ContentMode $contentMode = this.getContentMode();
        result = result * 59 + ($contentMode == null ? 43 : ((Object)((Object)$contentMode)).hashCode());
        return result;
    }

    public String toString() {
        return "AbstractBase(log=" + this.getLog() + ", context=" + this.getContext() + ", contentMode=" + (Object)((Object)this.getContentMode()) + ", isResetContentStream=" + this.getIsResetContentStream() + ")";
    }
}

