/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.util;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDFontDescriptor;
import org.dromara.pdf.pdfbox.core.base.Context;
import org.dromara.pdf.pdfbox.support.Constants;

public class TextUtil {
    public static float getTextWidth(String text, Context context, List<String> specialFontNames, String fontName, float fontSize, float characterSpacing) {
        if (Objects.isNull(text)) {
            return 0.0f;
        }
        Objects.requireNonNull(context, "the context can not be null");
        Objects.requireNonNull(fontName, "the font name can not be null");
        PDFont font = context.getFont(fontName);
        float width = 0.0f;
        int length = text.length();
        for (int i = 0; i < length; ++i) {
            char character = text.charAt(i);
            try {
                width += font.getCharacterWidth(character);
                continue;
            }
            catch (Exception e) {
                boolean flag = true;
                if (Objects.nonNull(specialFontNames)) {
                    for (String specialFontName : specialFontNames) {
                        try {
                            width += context.getFont(specialFontName).getCharacterWidth(character);
                            flag = false;
                            break;
                        }
                        catch (Exception exception) {
                        }
                    }
                    if (flag && i + 1 < length) {
                        char next = text.charAt(i + 1);
                        String str = String.valueOf(new char[]{character, next});
                        for (String specialFontName : specialFontNames) {
                            try {
                                width += context.getFont(specialFontName).getStringWidth(str);
                                flag = false;
                                break;
                            }
                            catch (Exception exception) {
                            }
                        }
                        if (!flag) {
                            ++i;
                        }
                    }
                }
                if (!flag) continue;
                width += context.getFont("HarmonyOS_Sans_SC").getCharacterWidth(Constants.DEFAULT_UNKNOWN_CHARACTER.charValue());
            }
        }
        return width == 0.0f ? 0.0f : fontSize * width / 1000.0f + (float)(text.length() - 1) * characterSpacing;
    }

    public static float getTextHeight(Context context, String fontName, float fontSize, float leading, int rowCount) {
        if (rowCount == 0) {
            return 0.0f;
        }
        float height = TextUtil.getFontHeight(context.getFont(fontName), fontSize);
        if (rowCount == 1) {
            return height;
        }
        int leadingCount = rowCount - 1;
        return (float)rowCount * height + (float)leadingCount * leading;
    }

    public static float getFontHeight(PDFont font, float fontSize) {
        PDFontDescriptor fontDescriptor = font.getFontDescriptor();
        float ascent = fontDescriptor.getAscent();
        float descent = fontDescriptor.getDescent();
        return (ascent - descent) / 1000.0f * fontSize;
    }

    public static String escapeForRegex(String text) {
        char[] charArray;
        if (TextUtil.isBlank(text)) {
            return "";
        }
        char[] escapeChars = new char[]{'$', '(', ')', '*', '+', '.', '[', ']', '?', '\\', '^', '{', '}', '|'};
        StringBuilder builder = new StringBuilder();
        for (char c : charArray = text.toCharArray()) {
            for (char escapeChar : escapeChars) {
                if (escapeChar != c) continue;
                builder.append('\\');
                break;
            }
            builder.append(c);
        }
        return builder.toString();
    }

    public static String filterAll(String text) {
        return text.replaceAll("[\r\b\f]", "");
    }

    public static String replaceAll(String text, Map<String, String> replaceMap) {
        if (TextUtil.isBlank(text)) {
            return "";
        }
        if (Objects.isNull(replaceMap) || replaceMap.isEmpty()) {
            return text;
        }
        String temp = text;
        Set<Map.Entry<String, String>> entrySet = replaceMap.entrySet();
        for (Map.Entry<String, String> entry : entrySet) {
            temp = temp.replaceAll(entry.getKey(), entry.getValue());
        }
        return temp;
    }

    public static boolean isBlank(String text) {
        return !TextUtil.isNotBlank(text);
    }

    public static boolean isNotBlank(String text) {
        return Objects.nonNull(text) && !text.trim().isEmpty();
    }

    public static boolean isEnglishCharacter(Character character) {
        if (character.charValue() >= 'A' && character.charValue() <= 'Z') {
            return true;
        }
        if (character.charValue() >= 'a' && character.charValue() <= 'z') {
            return true;
        }
        return character.charValue() == ',' || character.charValue() == '.' || character.charValue() == '?' || character.charValue() == '!' || character.charValue() == '-' || character.charValue() == '+' || character.charValue() == '*' || character.charValue() == '/';
    }

    public static String spacing(int size) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < size; ++i) {
            builder.append(Constants.SPACE_CHARACTER);
        }
        return builder.toString();
    }

    public static String replaceTab(String text, int size) {
        char[] charArray = TextUtil.filterAll(text).toCharArray();
        StringBuilder builder = new StringBuilder();
        StringBuilder temp = new StringBuilder();
        for (char c : charArray) {
            if (c == Constants.TAB_CHARACTER.charValue()) {
                temp.append(TextUtil.spacing(size));
                continue;
            }
            temp.append(c);
        }
        return builder.append((CharSequence)temp).toString();
    }
}

