/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.util;

public class IdUtil {
    private static final Snowflake SNOWFLAKE = new Snowflake(0L, 0L);

    public static String get() {
        return SNOWFLAKE.nextIdStr();
    }

    private static final class Snowflake {
        private static final long EPOCH = 946656000000L;
        private final long workerId;
        private final long dataCenterId;
        private long lastTimestamp = -1L;
        private long offset = 0L;
        private long sequence = 0L;

        public Snowflake(long workerId, long dataCenterId) {
            long maxWorkerId = 31L;
            if (workerId > maxWorkerId || workerId < 0L) {
                throw new IllegalArgumentException(String.format("worker Id can't be greater than %s or less than 0", maxWorkerId));
            }
            this.workerId = workerId;
            this.dataCenterId = dataCenterId;
        }

        public synchronized long nextId() {
            long timestamp;
            long currentTime = System.currentTimeMillis();
            if (currentTime >= this.lastTimestamp) {
                this.offset = 0L;
            }
            if ((timestamp = currentTime + this.offset) < this.lastTimestamp) {
                timestamp = this.processBackTime(timestamp);
            }
            if (this.lastTimestamp == timestamp) {
                this.sequence = this.sequence + 1L & 3L;
                if (this.sequence == 0L) {
                    timestamp = this.tilNextMillis();
                }
            } else {
                this.sequence = 0L;
            }
            this.lastTimestamp = timestamp;
            return timestamp - 946656000000L << 22 | this.dataCenterId << 17 | this.workerId << 2 | this.sequence;
        }

        public String nextIdStr() {
            return Long.toString(this.nextId());
        }

        private long tilNextMillis() {
            long timestamp = System.currentTimeMillis() + this.offset;
            while (timestamp <= this.lastTimestamp) {
                timestamp = System.currentTimeMillis() + this.offset;
                if (timestamp >= this.lastTimestamp) continue;
                timestamp = this.processBackTime(timestamp);
                this.sequence = 0L;
            }
            return timestamp;
        }

        private long processBackTime(long timestamp) {
            this.offset = this.lastTimestamp - timestamp;
            return this.lastTimestamp + 1L;
        }
    }
}

